/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import java.util.Arrays;
import ucar.unidata.view.sounding.AerologicalCoordinateSystem;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.CommonUnits;
import visad.CommonUnit;
import visad.Display;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public final class SkewTCoordinateSystem
extends AerologicalCoordinateSystem {
    private static SkewTCoordinateSystem defaultCS;
    private final Real minimumX;
    private final Real maximumX;
    private final Real minimumY;
    private final Real maximumY;
    private final Real minimumPressure;
    private final Real maximumPressure;
    private final Real minimumTemperature;
    private final Real maximumTemperature;
    private final Real isothermTangent;
    private final Real temperaturePerLogPressure;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private final double minP;
    private final double maxP;
    private final double minT;
    private final double maxT;
    private final double tangent;
    private final double yPerLogP;
    private final double logMinP;
    private final double xPerT;
    public static final Real DEFAULT_MINIMUM_PRESSURE;
    public static final Real DEFAULT_MAXIMUM_PRESSURE;
    public static final Real DEFAULT_MINIMUM_TEMPERATURE;
    public static final Real DEFAULT_MAXIMUM_TEMPERATURE;
    public static final Real DEFAULT_ISOTHERM_TANGENT;
    public static final Real DEFAULT_TEMPERATURE_PER_LOG_PRESSURE;
    private static final Real ONE;
    private static final Real NEGATIVE_ONE;

    private SkewTCoordinateSystem(RealTupleType referenceTupleType, Real minimumPressure, Real maximumPressure, Real minimumTemperature, Real maximumTemperature, Real isothermTangent, Real temperaturePerLogPressure, Unit pressureUnit, Unit temperatureUnit, Real minimumX, Real maximumX, Real minimumY, Real maximumY) throws UnitException, VisADException {
        super(referenceTupleType, SkewTCoordinateSystem.makeCSUnits(referenceTupleType.getDimension(), pressureUnit, temperatureUnit));
        double radius;
        this.minimumPressure = minimumPressure;
        this.maximumPressure = maximumPressure;
        this.minimumTemperature = minimumTemperature;
        this.maximumTemperature = maximumTemperature;
        this.isothermTangent = isothermTangent;
        this.temperaturePerLogPressure = temperaturePerLogPressure;
        RealType xType = (RealType)referenceTupleType.getComponent(0);
        RealType yType = (RealType)referenceTupleType.getComponent(1);
        Unit xUnit = xType.getDefaultUnit();
        Unit yUnit = yType.getDefaultUnit();
        this.minX = minimumX.getValue(xUnit);
        this.maxX = maximumX.getValue(xUnit);
        this.minY = minimumY.getValue(yUnit);
        this.maxY = maximumY.getValue(yUnit);
        Real verticalTemperatureChange = null;
        Real lowerLeftTemperature = null;
        double aspectRatio = Double.NaN;
        try {
            verticalTemperatureChange = (Real)maximumPressure.divide(minimumPressure).log().multiply(temperaturePerLogPressure);
            lowerLeftTemperature = (Real)minimumTemperature.add(verticalTemperatureChange);
            aspectRatio = ((Real)verticalTemperatureChange.divide(maximumTemperature.subtract(lowerLeftTemperature)).multiply(isothermTangent)).getValue();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (aspectRatio <= (this.maxY - this.minY) / (this.maxX - this.minX)) {
            radius = (this.maxX - this.minX) * aspectRatio / 2.0;
            this.minY = -radius;
            this.maxY = radius;
        } else {
            radius = (this.maxY - this.minY) / (aspectRatio * 2.0);
            this.minX = -radius;
            this.maxX = radius;
        }
        this.minimumX = new Real(xType, this.minX);
        this.maximumX = new Real(xType, this.maxX);
        this.minimumY = new Real(yType, this.minY);
        this.maximumY = new Real(yType, this.maxY);
        this.minP = minimumPressure.getValue(pressureUnit);
        this.maxP = maximumPressure.getValue(pressureUnit);
        this.minT = minimumTemperature.getValue(temperatureUnit);
        this.maxT = maximumTemperature.getValue(temperatureUnit);
        this.tangent = isothermTangent.getValue(CommonUnit.dimensionless);
        double minTAtMaxP = lowerLeftTemperature.getValue(temperatureUnit);
        this.logMinP = (float)Math.log(this.minP);
        this.yPerLogP = (float)((this.minY - this.maxY) / (Math.log(this.maxP) - this.logMinP));
        this.xPerT = (this.maxX - this.minX) / (this.maxT - minTAtMaxP);
    }

    public static SkewTCoordinateSystem instance() throws VisADException {
        return defaultCS;
    }

    public static SkewTCoordinateSystem instance(RealTupleType referenceTupleType) throws VisADException {
        return SkewTCoordinateSystem.instance(referenceTupleType, DEFAULT_MINIMUM_PRESSURE, DEFAULT_MAXIMUM_PRESSURE, DEFAULT_MINIMUM_TEMPERATURE, DEFAULT_MAXIMUM_TEMPERATURE, DEFAULT_ISOTHERM_TANGENT, DEFAULT_TEMPERATURE_PER_LOG_PRESSURE, AirPressure.getRealType().getDefaultUnit(), AirTemperature.getRealType().getDefaultUnit(), NEGATIVE_ONE, ONE, NEGATIVE_ONE, ONE);
    }

    public static SkewTCoordinateSystem instance(RealTupleType referenceTupleType, Real minimumPressure, Real maximumPressure, Real minimumTemperature, Real maximumTemperature, Real isothermTangent, Real temperaturePerLogPressure, Unit pressureUnit, Unit temperatureUnit, Real minimumX, Real maximumX, Real minimumY, Real maximumY) throws UnitException, VisADException {
        return new SkewTCoordinateSystem(referenceTupleType, minimumPressure, maximumPressure, minimumTemperature, maximumTemperature, isothermTangent, temperaturePerLogPressure, pressureUnit, temperatureUnit, minimumX, maximumX, minimumY, maximumY);
    }

    @Override
    public Real getMinimumPressure() {
        return this.minimumPressure;
    }

    @Override
    public Real getMaximumPressure() {
        return this.maximumPressure;
    }

    @Override
    public Real getMinimumTemperature() {
        return this.minimumTemperature;
    }

    @Override
    public Real getMaximumTemperature() {
        return this.maximumTemperature;
    }

    public Real getIsothermTangent() {
        return this.isothermTangent;
    }

    public Real getTemperaturePerLogPressure() {
        return this.temperaturePerLogPressure;
    }

    @Override
    public Real getMinimumX() {
        return this.minimumX;
    }

    @Override
    public Real getMaximumX() {
        return this.maximumX;
    }

    @Override
    public Real getMinimumY() {
        return this.minimumY;
    }

    @Override
    public Real getMaximumY() {
        return this.maximumY;
    }

    @Override
    public double[][] toReference(double[][] coords) {
        if (coords == null || coords.length < 2) {
            throw new IllegalArgumentException("Invalid real coordinates");
        }
        int npts = coords[0].length;
        double[] x = coords[0];
        double[] y = coords[1];
        for (int i = 0; i < npts; ++i) {
            double pressure = x[i];
            double temperature = y[i];
            double deltaY = this.yPerLogP * (Math.log(pressure) - this.logMinP);
            x[i] = this.xPerT * (temperature - this.minT) + this.minX + deltaY / this.tangent;
            y[i] = this.maxY + deltaY;
        }
        return coords;
    }

    @Override
    public double[][] fromReference(double[][] coords) {
        if (coords == null || coords.length < 2) {
            throw new IllegalArgumentException("Invalid real coordinates");
        }
        int npts = coords[0].length;
        double[] pressures = coords[0];
        double[] temperatures = coords[1];
        for (int i = 0; i < npts; ++i) {
            double x = pressures[i];
            double deltaY = temperatures[i] - this.maxY;
            pressures[i] = Math.exp(deltaY / this.yPerLogP + this.logMinP);
            temperatures[i] = (x - deltaY / this.tangent - this.minX) / this.xPerT + this.minT;
        }
        return coords;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SkewTCoordinateSystem)) {
            return false;
        }
        SkewTCoordinateSystem that = (SkewTCoordinateSystem)obj;
        return that.minX == this.minX && that.maxX == this.maxX && that.minY == this.minY && that.maxY == this.maxY && that.minP == this.minP && that.maxP == this.maxP && that.minT == this.minT && that.maxT == this.maxT && that.tangent == this.tangent && that.yPerLogP == this.yPerLogP && that.logMinP == this.logMinP && that.xPerT == this.xPerT && that.minimumX.equals(this.minimumX) && that.maximumX.equals(this.maximumX) && that.minimumY.equals(this.minimumY) && that.maximumY.equals(this.maximumY) && this.getReference().equals(that.getReference()) && Arrays.equals(this.getCoordinateSystemUnits(), that.getCoordinateSystemUnits());
    }

    public int hashCode() {
        return new Double(this.minX).hashCode() ^ new Double(this.maxX).hashCode() ^ new Double(this.minY).hashCode() ^ new Double(this.maxY).hashCode() ^ new Double(this.minP).hashCode() ^ new Double(this.maxP).hashCode() ^ new Double(this.minT).hashCode() ^ new Double(this.maxT).hashCode() ^ new Double(this.tangent).hashCode() ^ new Double(this.yPerLogP).hashCode() ^ new Double(this.logMinP).hashCode() ^ new Double(this.xPerT).hashCode() ^ this.minimumX.hashCode() ^ this.maximumX.hashCode() ^ this.minimumY.hashCode() ^ this.maximumY.hashCode() ^ this.getReference().hashCode() ^ Arrays.asList(this.getCoordinateSystemUnits()).hashCode();
    }

    public static void main(String[] args) throws Exception {
        int i;
        SkewTCoordinateSystem cs = SkewTCoordinateSystem.instance();
        double[][] coords = new double[][]{{0.0, cs.minX, cs.maxX, cs.maxX, cs.minX}, {0.0, cs.minY, cs.minY, cs.maxY, cs.maxY}, {0.0, 0.0, 0.0, 0.0, 0.0}};
        int npts = coords[0].length;
        System.out.println("(X,Y) Coordinates: ");
        for (i = 0; i < npts; ++i) {
            System.out.println("    (" + coords[0][i] + "," + coords[1][i] + ")");
        }
        cs.fromReference(coords);
        System.out.println("(P,T) Coordinates: ");
        for (i = 0; i < npts; ++i) {
            System.out.println("    (" + coords[0][i] + "," + coords[1][i] + ")");
        }
        cs.toReference(coords);
        System.out.println("(X,Y) Coordinates: ");
        for (i = 0; i < npts; ++i) {
            System.out.println("    (" + coords[0][i] + "," + coords[1][i] + ")");
        }
    }

    private static Unit[] makeCSUnits(int rank, Unit pressureUnit, Unit temperatureUnit) {
        Object[] csUnits = new Unit[rank];
        csUnits[0] = pressureUnit;
        csUnits[1] = temperatureUnit;
        Arrays.fill(csUnits, 2, rank, null);
        return csUnits;
    }

    @Override
    public AerologicalCoordinateSystem createDisplayCoordinateSystem(AerologicalCoordinateSystem acs) throws VisADException {
        if (!(acs instanceof SkewTCoordinateSystem)) {
            throw new IllegalArgumentException("coordinate system must be of same type");
        }
        if (acs.getDimension() == 3) {
            return acs;
        }
        SkewTCoordinateSystem scs = (SkewTCoordinateSystem)acs;
        Object newCS = null;
        return new SkewTCoordinateSystem(Display.DisplaySpatialCartesianTuple, scs.minimumPressure, scs.maximumPressure, scs.minimumTemperature, scs.maximumTemperature, scs.isothermTangent, scs.temperaturePerLogPressure, scs.getCoordinateSystemUnits()[0], scs.getCoordinateSystemUnits()[1], scs.minimumX, scs.maximumX, scs.minimumY, scs.maximumY);
    }

    static {
        try {
            DEFAULT_MINIMUM_PRESSURE = new Real(AirPressure.getRealType(), 100.0, CommonUnits.HECTOPASCAL);
            DEFAULT_MAXIMUM_PRESSURE = new Real(AirPressure.getRealType(), 1050.0, CommonUnits.HECTOPASCAL);
            DEFAULT_MINIMUM_TEMPERATURE = new Real(AirTemperature.getRealType(), -122.5, CommonUnits.CELSIUS);
            DEFAULT_MAXIMUM_TEMPERATURE = new Real(AirTemperature.getRealType(), 52.0, CommonUnits.CELSIUS);
            RealType itt = RealType.getRealType("SkewTIsothermTangent", CommonUnit.dimensionless, null);
            DEFAULT_ISOTHERM_TANGENT = new Real(itt, 1.09);
            RealType tplpt = RealType.getRealType("SkewTTemperaturePerLogPressure", (Unit)SI.kelvin, null);
            DEFAULT_TEMPERATURE_PER_LOG_PRESSURE = new Real(tplpt, 32.534152);
            ONE = new Real(RealType.getRealType("SkewTCoordinateSystemOne"), 1.0);
            NEGATIVE_ONE = new Real(RealType.getRealType("SkewTCoordinateSystemNegativeOne"), -1.0);
            defaultCS = new SkewTCoordinateSystem(new RealTupleType(new RealType[]{RealType.XAxis, RealType.YAxis}), DEFAULT_MINIMUM_PRESSURE, DEFAULT_MAXIMUM_PRESSURE, DEFAULT_MINIMUM_TEMPERATURE, DEFAULT_MAXIMUM_TEMPERATURE, DEFAULT_ISOTHERM_TANGENT, DEFAULT_TEMPERATURE_PER_LOG_PRESSURE, AirPressure.getRealType().getDefaultUnit(), AirTemperature.getRealType().getDefaultUnit(), NEGATIVE_ONE, ONE, NEGATIVE_ONE, ONE);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't initialize class: " + e);
        }
    }
}

