/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import visad.Data;
import visad.DataReference;
import visad.Real;
import visad.VisADException;

public final class SelectorCell
extends ComputeCell {
    private final Data noData;

    public SelectorCell(DataReference indexRef, DataReference[] refs, Data noData) throws VisADException, RemoteException {
        super("SelectorCell", SelectorCell.makeDataReferences(indexRef, refs), noData);
        if (refs.length == 0) {
            throw new IllegalArgumentException();
        }
        this.noData = noData;
        this.enableAllInputRefs();
    }

    private static DataReference[] makeDataReferences(DataReference indexRef, DataReference[] refs) {
        DataReference[] newRefs = new DataReference[1 + refs.length];
        newRefs[0] = indexRef;
        System.arraycopy(refs, 0, newRefs, 1, refs.length);
        return newRefs;
    }

    @Override
    protected Data compute(Data[] datums) throws VisADException, RemoteException {
        Data output = this.noData;
        Real index = (Real)datums[0];
        if (index != null) {
            output = datums[(int)(1.0 + index.getValue())];
        }
        return output;
    }
}

