/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import java.text.NumberFormat;
import ucar.visad.display.LineDrawing;
import visad.Data;
import visad.Display;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.VisADException;

public abstract class ScaleLabels
extends LineDrawing {
    private float xAlignment = 0.0f;
    private float[] values;
    private float size = 1.0f;
    private RealType realType;
    private Text[] labels;
    private float[] positionValues;
    private TextType textType;
    private TextControl textControl;
    private NumberFormat format = NumberFormat.getInstance();

    protected ScaleLabels(String name, RealType axisType) throws RemoteException, VisADException {
        super(name);
        this.textType = TextType.getTextType(name + "ScaleLabel");
        this.realType = axisType;
        ScalarMap textMap = ScaleLabels.newTextMap(this.textType);
        this.addTextMapListener(textMap);
        this.addScalarMap(textMap);
    }

    protected ScaleLabels(ScaleLabels that) throws RemoteException, VisADException {
        super(that);
        this.xAlignment = that.xAlignment;
        this.values = (float[])that.values.clone();
        this.size = that.size;
        this.realType = that.realType;
        this.labels = (Text[])that.labels.clone();
        this.positionValues = (float[])that.positionValues.clone();
        this.textType = that.textType;
        this.addTextMapListener(this.getScalarMap(ScaleLabels.newTextMap(that.textType)));
        this.format = (NumberFormat)that.format.clone();
    }

    private static ScalarMap newTextMap(TextType textType) throws VisADException {
        return new ScalarMap(textType, Display.Text);
    }

    private void addTextMapListener(final ScalarMap textMap) {
        textMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block5: {
                    block4: {
                        int id = event.getId();
                        if (id == 3) break block4;
                        if (id != 5) break block5;
                    }
                    ScaleLabels.this.textControl = (TextControl)textMap.getControl();
                    ScaleLabels.this.textControl.setSize(ScaleLabels.this.size);
                    if (ScaleLabels.this.xAlignment == 0.5f) {
                        ScaleLabels.this.textControl.setCenter(true);
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) {
            }
        });
    }

    public void setSize(double size) throws VisADException, RemoteException {
        this.size = (float)size;
        if (this.textControl != null) {
            this.textControl.setSize(size);
        }
    }

    public void setXAlignment(float alignment) throws VisADException, RemoteException {
        this.xAlignment = alignment;
        if (alignment == 0.5f && this.textControl != null) {
            this.textControl.setCenter(true);
        } else {
            this.setLabels();
        }
    }

    public void setRealType(RealType realType) throws VisADException, RemoteException {
        this.realType = realType;
    }

    public void setFormat(NumberFormat format) throws RemoteException, VisADException {
        this.format = format;
        this.setLabels();
    }

    public void setLabelValues(float[] values) throws VisADException, RemoteException {
        this.values = (float[])values.clone();
        this.setLabels();
    }

    protected void setLabels() throws VisADException, RemoteException {
        if (this.values != null) {
            int maxWidth = 0;
            String[] strings = new String[this.values.length];
            int i = this.values.length;
            while (--i >= 0) {
                String label = this.format.format(this.values[i]).trim();
                int width = label.length();
                if (width > maxWidth) {
                    maxWidth = width;
                }
                strings[i] = label;
            }
            if (this.labels == null || this.labels.length != this.values.length) {
                this.labels = new Text[this.values.length];
            }
            StringBuffer labelBuf = new StringBuffer(maxWidth);
            int i2 = this.values.length;
            while (--i2 >= 0) {
                String label;
                if (this.xAlignment != 1.0f) {
                    label = strings[i2];
                } else {
                    for (int j = strings[i2].length(); j < maxWidth; ++j) {
                        labelBuf.append(" ");
                    }
                    labelBuf.append(strings[i2]);
                    label = labelBuf.toString();
                    labelBuf.setLength(0);
                }
                this.labels[i2] = new Text(this.textType, label);
            }
            this.setData();
        }
    }

    public void setPositionValues(float[] values) throws VisADException, RemoteException {
        this.positionValues = (float[])values.clone();
        this.setData();
    }

    private void setData() throws VisADException, RemoteException {
        Data data = this.computeData();
        if (data != null) {
            this.setData(data);
        }
    }

    private Data computeData() throws VisADException, RemoteException {
        FieldImpl field;
        if (this.realType == null || this.positionValues == null || this.labels == null || this.positionValues.length != this.labels.length) {
            field = null;
        } else {
            field = new FieldImpl(new FunctionType(this.realType, this.textType), new Gridded1DSet((MathType)this.realType, (float[][])new float[][]{this.positionValues}, this.positionValues.length));
            field.setSamples(this.labels, false);
        }
        return field;
    }
}

