/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.AerologicalCoordinateSystem;
import ucar.unidata.view.sounding.BackgroundContours;
import ucar.unidata.view.sounding.SkewTCoordinateSystem;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.display.Displayable;
import ucar.visad.display.IrregularContourLevels;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.SaturationMixingRatio;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScaledUnit;
import visad.Set;
import visad.TypeException;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public final class SaturationMixingRatioContours
extends BackgroundContours {
    private float rangeMaximum;
    private float rangeMinimum;
    private static RealType pressureType;
    private static RealType rangeType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RealType getPressureType() throws VisADException {
        if (pressureType != null) return pressureType;
        Class<SaturationMixingRatioContours> clazz = SaturationMixingRatioContours.class;
        synchronized (SaturationMixingRatioContours.class) {
            if (pressureType != null) return pressureType;
            pressureType = Util.clone(AirPressure.getRealType(), "BackgroundContoursSaturationMixingRatioContoursPressureType");
            // ** MonitorExit[var0] (shouldn't be in output)
            return pressureType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RealType getRangeType() throws VisADException {
        if (rangeType != null) return rangeType;
        Class<SaturationMixingRatioContours> clazz = SaturationMixingRatioContours.class;
        synchronized (SaturationMixingRatioContours.class) {
            if (rangeType != null) return rangeType;
            rangeType = Util.clone(SaturationMixingRatio.getRealType(), "BackgroundContoursSaturationMixingRatioContoursRangeType");
            // ** MonitorExit[var0] (shouldn't be in output)
            return rangeType;
        }
    }

    public SaturationMixingRatioContours() throws VisADException, RemoteException {
        this(SkewTCoordinateSystem.instance());
    }

    public SaturationMixingRatioContours(AerologicalCoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        super("SaturationMixingRatioContours", new IrregularContourLevels(SaturationMixingRatio.getRealType().getDefaultUnit().toThis(new float[]{0.001f, 0.005f, 0.01f, 0.025f, 0.05f, 0.1f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 12.0f, 14.0f, 16.0f, 18.0f, 20.0f, 24.0f, 28.0f, 32.0f, 36.0f, 40.0f, 44.0f, 48.0f, 52.0f, 56.0f, 60.0f, 68.0f, 76.0f}, (Unit)new ScaledUnit(0.001)), Float.POSITIVE_INFINITY, true), SaturationMixingRatioContours.getRangeType());
        this.coordinateSystemChange(coordinateSystem);
        this.setHSV(new float[]{120.0f, 0.5f, 0.9f});
        this.setLabeling(true);
    }

    protected SaturationMixingRatioContours(SaturationMixingRatioContours that) throws RemoteException, VisADException {
        super(that);
        this.rangeMaximum = that.rangeMaximum;
        this.rangeMinimum = that.rangeMinimum;
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new SaturationMixingRatioContours(this);
    }

    @Override
    protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws TypeException, RemoteException, VisADException {
        try {
            FlatField ptField = VisADMath.fromReference(new FunctionType(RealTupleType.SpatialCartesian2DTuple, new RealTupleType((RealType)coordinateSystem.getMinimumPressure().getType(), (RealType)coordinateSystem.getMinimumTemperature().getType(), coordinateSystem, (Set)null)), VisADMath.newFlatField(new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, coordinateSystem.getMinimumX().getValue(), coordinateSystem.getMaximumX().getValue(), 40, coordinateSystem.getMinimumY().getValue(), coordinateSystem.getMaximumY().getValue(), 40)));
            this.field = (FlatField)Util.ensureMathType(SaturationMixingRatio.create(ptField.extract(0), ptField.extract(1)), SaturationMixingRatioContours.getRangeType());
            this.setData(this.field);
            Unit tempUnit = SaturationMixingRatio.getRealType().getDefaultUnit();
            this.rangeMinimum = (float)((Real)this.field.evaluate(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new Real[]{coordinateSystem.getMinimumX(), coordinateSystem.getMaximumY()}, null))).getValue(tempUnit);
            this.rangeMaximum = (float)((Real)this.field.evaluate(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new Real[]{coordinateSystem.getMaximumX(), coordinateSystem.getMaximumY()}, null))).getValue(tempUnit);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
    }

    protected float getRangeMinimum() {
        return this.rangeMinimum;
    }

    protected float getRangeMaximum() {
        return this.rangeMaximum;
    }
}

