/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.AerologicalCoordinateSystem;
import ucar.unidata.view.sounding.BackgroundContours;
import ucar.unidata.view.sounding.SkewTCoordinateSystem;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.display.Displayable;
import ucar.visad.display.RegularContourLevels;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.SaturationEquivalentPotentialTemperature;
import visad.CoordinateSystem;
import visad.EmpiricalCoordinateSystem;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.TypeException;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public final class SaturationAdiabats
extends BackgroundContours {
    private float rangeMaximum;
    private float rangeMinimum;
    private static RealType pressureType;
    private static RealType rangeType;
    private CoordinateSystem coordSys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RealType getPressureType() throws VisADException {
        if (pressureType != null) return pressureType;
        Class<SaturationAdiabats> clazz = SaturationAdiabats.class;
        synchronized (SaturationAdiabats.class) {
            if (pressureType != null) return pressureType;
            pressureType = Util.clone(AirPressure.getRealType(), "BackgroundContoursSaturationAdiabatsPressureType");
            // ** MonitorExit[var0] (shouldn't be in output)
            return pressureType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RealType getRangeType() throws VisADException {
        if (rangeType != null) return rangeType;
        Class<SaturationAdiabats> clazz = SaturationAdiabats.class;
        synchronized (SaturationAdiabats.class) {
            if (rangeType != null) return rangeType;
            rangeType = Util.clone(SaturationEquivalentPotentialTemperature.getRealType(), "BackgroundContoursSaturationAdiabatsRangeType");
            // ** MonitorExit[var0] (shouldn't be in output)
            return rangeType;
        }
    }

    public SaturationAdiabats() throws VisADException, RemoteException {
        this(SkewTCoordinateSystem.instance());
    }

    public SaturationAdiabats(AerologicalCoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        super("SaturationAdiabats", new RegularContourLevels(20.0f), SaturationAdiabats.getRangeType());
        this.coordinateSystemChange(coordinateSystem);
        this.setHSV(new float[]{120.0f, 0.5f, 0.9f});
    }

    protected SaturationAdiabats(SaturationAdiabats that) throws RemoteException, VisADException {
        super(that);
        this.rangeMaximum = that.rangeMaximum;
        this.rangeMinimum = that.rangeMinimum;
        this.coordSys = that.coordSys;
    }

    @Override
    protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws TypeException, RemoteException, VisADException {
        try {
            int count = 20;
            FlatField ptField = VisADMath.fromReference(new FunctionType(RealTupleType.SpatialCartesian2DTuple, new RealTupleType(SaturationAdiabats.getPressureType(), SaturationAdiabats.getRangeType(), coordinateSystem, (Set)null)), VisADMath.newFlatField(new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, coordinateSystem.getMinimumX().getValue(), coordinateSystem.getMaximumX().getValue(), count, coordinateSystem.getMinimumY().getValue(), coordinateSystem.getMaximumY().getValue(), count)));
            FlatField pressureField = (FlatField)ptField.extract(0);
            FlatField temperatureField = (FlatField)ptField.extract(1);
            this.field = (FlatField)Util.ensureMathType(SaturationEquivalentPotentialTemperature.create(pressureField, temperatureField), SaturationAdiabats.getRangeType());
            this.setData(this.field);
            float[] pressures = pressureField.getFloats(false)[0];
            this.coordSys = new EmpiricalCoordinateSystem(new Gridded2DSet((MathType)new RealTupleType(SaturationAdiabats.getPressureType(), SaturationEquivalentPotentialTemperature.getRealType()), (float[][])new float[][]{pressures, this.field.getFloats(false)[0]}, count, count, (CoordinateSystem)null, new Unit[]{pressureField.getDefaultRangeUnits()[0], this.field.getDefaultRangeUnits()[0]}, null), new Gridded2DSet((MathType)new RealTupleType(SaturationAdiabats.getPressureType(), AirTemperature.getRealType()), (float[][])new float[][]{pressures, temperatureField.getFloats(false)[0]}, count, count, (CoordinateSystem)null, new Unit[]{pressureField.getDefaultRangeUnits()[0], temperatureField.getDefaultRangeUnits()[0]}, null));
            Unit tempUnit = SaturationEquivalentPotentialTemperature.getRealType().getDefaultUnit();
            this.rangeMinimum = (float)((Real)this.field.evaluate(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new Real[]{coordinateSystem.getMinimumX(), coordinateSystem.getMinimumY()}, null))).getValue(tempUnit);
            this.rangeMaximum = (float)((Real)this.field.evaluate(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new Real[]{coordinateSystem.getMaximumX(), coordinateSystem.getMinimumY()}, null))).getValue(tempUnit);
            this.setRange(this.rangeMinimum, this.rangeMaximum);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
    }

    protected float getRangeMinimum() {
        return this.rangeMinimum;
    }

    protected float getRangeMaximum() {
        return this.rangeMaximum;
    }

    public Real getTemperature(Real airPressure, Real satEquivPotTem) throws VisADException {
        return new Real(AirTemperature.getRealType(), this.coordSys.toReference(new double[][]{{airPressure.getValue(SaturationAdiabats.getPressureType().getDefaultUnit())}, {satEquivPotTem.getValue(SaturationEquivalentPotentialTemperature.getRealType().getDefaultUnit())}})[1][0]);
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new SaturationAdiabats(this);
    }
}

