/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import ucar.unidata.beans.NonVetoableProperty;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public class RealReadout
implements PropertyChangeListener {
    public static final int REALTYPE_NAME = 0;
    public static final int SPECIFIED_NAME = 1;
    public static final int REAL_UNIT = 0;
    public static final int REALTYPE_UNIT = 1;
    public static final int SPECIFIED_UNIT = 2;
    public static final String NAME = "name";
    public static final String FORMAT = "format";
    public static final String NUMERIC_STRING = "numericString";
    public static final String UNIT_STRING = "unitString";
    private Real real;
    private NameProperty nameProperty = new NameProperty();
    private FormatProperty formatProperty = new FormatProperty();
    private NumericValueProperty numericValueProperty = new NumericValueProperty();
    private UnitProperty unitProperty = new UnitProperty();

    public void setSpecifiedName(String name) {
        this.nameProperty.setSpecifiedName(name);
    }

    public void setNameUse(int which) {
        this.nameProperty.setNameUse(which);
    }

    public void setFormat(NumberFormat format) {
        this.formatProperty.setFormat(format);
    }

    public void setSpecifiedUnit(String unitString) throws NoSuchUnitException, ParseException {
        this.unitProperty.setSpecifiedUnit(unitString);
    }

    public void setUnitUse(int which) {
        this.unitProperty.setUnitUse(which);
    }

    public String getName() {
        return this.nameProperty.getQuantityName();
    }

    public String getNumericString() {
        return this.numericValueProperty.getNumericString();
    }

    public String getUnitString() {
        return this.unitProperty.getUnitString();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (NAME.equals(propertyName)) {
            this.nameProperty.addPropertyChangeListener(listener);
        } else if (NUMERIC_STRING.equals(propertyName)) {
            this.numericValueProperty.addPropertyChangeListener(listener);
        } else if (UNIT_STRING.equals(propertyName)) {
            this.unitProperty.addPropertyChangeListener(listener);
        }
    }

    public void setReal(Real real) {
        this.real = real;
        this.nameProperty.setValue(real);
        this.unitProperty.setValue(real);
        this.numericValueProperty.setValue(real);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.setReal((Real)event.getNewValue());
    }

    protected class UnitProperty
    extends NonVetoableProperty {
        private String specifiedUnitString;
        private Unit specifiedUnit;
        private int unitUse;
        private Unit unit;

        public UnitProperty() {
            super(RealReadout.this, RealReadout.UNIT_STRING);
            this.unitUse = 0;
        }

        public void setSpecifiedUnit(String specifiedUnitString) throws NoSuchUnitException, ParseException {
            this.specifiedUnitString = specifiedUnitString;
            this.specifiedUnit = Parser.parse(specifiedUnitString);
            if (this.unitUse == 2) {
                this.setValue(RealReadout.this.real);
                RealReadout.this.numericValueProperty.setValue(RealReadout.this.real);
            }
        }

        public void setUnitUse(int which) {
            this.unitUse = which;
            this.setValue(RealReadout.this.real);
            RealReadout.this.numericValueProperty.setValue(RealReadout.this.real);
        }

        public void setValue(Real real) {
            String unitString;
            if (this.unitUse == 2) {
                unitString = this.specifiedUnitString;
                this.unit = this.specifiedUnit;
            } else if (this.unitUse == 1) {
                this.unit = real == null ? null : ((RealType)real.getType()).getDefaultUnit();
                unitString = this.unit == null ? "<null>" : this.unit.toString();
            } else {
                this.unit = real == null ? null : real.getUnit();
                unitString = this.unit == null ? "<null>" : this.unit.toString();
            }
            super.setValueAndNotifyListeners(unitString);
        }

        public String getUnitString() {
            return (String)this.getValue();
        }

        public Unit getUnit() {
            return this.unit;
        }
    }

    protected class NumericValueProperty
    extends NonVetoableProperty {
        public NumericValueProperty() {
            super(RealReadout.this, RealReadout.NUMERIC_STRING);
            this.setValue("                ");
        }

        public void setValue(Real real) {
            if (real != null) {
                String numericString;
                try {
                    double value = real.getValue(RealReadout.this.unitProperty.getUnit());
                    numericString = value != value ? "" : RealReadout.this.formatProperty.getFormat().format(value);
                }
                catch (Exception e) {
                    numericString = "<error>";
                }
                super.setValueAndNotifyListeners(numericString);
            }
        }

        public String getNumericString() {
            return (String)this.getValue();
        }
    }

    protected class FormatProperty
    extends NonVetoableProperty {
        public FormatProperty() {
            super(RealReadout.this, RealReadout.FORMAT);
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMinimumFractionDigits(3);
            super.setValue(format);
        }

        public void setFormat(NumberFormat format) {
            super.setValueAndNotifyListeners(format.clone());
            RealReadout.this.numericValueProperty.setValue(RealReadout.this.real);
        }

        public NumberFormat getFormat() {
            return (NumberFormat)this.getValue();
        }
    }

    protected class NameProperty
    extends NonVetoableProperty {
        private String specifiedName;
        private int nameUse;

        public NameProperty() {
            super(RealReadout.this, RealReadout.NAME);
            this.nameUse = 0;
        }

        public void setNameUse(int which) {
            this.nameUse = which;
            if (this.nameUse == 1) {
                this.setValue(RealReadout.this.real);
            }
        }

        public void setValue(Real real) {
            super.setValueAndNotifyListeners(this.nameUse == 1 ? this.specifiedName : (real == null ? "<null>" : ((RealType)real.getType()).getOriginalName()));
        }

        public String getQuantityName() {
            return (String)this.getValue();
        }

        public void setSpecifiedName(String specifiedName) {
            this.specifiedName = specifiedName;
            if (this.nameUse == 1) {
                this.setValue(RealReadout.this.real);
            }
        }
    }
}

