/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JLabel;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public class Readout
implements PropertyChangeListener {
    public static final int REALTYPE_NAME = 0;
    public static final int SPECIFIED_NAME = 1;
    public static final int REAL_UNIT = 0;
    public static final int REALTYPE_UNIT = 1;
    public static final int SPECIFIED_UNIT = 2;
    public static final String NAME = "name";
    public static final String NUMERIC_STRING = "numericString";
    public static final String UNIT_STRING = "unitString";
    private Real real;
    private JLabel nameLabel = new JLabel("Name");
    private JLabel numericValueLabel = new JLabel("NaN", 4);
    private JLabel unitLabel = new JLabel("Unit");
    private int nameUse = 0;
    private int unitUse = 0;
    private String specifiedName;
    private String specifiedUnitString;
    private Unit specifiedUnit;
    private String name;
    private String numericString;
    private String unitString;
    private NumberFormat numberFormat = NumberFormat.getInstance();

    public void setSpecifiedName(String name) {
        this.specifiedName = name;
        if (1 == this.nameUse) {
            this.nameLabel.setText(this.specifiedName);
        }
    }

    public String getSpecifiedName() {
        return this.specifiedName;
    }

    public void setNameUse(int which) {
        this.nameUse = which;
        if (1 == this.nameUse) {
            this.nameLabel.setText(this.specifiedName);
        }
    }

    public int getNameUse() {
        return this.nameUse;
    }

    public void setSpecifiedUnit(String unitString) throws NoSuchUnitException, ParseException {
        this.specifiedUnitString = unitString;
        this.specifiedUnit = Parser.parse(this.specifiedUnitString);
        this.unitLabel.setText(unitString);
    }

    public String getSpecifiedUnit() {
        return this.specifiedUnitString;
    }

    public void setUnitUse(int which) {
        this.unitUse = which;
        this.numericValueLabel.setText(this.getNumericString(this.real));
        this.unitLabel.setText(this.getUnitString(this.real));
    }

    public int getUnitUse() {
        return this.unitUse;
    }

    public String getName() {
        return this.nameLabel.getText();
    }

    public String getNumericString() throws VisADException {
        return this.numericValueLabel.getText();
    }

    public String getUnitString() {
        return this.unitLabel.getText();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (NAME.equals(propertyName)) {
            this.nameLabel.addPropertyChangeListener(listener);
        } else if (NUMERIC_STRING.equals(propertyName)) {
            this.numericValueLabel.addPropertyChangeListener(listener);
        } else if (UNIT_STRING.equals(propertyName)) {
            this.unitLabel.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Real real;
        this.real = real = (Real)event.getNewValue();
        this.nameLabel.setText(this.getName(real));
        this.numericValueLabel.setText(this.getNumericString(real));
        this.unitLabel.setText(this.getUnitString(real));
    }

    public Component getNameComponent() {
        return this.nameLabel;
    }

    public Component getNumericValueComponent() {
        return this.numericValueLabel;
    }

    public Component getUnitComponent() {
        return this.unitLabel;
    }

    protected String getName(Real real) {
        return 1 == this.nameUse ? this.specifiedName : (real == null ? "<null>" : ((RealType)real.getType()).getName());
    }

    protected String getNumericString(Real real) {
        String numericString;
        try {
            double numericValue;
            switch (this.unitUse) {
                case 2: {
                    numericValue = real == null ? Double.NaN : real.getValue(this.specifiedUnit);
                    break;
                }
                case 1: {
                    numericValue = real == null ? Double.NaN : real.getValue(((RealType)real.getType()).getDefaultUnit());
                    break;
                }
                default: {
                    numericValue = real == null ? Double.NaN : real.getValue();
                }
            }
            numericString = this.numberFormat.format(numericValue);
        }
        catch (Exception e) {
            numericString = e.toString();
        }
        return numericString;
    }

    protected String getUnitString(Real real) {
        String unitString;
        switch (this.unitUse) {
            case 2: {
                unitString = this.specifiedUnitString;
                break;
            }
            case 1: {
                unitString = real == null ? "<null>" : ((RealType)real.getType()).getDefaultUnit().toString();
                break;
            }
            default: {
                unitString = real == null ? "<null>" : real.getUnit().toString();
            }
        }
        return unitString;
    }
}

