/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.quantities.AirPressure;
import visad.DataReference;
import visad.Real;
import visad.Unit;
import visad.VisADException;

public abstract class ProfileFeatureCell
extends ComputeCell {
    protected static final Real noData;

    public ProfileFeatureCell(String name, DataReference buoyProfileRef) throws VisADException, RemoteException {
        super(name, new DataReference[]{buoyProfileRef}, noData);
    }

    protected static final Real interpolatePres(double topPres, double topBuoy, double botPres, double botBuoy, Unit presUnit) throws VisADException {
        double pressure = (topPres * botBuoy - botPres * topBuoy) / (botBuoy - topBuoy);
        return new Real(AirPressure.getRealType(), pressure, presUnit);
    }

    static {
        try {
            noData = (Real)AirPressure.getRealType().missingData();
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            throw new RuntimeException();
        }
    }
}

