/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import java.util.Arrays;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.Util;
import ucar.visad.functiontypes.AtmosphericProfile;
import ucar.visad.quantities.AirPressure;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataReference;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.RealType;
import visad.SampledSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public final class ProfileCombinerCell
extends ComputeCell {
    private final FunctionType outType;
    private final Unit rangeUnit;
    private final FlatField noData;

    public ProfileCombinerCell(DataReference pro1Ref, DataReference pro2Ref, RealType rangeType) throws VisADException, RemoteException {
        super("ProfileCombinerCell", new DataReference[]{pro1Ref, pro2Ref}, ProfileCombinerCell.noDataField(rangeType));
        this.outType = new AtmosphericProfile(rangeType);
        this.rangeUnit = rangeType.getDefaultUnit();
        this.noData = ProfileCombinerCell.noDataField(rangeType);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        FlatField pro = this.noData;
        Field pro1 = (Field)datums[0];
        if (pro1 != null) {
            Util.vetType(this.outType, pro1);
            Field pro2 = (Field)datums[1];
            if (pro2 != null) {
                Unit range2Unit;
                Util.vetType(this.outType, pro2);
                SampledSet dom1 = (SampledSet)pro1.getDomainSet();
                SampledSet dom2 = (SampledSet)pro2.getDomainSet();
                Unit dom1Unit = dom1.getSetUnits()[0];
                Unit dom2Unit = dom2.getSetUnits()[0];
                if (!Unit.canConvert(dom1Unit, dom2Unit)) {
                    throw new TypeException("dom1Unit=" + dom1Unit + "; dom2Unit=" + dom2Unit);
                }
                Unit range1Unit = pro1.getDefaultRangeUnits()[0];
                if (!Unit.canConvert(range1Unit, range2Unit = pro2.getDefaultRangeUnits()[0])) {
                    throw new TypeException("range1Unit=" + range1Unit + "; range2Unit=" + range2Unit);
                }
                CoordinateSystem coordSys1 = Util.getRangeCoordinateSystem(pro1);
                CoordinateSystem coordSys2 = Util.getRangeCoordinateSystem(pro2);
                if (coordSys1 == null ? coordSys2 != null : !coordSys1.equals(coordSys2)) {
                    throw new TypeException(coordSys1.toString() + " != " + coordSys2);
                }
                Object[] coordSyses1 = Util.getRangeCoordinateSystems(pro1);
                Object[] coordSyses2 = Util.getRangeCoordinateSystems(pro2);
                if (coordSyses1 == null ? coordSyses2 != null : !Arrays.equals(coordSyses1, coordSyses2)) {
                    throw new TypeException();
                }
                if (coordSyses1 == null ? coordSyses2 != null : !Arrays.equals(coordSyses1, coordSyses2)) {
                    throw new TypeException();
                }
                int n1 = dom1.getLength();
                int n2 = dom2.getLength();
                float[] newDomVals = new float[n1 + n2];
                System.arraycopy(AirPressure.getRealType().getDefaultUnit().toThis(dom1.getSamples(true)[0], dom1Unit), 0, newDomVals, 0, n1);
                System.arraycopy(AirPressure.getRealType().getDefaultUnit().toThis(dom2.getSamples(true)[0], dom2Unit), 0, newDomVals, n1, n2);
                if (Util.isSorted(newDomVals)) {
                    pro = new FlatField(this.outType, Gridded1DSet.create(this.outType.getDomain(), newDomVals, null, null, null), coordSys1, (CoordinateSystem[])coordSyses1, null, null);
                    float[] values = new float[n1 + n2];
                    System.arraycopy(this.rangeUnit.toThis(pro1.getFloats(false)[0], range1Unit), 0, values, 0, n1);
                    System.arraycopy(this.rangeUnit.toThis(pro2.getFloats(false)[0], range2Unit), 0, values, n1, n2);
                    pro.setSamples(new float[][]{values}, false);
                }
            }
        }
        return pro;
    }
}

