/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.Util;
import ucar.visad.quantities.Pressure;
import visad.Data;
import visad.DataReference;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public final class ProfileCleanerCell
extends ComputeCell {
    private final FlatField noData;

    public ProfileCleanerCell(DataReference proRef, RealType rangeType) throws VisADException, RemoteException {
        super("ProfileCleanerCell", new DataReference[]{proRef}, ProfileCleanerCell.noDataField(rangeType));
        this.noData = ProfileCleanerCell.noDataField(rangeType);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        FlatField inPro = (FlatField)datums[0];
        FlatField outPro = this.noData;
        if (inPro != null) {
            int i;
            boolean newProfile = false;
            FunctionType funcType = (FunctionType)inPro.getType();
            RealTupleType domainType = funcType.getDomain();
            if (!Pressure.getRealType().equalsExceptNameButUnits(domainType)) {
                throw new TypeException(domainType.toString());
            }
            MathType rangeType = funcType.getRange();
            Util.vetType(rangeType, inPro);
            Set domainSet = inPro.getDomainSet();
            float[] pressures = domainSet.getSamples()[0];
            float[] buoys = inPro.getFloats()[0];
            int n = 0;
            for (int i2 = 0; i2 < pressures.length; ++i2) {
                if (pressures[i2] == pressures[i2] && buoys[i2] == buoys[i2]) continue;
                ++n;
            }
            if (n > 0) {
                float[] tmpPres = new float[pressures.length - n];
                float[] tmpBuoy = new float[tmpPres.length];
                n = 0;
                for (i = 0; i < pressures.length; ++i) {
                    if (pressures[i] != pressures[i] || buoys[i] != buoys[i]) continue;
                    tmpPres[n] = pressures[i];
                    tmpBuoy[n] = buoys[i];
                    ++n;
                }
                pressures = tmpPres;
                buoys = tmpBuoy;
                newProfile = true;
            }
            Unit presUnit = domainSet.getSetUnits()[0];
            if (pressures.length > 1) {
                boolean ascending;
                boolean bl = ascending = pressures[0] > pressures[1];
                if (!ascending) {
                    int j = pressures.length;
                    for (i = 0; i < pressures.length / 2; ++i) {
                        float pres = pressures[i];
                        pressures[i] = pressures[--j];
                        pressures[j] = pres;
                        float buoy = buoys[i];
                        buoys[i] = buoys[j];
                        buoys[j] = buoy;
                    }
                    newProfile = true;
                }
                if (!newProfile) {
                    outPro = inPro;
                } else {
                    outPro = new FlatField(funcType, Gridded1DSet.create(domainSet.getType(), pressures, null, domainSet.getSetUnits()[0], null), null, null, null, inPro.getRangeUnits()[0]);
                    outPro.setSamples(new float[][]{buoys});
                }
            }
        }
        return outPro;
    }
}

