/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.display.LineDrawing;
import visad.Field;
import visad.FunctionType;
import visad.Real;
import visad.TypeException;
import visad.VisADException;

public abstract class Profile
extends LineDrawing {
    public static final String RANGE_VALUE = "rangeValue";
    public static final String FIELD = "field";
    private Real rangeValue;
    private Real pressure;
    private Field clearField;
    private Field originalData;

    protected Profile(String name, FunctionType funcType) throws VisADException, RemoteException {
        super(name);
        this.setManipulable(true);
        this.setLineWidth(3.0f);
        this.setPointSize(4.0f);
        this.pressure = (Real)funcType.getDomain().getComponent(0).missingData();
        this.rangeValue = (Real)funcType.getRange().missingData();
        this.clearField = (Field)funcType.missingData();
        this.setData(this.clearField);
    }

    protected Profile(Profile that) throws RemoteException, VisADException {
        this(that.getName(), (FunctionType)that.getProfile().getType());
        this.setPressure(that.pressure);
    }

    public void setProfile(Field field) throws TypeException, RemoteException, VisADException {
        if (field == null) {
            throw new NullPointerException();
        }
        FunctionType funcType = (FunctionType)this.clearField.getType();
        Util.vetType(funcType, field);
        this.setData((Field)field.dataClone());
        this.originalData = field;
    }

    public Field getProfile() throws VisADException, RemoteException {
        return (Field)this.getData();
    }

    public void setOriginalProfile() throws VisADException, RemoteException {
        this.setProfile(this.originalData);
    }

    @Override
    protected void dataChange() throws VisADException, RemoteException {
        this.firePropertyChange(FIELD, null, this.getProfile());
        this.updateRangeValue();
    }

    public boolean equals(Object obj) {
        Profile that;
        boolean equals = !(obj instanceof Profile) ? false : this == (that = (Profile)obj) || this.rangeValue.equals(that.rangeValue) && this.pressure.equals(that.pressure) && this.clearField.equals(that.clearField) && super.equals(that);
        return equals;
    }

    public int hashCode() {
        return this.rangeValue.hashCode() ^ this.pressure.hashCode() ^ this.clearField.hashCode() ^ super.hashCode();
    }

    public void setPressure(Real pressure) throws TypeException, RemoteException, VisADException {
        if (pressure == null) {
            throw new NullPointerException();
        }
        Util.vetType(this.pressure.getType(), pressure);
        this.pressure = pressure;
        this.updateRangeValue();
    }

    public Real getPressure() {
        return this.pressure;
    }

    public Real getRangeValue() {
        return this.rangeValue;
    }

    public void clear() {
        try {
            this.setProfile(this.clearField);
        }
        catch (VisADException e) {
            System.err.println(this.getClass().getName() + ".clear(): " + e);
        }
        catch (RemoteException e) {
            System.err.println(this.getClass().getName() + ".clear(): " + e);
        }
    }

    protected void updateRangeValue() throws RemoteException, VisADException {
        Real newRange = (Real)this.getProfile().evaluate(this.pressure, 101, 202);
        if (!newRange.equals(this.rangeValue)) {
            Real oldRange = this.rangeValue;
            this.rangeValue = newRange;
            this.firePropertyChange(RANGE_VALUE, oldRange, newRange);
        }
    }
}

