/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.MixingRatioTemperatureCalculator;
import ucar.unidata.view.sounding.TemperatureCalculator;
import ucar.unidata.view.sounding.TemperatureCalculatorFactory;
import visad.Real;
import visad.VisADException;

public class MixingRatioTemperatureCalculatorFactory
implements TemperatureCalculatorFactory {
    private static MixingRatioTemperatureCalculatorFactory instance;

    private MixingRatioTemperatureCalculatorFactory() {
    }

    public static TemperatureCalculatorFactory instance() {
        return instance;
    }

    @Override
    public TemperatureCalculator newTemperatureCalculator(Real saturationPressure, Real saturationTemperature) throws VisADException, RemoteException {
        return new MixingRatioTemperatureCalculator(saturationPressure, saturationTemperature);
    }

    static {
        try {
            instance = new MixingRatioTemperatureCalculatorFactory();
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

