/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.Util;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.DewPoint;
import ucar.visad.quantities.WaterVaporMixingRatio;
import visad.Data;
import visad.DataReference;
import visad.Real;
import visad.TypeException;
import visad.VisADException;

public final class MixingRatioCell
extends ComputeCell {
    private static final Real noData;

    public MixingRatioCell(DataReference dewRef, DataReference presRef) throws VisADException, RemoteException {
        super("MixingRatioCell", new DataReference[]{dewRef, presRef}, noData);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Real dew = (Real)datums[0];
        Real pres = (Real)datums[1];
        Real ratio = noData;
        if (pres != null && dew != null) {
            Util.vetType(AirPressure.getRealType(), pres);
            Util.vetType(DewPoint.getRealType(), dew);
            ratio = (Real)WaterVaporMixingRatio.create(pres, dew);
        }
        return ratio;
    }

    static {
        try {
            noData = (Real)WaterVaporMixingRatio.getRealType().missingData();
        }
        catch (Exception ex) {
            System.err.println("Couldn't initialize class");
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }
}

