/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.functiontypes.CartesianHorizontalWindOfGeopotentialAltitude;
import ucar.visad.quantities.AirDensity;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.CartesianHorizontalWind;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.SoutherlyWind;
import ucar.visad.quantities.WesterlyWind;
import visad.ActionImpl;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.SampledSet;
import visad.Tuple;
import visad.TupleType;
import visad.TypeException;
import visad.VisADException;

public class MeanWindCell
extends ActionImpl {
    public static final String MEAN_WIND = "meanWind";
    private static TupleType meanWindMathType;
    private static Tuple missingMeanWind;
    private static FunctionType windProfileType;
    private static FunctionType densityProfileType;
    private final DataReference windProfileRef;
    private final DataReference densityProfileRef;
    private final DataReference meanWindRef;
    private volatile PropertyChangeSupport changeListeners;

    public static TupleType getType() {
        return meanWindMathType;
    }

    public static Tuple getMissing() {
        return missingMeanWind;
    }

    public MeanWindCell() throws VisADException, RemoteException {
        this(new FlatField(windProfileType), new FlatField(densityProfileType));
    }

    public MeanWindCell(Field windProfile, Field densityProfile) throws VisADException, RemoteException {
        this(MeanWindCell.newWindProfileRef(windProfile), MeanWindCell.newDensityProfileRef(densityProfile), MeanWindCell.newMeanWindRef());
    }

    public MeanWindCell(DataReference windProfileRef, DataReference densityProfileRef, DataReference meanWindRef) throws VisADException, RemoteException {
        super("MeanWindCell");
        this.windProfileRef = windProfileRef;
        this.densityProfileRef = densityProfileRef;
        this.meanWindRef = meanWindRef;
        this.addReference(windProfileRef);
        this.addReference(densityProfileRef);
        this.doAction();
    }

    @Override
    public void doAction() throws VisADException, RemoteException {
        Tuple meanWind;
        Tuple oldMeanWind = (Tuple)this.meanWindRef.getData();
        Field densityProfile = (Field)this.densityProfileRef.getData();
        Field windProfile = (Field)this.windProfileRef.getData();
        if (densityProfile.isMissing() || windProfile.isMissing()) {
            meanWind = missingMeanWind;
        } else {
            SampledSet altitudeSet = (SampledSet)windProfile.getDomainSet();
            FlatField densityField = (FlatField)densityProfile.resample(altitudeSet, 101, 202);
            int lastIndex = densityField.getLength() - 1;
            Real densityIntegral = (Real)VisADMath.curveIntegralOfGradient(densityField).getSample(lastIndex);
            RealTuple meanAltitude = (RealTuple)Util.clone(VisADMath.divide(VisADMath.curveIntegralOfGradient((FlatField)VisADMath.multiply(VisADMath.newFlatField(altitudeSet).extract(0), (Data)densityField)).getSample(lastIndex), densityIntegral), meanWindMathType.getComponent(0));
            Real meanU = (Real)Util.clone(VisADMath.divide(VisADMath.curveIntegralOfGradient((FlatField)VisADMath.multiply(windProfile.extract(0), (Data)densityField)).getSample(lastIndex), densityIntegral), WesterlyWind.getRealType());
            Real meanV = (Real)Util.clone(VisADMath.divide(VisADMath.curveIntegralOfGradient((FlatField)VisADMath.multiply(windProfile.extract(1), (Data)densityField)).getSample(lastIndex), densityIntegral), SoutherlyWind.getRealType());
            meanWind = new Tuple(meanWindMathType, new Data[]{meanAltitude, new RealTuple((RealTupleType)meanWindMathType.getComponent(1), new Real[]{meanU, meanV}, null)});
        }
        this.meanWindRef.setData(meanWind);
        if (this.changeListeners != null) {
            this.changeListeners.firePropertyChange(MEAN_WIND, oldMeanWind, meanWind);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(MEAN_WIND, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        if (name.equals(MEAN_WIND)) {
            if (this.changeListeners == null) {
                MeanWindCell meanWindCell = this;
                synchronized (meanWindCell) {
                    if (this.changeListeners == null) {
                        this.changeListeners = new PropertyChangeSupport(this);
                    }
                }
            }
            this.changeListeners.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(MEAN_WIND, listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.removePropertyChangeListener(name, listener);
        }
    }

    public void setWindProfile(Field windProfile) throws VisADException, RemoteException {
        Util.vetType(windProfileType, windProfile);
        this.windProfileRef.setData(windProfile);
    }

    public void setDensityProfile(Field densityProfile) throws TypeException, VisADException, RemoteException {
        Util.vetType(densityProfileType, densityProfile);
        this.densityProfileRef.setData(densityProfile);
    }

    public Tuple getWind() throws VisADException, RemoteException {
        return (Tuple)this.meanWindRef.getData();
    }

    public DataReference getMeanWindRef() {
        return this.meanWindRef;
    }

    public boolean equals(Object obj) {
        MeanWindCell that;
        boolean equals = !(obj instanceof MeanWindCell) ? false : this == (that = (MeanWindCell)obj) || this.meanWindRef.equals(that.meanWindRef) && this.windProfileRef.equals(that.windProfileRef) && this.densityProfileRef.equals(that.densityProfileRef) && this.changeListeners.equals(that.changeListeners);
        return equals;
    }

    public int hashCode() {
        return this.meanWindRef.hashCode() ^ this.windProfileRef.hashCode() ^ this.densityProfileRef.hashCode() ^ this.changeListeners.hashCode();
    }

    private static DataReference newWindProfileRef(Data windProfile) throws VisADException, RemoteException {
        DataReferenceImpl windProfileRef = new DataReferenceImpl("MeanWindCellWindRef");
        windProfileRef.setData(windProfile);
        return windProfileRef;
    }

    private static DataReference newDensityProfileRef(Data densityProfile) throws VisADException, RemoteException {
        DataReferenceImpl densityProfileRef = new DataReferenceImpl("MeanWindCellDensityProfileRef");
        densityProfileRef.setData(densityProfile);
        return densityProfileRef;
    }

    private static DataReference newMeanWindRef() throws VisADException, RemoteException {
        DataReferenceImpl meanWindRef = new DataReferenceImpl("MeanWindCellMeanWindRef");
        meanWindRef.setData(missingMeanWind);
        return meanWindRef;
    }

    static {
        try {
            meanWindMathType = new TupleType(new MathType[]{GeopotentialAltitude.getRealTupleType(), CartesianHorizontalWind.getRealTupleType()});
            missingMeanWind = new Tuple(meanWindMathType);
            windProfileType = CartesianHorizontalWindOfGeopotentialAltitude.instance();
            densityProfileType = new FunctionType(AirPressure.getRealTupleType(), AirDensity.getRealType());
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

