/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ProfileFeatureCell;
import ucar.visad.Util;
import ucar.visad.quantities.MassicVolume;
import ucar.visad.quantities.Pressure;
import visad.Data;
import visad.DataReference;
import visad.Field;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.Set;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public final class LnbCell
extends ProfileFeatureCell {
    public LnbCell(DataReference buoyProfileRef) throws VisADException, RemoteException {
        super("LfcCell", buoyProfileRef);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Field buoyProfile = (Field)datums[0];
        Real lnb = noData;
        if (buoyProfile != null) {
            FunctionType funcType = (FunctionType)buoyProfile.getType();
            RealTupleType domainType = funcType.getDomain();
            if (!Pressure.getRealType().equalsExceptNameButUnits(domainType)) {
                throw new TypeException(domainType.toString());
            }
            MathType rangeType = funcType.getRange();
            Util.vetType(MassicVolume.getRealType(), buoyProfile);
            Set domainSet = buoyProfile.getDomainSet();
            double[] pressures = domainSet.getDoubles()[0];
            float[] buoys = buoyProfile.getFloats()[0];
            if (pressures.length > 1) {
                int lastI = pressures.length - 1;
                boolean ascending = pressures[0] >= pressures[lastI];
                Unit presUnit = domainSet.getSetUnits()[0];
                if (ascending) {
                    int i;
                    for (i = lastI; i >= 0 && buoys[i] >= 0.0f; --i) {
                    }
                    while (--i >= 0 && buoys[i] <= 0.0f) {
                    }
                    if (i >= 0) {
                        lnb = LnbCell.interpolatePres(pressures[i + 1], buoys[i + 1], pressures[i], buoys[i], presUnit);
                    }
                } else {
                    int i;
                    for (i = 0; i <= lastI && buoys[i] >= 0.0f; ++i) {
                    }
                    while (++i <= lastI && buoys[i] <= 0.0f) {
                    }
                    if (i <= lastI) {
                        lnb = LnbCell.interpolatePres(pressures[i - 1], buoys[i - 1], pressures[i], buoys[i], presUnit);
                    }
                }
            }
        }
        return lnb;
    }
}

