/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.Util;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.SaturationPointTemperature;
import ucar.visad.quantities.WaterVaporMixingRatio;
import visad.Data;
import visad.DataReference;
import visad.Real;
import visad.TypeException;
import visad.VisADException;

public final class LclTemperatureCell
extends ComputeCell {
    private static final Data noData;

    public LclTemperatureCell(DataReference ratioRef, DataReference initPresRef, DataReference initTempRef) throws VisADException, RemoteException {
        super("LclTemperatureCell", new DataReference[]{ratioRef, initPresRef, initTempRef}, noData);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Real ratio = (Real)datums[0];
        Real initPres = (Real)datums[1];
        Real initTemp = (Real)datums[2];
        Data condTemp = noData;
        if (initPres != null && initTemp != null && ratio != null) {
            Util.vetType(AirPressure.getRealType(), initPres);
            Util.vetType(AirTemperature.getRealType(), initTemp);
            Util.vetType(WaterVaporMixingRatio.getRealType(), ratio);
            condTemp = (Real)SaturationPointTemperature.create(initPres, initTemp, ratio);
        }
        return condTemp;
    }

    static {
        try {
            noData = AirTemperature.getRealType().missingData();
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            throw new RuntimeException();
        }
    }
}

