/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.Util;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.SaturationPointPressure;
import visad.Data;
import visad.DataReference;
import visad.Real;
import visad.TypeException;
import visad.VisADException;

public final class LclPressureCell
extends ComputeCell {
    private static final Data noData;

    public LclPressureCell(DataReference initPresRef, DataReference initTempRef, DataReference lclTempRef) throws VisADException, RemoteException {
        super("LclPressureCell", new DataReference[]{initPresRef, initTempRef, lclTempRef}, noData);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Real initPres = (Real)datums[0];
        Real initTemp = (Real)datums[1];
        Real lclTemp = (Real)datums[2];
        Data condPres = noData;
        if (initPres != null && initTemp != null && lclTemp != null) {
            Util.vetType(AirPressure.getRealType(), initPres);
            Util.vetType(AirTemperature.getRealType(), initTemp);
            Util.vetType(AirTemperature.getRealType(), lclTemp);
            condPres = (Real)SaturationPointPressure.create(initPres, initTemp, lclTemp);
        }
        return condPres;
    }

    static {
        try {
            noData = AirPressure.getRealType().missingData();
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            throw new RuntimeException();
        }
    }
}

