/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.VisADMath;
import ucar.visad.quantities.AirPressure;
import visad.CommonUnit;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.ErrorEstimate;
import visad.Field;
import visad.FlatField;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public final class LayerMeanCell
extends ComputeCell {
    private final Real noData;
    private DataReference meanPresRef;
    private static final Real two;

    public LayerMeanCell(DataReference proRef, DataReference lowerRef, DataReference upperRef, Real noData) throws VisADException, RemoteException {
        super("LayerMeanCell", new DataReference[]{proRef, lowerRef, upperRef}, noData);
        this.noData = noData;
        this.meanPresRef = new DataReferenceImpl("LayerPressureRef");
        this.meanPresRef.setData(AirPressure.getRealType().missingData());
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Real upper;
        Real lower;
        Real value = this.noData;
        Field profile = (Field)datums[0];
        if (profile != null && (lower = (Real)datums[1]) != null && (upper = (Real)datums[2]) != null) {
            FlatField integral = VisADMath.curveIntegralOfGradient(LayerMeanCell.interval(profile, lower, upper));
            value = (Real)VisADMath.divide(VisADMath.subtract(integral.evaluate(upper, 100, 202), integral.evaluate(lower, 100, 202)), VisADMath.subtract(upper, lower));
            this.meanPresRef.setData(VisADMath.divide(VisADMath.add(upper, (Data)lower), two));
        }
        return value;
    }

    private static Field interval(Field field, Real lower, Real upper) throws VisADException, RemoteException {
        Field newField = null;
        Set set = field.getDomainSet();
        if (set instanceof Gridded1DSet) {
            Gridded1DSet domain = (Gridded1DSet)set;
            Unit[] units = domain.getSetUnits();
            Unit unit = units[0];
            double lowValue = lower.getValue(unit);
            double upValue = upper.getValue(unit);
            float[] coords = domain.valueToGrid(new float[][]{{(float)lowValue, (float)upValue}})[0];
            float lowGrid = coords[0];
            float upGrid = coords[1];
            if (lowGrid == lowGrid && upGrid == upGrid) {
                Gridded1DSet newDomain;
                boolean useDouble;
                int upIndex;
                int lowIndex;
                if (lowGrid > upGrid) {
                    float grid = lowGrid;
                    lowGrid = upGrid;
                    upGrid = grid;
                    double value = lowValue;
                    lowValue = upValue;
                    upValue = value;
                }
                if ((float)(lowIndex = (int)Math.ceil(lowGrid)) == lowGrid) {
                    ++lowIndex;
                }
                if ((float)(upIndex = (int)Math.floor(upGrid)) == upGrid) {
                    --upIndex;
                }
                if (useDouble = domain instanceof Gridded1DDoubleSet) {
                    double[] values = new double[2 + (upIndex - lowIndex) + 1];
                    values[0] = lowValue;
                    values[values.length - 1] = upValue;
                    System.arraycopy(domain.getDoubles(false)[0], lowIndex, values, 1, values.length - 2);
                    newDomain = new Gridded1DDoubleSet((MathType)((SetType)domain.getType()), new double[][]{values}, values.length, domain.getCoordinateSystem(), units, (ErrorEstimate[])null, false);
                } else {
                    float[] values = new float[2 + (upIndex - lowIndex) + 1];
                    values[0] = (float)lowValue;
                    values[values.length - 1] = (float)upValue;
                    System.arraycopy(domain.getSamples(false)[0], lowIndex, values, 1, values.length - 2);
                    newDomain = new Gridded1DSet((MathType)((SetType)domain.getType()), (float[][])new float[][]{values}, values.length, domain.getCoordinateSystem(), units, (ErrorEstimate[])null, false);
                }
                newField = field.resample(newDomain, 101, 202);
            }
        }
        if (newField == null) {
            newField = (Field)field.getType().missingData();
        }
        return newField;
    }

    public DataReference getMeanPresRef() {
        return this.meanPresRef;
    }

    static {
        try {
            two = new Real(RealType.getRealType("LayerMeanCell_CONSTANT", CommonUnit.dimensionless), 2.0);
        }
        catch (Exception ex) {
            System.err.println("Couldn't initialize class");
            ex.printStackTrace();
            throw new RuntimeException(ex.toString());
        }
    }
}

