/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.AerologicalCoordinateSystem;
import ucar.unidata.view.sounding.BackgroundContours;
import ucar.unidata.view.sounding.SkewTCoordinateSystem;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.display.ContourLevels;
import ucar.visad.display.Displayable;
import ucar.visad.display.RegularContourLevels;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.TypeException;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public final class Isotherms
extends BackgroundContours {
    private float rangeMaximum;
    private float rangeMinimum;
    private static RealType pressureType;
    private static RealType rangeType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RealType getPressureType() throws VisADException {
        if (pressureType != null) return pressureType;
        Class<Isotherms> clazz = Isotherms.class;
        synchronized (Isotherms.class) {
            if (pressureType != null) return pressureType;
            pressureType = Util.clone(AirPressure.getRealType(), "BackgroundContoursIsothermsPressureType");
            // ** MonitorExit[var0] (shouldn't be in output)
            return pressureType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RealType getRangeType() throws VisADException {
        if (rangeType != null) return rangeType;
        Class<Isotherms> clazz = Isotherms.class;
        synchronized (Isotherms.class) {
            if (rangeType != null) return rangeType;
            rangeType = Util.clone(AirTemperature.getRealType(), "BackgroundContoursIsothermsRangeType");
            // ** MonitorExit[var0] (shouldn't be in output)
            return rangeType;
        }
    }

    public Isotherms() throws VisADException, RemoteException {
        this(SkewTCoordinateSystem.instance());
    }

    public Isotherms(AerologicalCoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        this(coordinateSystem, new RegularContourLevels(10.0f));
    }

    public Isotherms(AerologicalCoordinateSystem coordinateSystem, ContourLevels contours) throws TypeException, VisADException, RemoteException {
        super("Isotherms", contours, Isotherms.getRangeType());
        this.setCoordinateSystem(coordinateSystem);
    }

    protected Isotherms(Isotherms that) throws RemoteException, VisADException {
        super(that);
        this.rangeMaximum = that.rangeMaximum;
        this.rangeMinimum = that.rangeMinimum;
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new Isotherms(this);
    }

    @Override
    protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws TypeException, VisADException, RemoteException {
        try {
            FlatField ptField = VisADMath.fromReference(new FunctionType(RealTupleType.SpatialCartesian2DTuple, new RealTupleType(Isotherms.getPressureType(), Isotherms.getRangeType(), coordinateSystem, (Set)null)), VisADMath.newFlatField(new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, coordinateSystem.getMinimumX().getValue(), coordinateSystem.getMaximumX().getValue(), 20, coordinateSystem.getMinimumY().getValue(), coordinateSystem.getMaximumY().getValue(), 20)));
            this.field = (FlatField)Util.ensureMathType(ptField.extract(1), Isotherms.getRangeType());
        }
        catch (RemoteException ptField) {
        }
        catch (UnimplementedException ptField) {
            // empty catch block
        }
        Unit tempUnit = coordinateSystem.getCoordinateSystemUnits()[1];
        this.rangeMinimum = (float)coordinateSystem.getMinimumTemperature().getValue(tempUnit);
        this.rangeMaximum = (float)coordinateSystem.getMaximumTemperature().getValue(tempUnit);
        this.setRange(this.rangeMinimum, this.rangeMaximum);
    }

    protected float getRangeMinimum() {
        return this.rangeMinimum;
    }

    protected float getRangeMaximum() {
        return this.rangeMaximum;
    }
}

