/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.AerologicalCoordinateSystem;
import ucar.unidata.view.sounding.BackgroundContours;
import ucar.unidata.view.sounding.SkewTCoordinateSystem;
import ucar.visad.Util;
import ucar.visad.display.ContourLevels;
import ucar.visad.display.Displayable;
import ucar.visad.display.RegularContourLevels;
import ucar.visad.quantities.AirPressure;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.TypeException;
import visad.VisADException;

public final class Isobars
extends BackgroundContours {
    private float rangeMaximum;
    private float rangeMinimum;
    private static RealType pressureType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RealType getPressureType() throws VisADException {
        if (pressureType != null) return pressureType;
        Class<Isobars> clazz = Isobars.class;
        synchronized (Isobars.class) {
            if (pressureType != null) return pressureType;
            pressureType = Util.clone(AirPressure.getRealType(), "BackgroundContoursIsobarsPressureType");
            // ** MonitorExit[var0] (shouldn't be in output)
            return pressureType;
        }
    }

    public Isobars() throws VisADException, RemoteException {
        this(SkewTCoordinateSystem.instance());
    }

    public Isobars(AerologicalCoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        this(coordinateSystem, new RegularContourLevels(100.0f));
    }

    public Isobars(AerologicalCoordinateSystem coordinateSystem, ContourLevels contours) throws TypeException, VisADException, RemoteException {
        super("Isobars", contours, Isobars.getPressureType());
        this.setCoordinateSystem(coordinateSystem);
    }

    protected Isobars(Isobars that) throws RemoteException, VisADException {
        super(that);
        this.rangeMaximum = that.rangeMaximum;
        this.rangeMinimum = that.rangeMinimum;
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new Isobars(this);
    }

    @Override
    protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws TypeException, VisADException, RemoteException {
        this.rangeMinimum = (float)coordinateSystem.getMinimumPressure().getValue();
        this.rangeMaximum = (float)coordinateSystem.getMaximumPressure().getValue();
        float[] isobarValues = this.getContourLevels().getLevels(this.rangeMinimum, this.rangeMaximum);
        float minX = (float)coordinateSystem.getMinimumX().getValue();
        float maxX = (float)coordinateSystem.getMaximumX().getValue();
        float[][] domainSamples = new float[2][3 * isobarValues.length];
        double[][] ptCoordinates = new double[2][1];
        int j = 0;
        for (int i = 0; i < isobarValues.length; ++i) {
            ptCoordinates[0][0] = isobarValues[i];
            ptCoordinates[1][0] = 0.0;
            float y = (float)coordinateSystem.toReference(ptCoordinates)[1][0];
            domainSamples[0][j] = minX;
            domainSamples[1][j++] = y;
            domainSamples[0][j] = 0.0f;
            domainSamples[1][j++] = y;
            domainSamples[0][j] = maxX;
            domainSamples[1][j++] = y;
        }
        this.field = new FlatField(new FunctionType(RealTupleType.SpatialCartesian2DTuple, Isobars.getPressureType()), new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, domainSamples, 3, isobarValues.length));
        float[] rangeSamples = new float[3 * isobarValues.length];
        j = 0;
        for (int i = 0; i < isobarValues.length; ++i) {
            rangeSamples[j++] = isobarValues[i];
            rangeSamples[j++] = isobarValues[i];
            rangeSamples[j++] = isobarValues[i];
        }
        try {
            this.field.setSamples(new float[][]{rangeSamples});
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.setRange(this.rangeMinimum, this.rangeMaximum);
    }

    protected float getRangeMinimum() {
        return this.rangeMinimum;
    }

    protected float getRangeMaximum() {
        return this.rangeMaximum;
    }
}

