/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.RingSet;
import visad.Data;
import visad.Field;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.RealTupleType;
import visad.SampledSet;
import visad.SetType;
import visad.VisADException;

public class IntermediateRings
extends DisplayableData {
    private Field ringField;
    private Gridded1DSet altitudes;
    private SampledSet ringSetTemplate;
    private RealTupleType polarType;

    public IntermediateRings(RealTupleType polarType) throws VisADException, RemoteException {
        super("IntermediateRings");
        this.polarType = polarType;
    }

    protected IntermediateRings(IntermediateRings that) throws RemoteException, VisADException {
        super(that);
        this.ringField = (Field)that.getData();
        this.altitudes = that.altitudes;
        this.ringSetTemplate = that.ringSetTemplate;
        this.polarType = that.polarType;
    }

    public void setAltitudes(Gridded1DSet altitudes) throws VisADException, RemoteException {
        if (this.ringSetTemplate != null) {
            this.ringField = IntermediateRings.computeRingField(altitudes, this.ringSetTemplate);
            this.setData(this.ringField);
        }
        this.altitudes = altitudes;
    }

    public void setRingSpeeds(Gridded1DSet speeds) throws VisADException, RemoteException {
        this.ringSetTemplate = RingSet.newUnionSet(this.polarType, speeds);
        if (this.altitudes != null) {
            this.ringField = IntermediateRings.computeRingField(this.altitudes, this.ringSetTemplate);
            this.setData(this.ringField);
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new IntermediateRings(this);
    }

    protected static Field computeRingField(Gridded1DSet altitudes, SampledSet ringSetTemplate) throws VisADException, RemoteException {
        FieldImpl ringField = new FieldImpl(new FunctionType(((SetType)altitudes.getType()).getDomain(), ringSetTemplate.getType()), altitudes);
        int altitudeCount = ringField.getLength();
        for (int i = 0; i < altitudeCount; ++i) {
            ringField.setSample(i, (Data)ringSetTemplate, false);
        }
        return ringField;
    }
}

