/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.event.SwingPropertyChangeSupport;
import ucar.unidata.view.sounding.WindProfileDisplayRenderer;
import visad.Display;
import visad.ScalarMap;
import visad.java3d.DefaultDisplayRendererJ3D;

public class HodographDisplayRendererJ3D
extends DefaultDisplayRendererJ3D
implements WindProfileDisplayRenderer {
    private double[] cursorPosition = null;
    private final SwingPropertyChangeSupport changeListeners = new SwingPropertyChangeSupport(this);

    @Override
    public void setCursorStringVector() {
        double[] oldCursorPosition = this.cursorPosition;
        double[] cursorPosition = this.getCursorInDisplayCoords();
        this.changeListeners.firePropertyChange("cursorPosition", oldCursorPosition, cursorPosition);
        super.setCursorStringVector();
    }

    @Override
    public double[] getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    public void addCursorPositionListener(PropertyChangeListener listener) {
        this.changeListeners.addPropertyChangeListener(listener);
    }

    @Override
    public void removeCursorPositionListener(PropertyChangeListener listener) {
        this.changeListeners.removePropertyChangeListener(listener);
    }

    protected double[] getCursorInDisplayCoords() {
        double[] cursorCoords = this.getCursor();
        Vector v = this.getDisplay().getMapVector();
        double xFactor = 1.0;
        double yFactor = 1.0;
        double[] heightRange = new double[]{-1.0, 1.0};
        for (int i = 0; i < v.size(); ++i) {
            ScalarMap map = (ScalarMap)v.get(i);
            if (map.getDisplayScalar() == Display.XAxis) {
                xFactor = map.getRange()[1];
            }
            if (map.getDisplayScalar() == Display.YAxis) {
                yFactor = map.getRange()[1];
            }
            if (map.getDisplayScalar() != Display.ZAxis) continue;
            heightRange = map.getRange();
        }
        return new double[]{cursorCoords[0] * xFactor, cursorCoords[1] * yFactor, (cursorCoords[2] + 1.0) * (heightRange[1] - heightRange[0]) / 2.0 + heightRange[0]};
    }
}

