/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.media.j3d.Transform3D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ucar.unidata.view.sounding.CenterPole;
import ucar.unidata.view.sounding.CompassLabels;
import ucar.unidata.view.sounding.HodographDisplayRendererJ3D;
import ucar.unidata.view.sounding.IntermediateRings;
import ucar.unidata.view.sounding.MeanWindTrace;
import ucar.unidata.view.sounding.SpeedLabels;
import ucar.unidata.view.sounding.WindProfile;
import ucar.unidata.view.sounding.WindProfileDisplay;
import ucar.unidata.view.sounding.WindProfileSet;
import ucar.unidata.view.sounding.WindTrace;
import ucar.visad.display.CrossHair;
import ucar.visad.display.Displayable;
import ucar.visad.display.RingSet;
import ucar.visad.functiontypes.CartesianHorizontalWindOfGeopotentialAltitude;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.PolarHorizontalWind;
import ucar.visad.quantities.SoutherlyWind;
import ucar.visad.quantities.Speed;
import ucar.visad.quantities.WesterlyWind;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.DataReference;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.SetType;
import visad.Tuple;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.units.DefaultUnitsDB;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.KeyboardBehaviorJ3D;

public class Hodograph3DDisplay
extends WindProfileDisplay {
    private static Real defaultMaxSpeed;
    private Gridded1DSet displayAltitudes;
    private Real maxDisplaySpeed;
    private Real ringIncrement;
    private Linear1DSet ringSpeeds;
    private boolean autoscaleSpeed;
    private Unit speedUnit;
    private RingSet lowerRingSet;
    private RingSet upperRingSet;
    private IntermediateRings intermediateRings;
    private SpeedLabels speedLabels;
    private CompassLabels compassLabels;
    private CrossHair lowerCrossHair;
    private CrossHair upperCrossHair;
    private CenterPole centerPole;
    private ScalarMap westerlyMap;
    private ScalarMap southerlyMap;
    private static MeanWindTrace missingMeanWindTrace;

    public Hodograph3DDisplay() throws VisADException, RemoteException {
        this(Hodograph3DDisplay.getDefaultMinAltitude(), Hodograph3DDisplay.getDefaultMaxAltitude(), Hodograph3DDisplay.getDefaultMaxSpeed());
    }

    public Hodograph3DDisplay(Real minZ, Real maxZ, Real maxW) throws VisADException, RemoteException {
        super(new DisplayImplJ3D("Hodograph3D", (DisplayRendererJ3D)new HodographDisplayRendererJ3D()), minZ, maxZ, 7, Display.ZAxis);
        this.maxDisplaySpeed = maxW;
        this.autoscaleSpeed = true;
        this.speedUnit = maxW.getUnit();
        this.ringIncrement = maxW;
        DisplayImpl display = (DisplayImpl)this.getDisplay();
        GraphicsModeControl gmc = display.getGraphicsModeControl();
        DisplayRenderer dispRend = display.getDisplayRenderer();
        gmc.setProjectionPolicy(0);
        ((DisplayRendererJ3D)dispRend).addKeyboardBehavior(new KeyboardBehaviorJ3D((DisplayRendererJ3D)dispRend));
        ProjectionControl pc = this.getDisplay().getProjectionControl();
        Transform3D transform = new Transform3D(pc.getMatrix());
        transform.setScale(0.75);
        double[] matrix = new double[16];
        transform.get(matrix);
        ((JPanel)this.getDisplay().getComponent()).setPreferredSize(new Dimension(400, 400));
        this.saveProjection();
        this.westerlyMap = new ScalarMap(WesterlyWind.getRealType(), Display.XAxis);
        this.westerlyMap.setScaleEnable(false);
        this.addScalarMap(this.westerlyMap);
        this.southerlyMap = new ScalarMap(SoutherlyWind.getRealType(), Display.YAxis);
        this.southerlyMap.setScaleEnable(false);
        this.addScalarMap(this.southerlyMap);
        RealTupleType polarType = PolarHorizontalWind.getRealTupleType();
        this.lowerRingSet = new RingSet("lowerRingSet", polarType);
        this.lowerRingSet.addConstantMap(new ConstantMap(-1.0, Display.ZAxis));
        this.lowerRingSet.setHSV(0.0, 0.0, 1.0);
        this.addDisplayable(this.lowerRingSet);
        this.upperRingSet = new RingSet("upperRingSet", polarType);
        this.upperRingSet.addConstantMap(new ConstantMap(1.0, Display.ZAxis));
        this.upperRingSet.setHSV(0.0, 0.0, 1.0);
        this.addDisplayable(this.upperRingSet);
        this.intermediateRings = new IntermediateRings(polarType);
        this.addDisplayable(this.intermediateRings);
        this.speedLabels = new SpeedLabels();
        this.speedLabels.addConstantMap(new ConstantMap(-1.0, Display.ZAxis));
        this.speedLabels.addConstantMap(new ConstantMap(0.0, Display.YAxis));
        this.addDisplayable(this.speedLabels);
        this.compassLabels = new CompassLabels();
        this.compassLabels.addConstantMap(new ConstantMap(-1.0, Display.ZAxis));
        this.addDisplayable(this.compassLabels);
        this.lowerCrossHair = new CrossHair("lowerCrossHair", PolarHorizontalWind.getRealTupleType());
        this.lowerCrossHair.addConstantMap(new ConstantMap(-1.0, Display.ZAxis));
        this.addDisplayable(this.lowerCrossHair);
        this.upperCrossHair = new CrossHair("upperCrossHair", PolarHorizontalWind.getRealTupleType());
        this.upperCrossHair.addConstantMap(new ConstantMap(1.0, Display.ZAxis));
        this.addDisplayable(this.upperCrossHair);
        this.centerPole = new CenterPole("centerPole", GeopotentialAltitude.getRealType());
        this.addDisplayable(this.centerPole);
        this.getWindProfileSet().addPropertyChangeListener(WindProfileSet.MAXIMUM_SPEED, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                try {
                    Hodograph3DDisplay.this.setMaxDisplaySpeed();
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + ".propertyChange(): " + "Couldn't handle change to maximum profile speed: " + e);
                }
            }
        });
        this.setRingSpeeds();
        this.setWindScalarMapRanges();
        this.setCenterPoleExtent();
        this.setDisplayAltitudes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Real getDefaultMaxSpeed() throws VisADException {
        if (defaultMaxSpeed != null) return defaultMaxSpeed;
        Class<Hodograph3DDisplay> clazz = Hodograph3DDisplay.class;
        synchronized (Hodograph3DDisplay.class) {
            if (defaultMaxSpeed != null) return defaultMaxSpeed;
            try {
                defaultMaxSpeed = new Real(Speed.getRealType(), 100.0, DefaultUnitsDB.instance().get("kt"));
            }
            catch (Exception e) {
                throw new VisADException(e.getMessage());
            }
            return defaultMaxSpeed;
        }
    }

    public void setAutoscaleSpeed(boolean value) {
        this.autoscaleSpeed = value;
    }

    public boolean isAutoscaleSpeed() {
        return this.autoscaleSpeed;
    }

    @Override
    protected WindProfile newWindProfile() throws VisADException, RemoteException {
        return new WindTrace(this.getDisplay());
    }

    @Override
    public void setBackgroundVisible(boolean b) throws VisADException, RemoteException {
        this.lowerRingSet.setVisible(b);
        this.upperRingSet.setVisible(b);
        this.lowerCrossHair.setVisible(b);
        this.upperCrossHair.setVisible(b);
        this.centerPole.setVisible(b);
        this.intermediateRings.setVisible(b);
        super.setBackgroundVisible(b);
    }

    public void setCompassLabelsVisible(boolean visible) throws VisADException, RemoteException {
        this.compassLabels.setVisible(visible);
    }

    public void setSpeedLabelsVisible(boolean visible) throws VisADException, RemoteException {
        this.speedLabels.setVisible(visible);
    }

    public void setCrossHairsVisible(boolean visible) throws VisADException, RemoteException {
        this.lowerCrossHair.setVisible(visible);
        this.upperCrossHair.setVisible(visible);
    }

    public void setRingsVisible(boolean visible) throws VisADException, RemoteException {
        this.lowerRingSet.setVisible(visible);
        this.upperRingSet.setVisible(visible);
    }

    public void setIntermediateRingsVisible(boolean visible) throws VisADException, RemoteException {
        this.intermediateRings.setVisible(visible);
    }

    public void setCenterPoleVisible(boolean visible) throws VisADException, RemoteException {
        this.centerPole.setVisible(visible);
    }

    protected void setDisplayAltitudes(Gridded1DSet altitudes) throws VisADException, RemoteException {
        if (!altitudes.equals(this.displayAltitudes)) {
            this.displayAltitudes = altitudes;
            int sampleCount = Math.max(0, altitudes.getLength(0) - 2);
            float[][] samples = new float[1][sampleCount];
            System.arraycopy(altitudes.getSamples()[0], 1, samples[0], 0, sampleCount);
            this.intermediateRings.setAltitudes(new Gridded1DSet(altitudes.getType(), samples, sampleCount, (CoordinateSystem)null, altitudes.getSetUnits(), (ErrorEstimate[])null));
        }
    }

    protected void setWindScalarMapRanges() throws RemoteException, VisADException {
        double maxSpeed = this.getMaxDisplaySpeed().getValue(((RealType)this.westerlyMap.getScalar()).getDefaultUnit());
        this.westerlyMap.setRange(-maxSpeed, maxSpeed);
        maxSpeed = this.getMaxDisplaySpeed().getValue(((RealType)this.southerlyMap.getScalar()).getDefaultUnit());
        this.southerlyMap.setRange(-maxSpeed, maxSpeed);
    }

    protected void setCenterPoleExtent() throws RemoteException, VisADException {
        this.centerPole.setExtent(this.getMinDisplayAltitude(), this.getMaxDisplayAltitude());
    }

    protected void setDisplayAltitudes() throws VisADException, RemoteException {
        Unit unit = this.getAltitudeUnit();
        double min = this.getMinDisplayAltitude().getValue(unit);
        double max = this.getMaxDisplayAltitude().getValue(unit);
        double extent = max - min;
        if (!Double.isNaN(extent) && !Double.isInfinite(extent) && extent > 0.0) {
            this.setDisplayAltitudes(new Linear1DSet((MathType)GeopotentialAltitude.getRealType(), min, max, 1 + (int)Math.round(extent / this.computeIncrement(extent, 5)), (CoordinateSystem)null, new Unit[]{unit}, null));
        }
    }

    protected void setRingSpeeds() throws RemoteException, VisADException {
        Unit spdUnit = this.getSpeedUnit();
        double max = this.getMaxDisplaySpeed().getValue(spdUnit);
        double increment = this.computeIncrement(max, 5);
        this.setRingSpeeds(new Linear1DSet((MathType)PolarHorizontalWind.getSpeedRealType(), increment, max, (int)Math.round(max / increment), null, new Unit[]{spdUnit}, null));
    }

    public void setRingSpeeds(Linear1DSet speeds) throws VisADException, RemoteException {
        if (!speeds.equals(this.ringSpeeds)) {
            this.ringSpeeds = speeds;
            this.setSpeedRings();
            this.setSpeedLabels();
            this.setCrossHairs();
        }
    }

    public Linear1DSet getRingSpeeds() {
        return this.ringSpeeds;
    }

    protected void setSpeedRings() throws VisADException, RemoteException {
        Linear1DSet speeds = this.getRingSpeeds();
        this.lowerRingSet.setRingValues(speeds);
        this.upperRingSet.setRingValues(speeds);
        this.intermediateRings.setRingSpeeds(new Gridded1DSet((MathType)((RealType)((SetType)speeds.getType()).getDomain().getComponent(0)), speeds.indexToValue(speeds.valueToIndex(new float[][]{{speeds.getHiX() / 2.0f}})), 1, (CoordinateSystem)null, speeds.getSetUnits(), (ErrorEstimate[])null));
    }

    protected void setCrossHairs() throws VisADException, RemoteException {
        this.lowerCrossHair.setHairs(this.getMaxDisplaySpeed());
        this.upperCrossHair.setHairs(this.lowerCrossHair);
    }

    protected void setSpeedLabels() throws VisADException, RemoteException {
        this.speedLabels.setLabels(this.getRingSpeeds());
    }

    @Override
    protected void displayAltitudeExtentChange() throws VisADException, RemoteException {
        this.setAltitudeColorMapRange();
        this.setCenterPoleExtent();
        this.setDisplayAltitudes();
    }

    public Real getMaxProfileSpeed() {
        return this.getWindProfileSet().getMaximumSpeed();
    }

    public void setOriginalProfile(int index) throws VisADException, RemoteException {
        this.getWindProfileSet().setOriginalProfile(index);
    }

    protected void setMaxDisplaySpeed() throws VisADException, RemoteException {
        if (this.isAutoscaleSpeed()) {
            Unit unit = this.getSpeedUnit();
            double spd = this.getMaxProfileSpeed().getValue(unit);
            double inc = this.getRingIncrement().getValue(unit);
            if (!Double.isNaN(spd) && !Double.isInfinite(spd) && spd > 0.0 && !Double.isNaN(inc) && !Double.isInfinite(inc) && inc > 0.0) {
                Real max = new Real(Speed.getRealType(), Math.ceil(spd / inc) * inc, unit);
                this.setMaxDisplaySpeed(max);
            }
        }
    }

    public void setMaxDisplaySpeed(Real speed) throws VisADException, RemoteException {
        if (!speed.equals(this.maxDisplaySpeed)) {
            this.maxDisplaySpeed = speed;
            this.setWindScalarMapRanges();
            if (this.isAutoscaleSpeed()) {
                this.setRingIncrement();
            }
            this.setRingSpeeds();
        }
    }

    public Real getMaxDisplaySpeed() {
        return this.maxDisplaySpeed;
    }

    protected void setRingIncrement() throws VisADException, RemoteException {
        Unit spdUnit = this.getSpeedUnit();
        double speed = this.getMaxProfileSpeed().getValue(spdUnit);
        if (!Double.isNaN(speed) && !Double.isInfinite(speed) && speed > 0.0) {
            double increment = this.computeIncrement(speed, 5);
            this.setRingIncrement(new Real(PolarHorizontalWind.getSpeedRealType(), increment, spdUnit));
        }
    }

    public void setRingIncrement(Real increment) throws VisADException, RemoteException {
        if (!increment.equals(this.ringIncrement)) {
            this.ringIncrement = increment;
            this.setRingSpeeds();
        }
    }

    public Real getRingIncrement() {
        return this.ringIncrement;
    }

    public void setSpeedUnit(Unit unit) throws UnitException, VisADException, RemoteException {
        if (!Unit.canConvert(unit, CommonUnit.meterPerSecond)) {
            throw new UnitException("\"speed\" unit (" + unit + ") isn't");
        }
        if (!unit.equals(this.speedUnit)) {
            this.speedUnit = unit;
            this.setRingIncrement();
            this.setMaxDisplaySpeed();
        }
    }

    public Unit getSpeedUnit() {
        return this.speedUnit;
    }

    @Override
    protected void setCursorPosition(double[] position) throws VisADException, RemoteException {
        this.setGeopotentialAltitude(new Real(GeopotentialAltitude.getRealType(), position[2]));
    }

    @Override
    protected Displayable newMeanWind(Tuple meanWind) throws VisADException, RemoteException {
        MeanWindTrace meanWindTrace = new MeanWindTrace();
        meanWindTrace.setWind(meanWind);
        return meanWindTrace;
    }

    @Override
    protected Displayable newMeanWind(DataReference meanWindRef) throws VisADException, RemoteException {
        MeanWindTrace meanWindTrace = new MeanWindTrace();
        meanWindTrace.setWind(meanWindRef);
        return meanWindTrace;
    }

    @Override
    protected Displayable newMeanWind() {
        return missingMeanWindTrace;
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("3D Hodograph");
        Hodograph3DDisplay h3d = new Hodograph3DDisplay();
        float[][] levels = new float[1][10];
        float[][] uv = new float[2][10];
        for (int i = 0; i < 10; ++i) {
            levels[0][i] = (float)i * 500.0f;
            uv[0][i] = i % 2 == 0 ? (float)i * 2.0f : (float)(-i) * 2.0f;
            uv[1][i] = i % 3 == 0 ? (float)(-i) * 2.0f : (float)i * 2.0f;
        }
        FlatField field = new FlatField(CartesianHorizontalWindOfGeopotentialAltitude.instance(), new Gridded1DSet((MathType)GeopotentialAltitude.getRealTupleType(), levels, 10));
        field.setSamples(uv);
        h3d.addProfile(0, field);
        h3d.setProfileVisible(0, true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(h3d.getComponent());
        frame.setSize(512, 512);
        frame.pack();
        frame.setVisible(true);
        h3d.draw();
    }

    static {
        try {
            missingMeanWindTrace = new MeanWindTrace();
        }
        catch (Exception e) {
            System.err.println("Hodograph3DDisplay.<clinit>: Couldn't initialize class: " + e);
        }
    }
}

