/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.functiontypes.AtmosphericProfile;
import ucar.visad.quantities.MassicEnergy;
import ucar.visad.quantities.MassicVolume;
import ucar.visad.quantities.Pressure;
import visad.Data;
import visad.DataReference;
import visad.Field;
import visad.FunctionType;
import visad.RealTupleType;
import visad.TypeException;
import visad.VisADException;

public final class EnergyProfileCell
extends ComputeCell {
    private static final Data noData;

    public EnergyProfileCell(DataReference buoyProfileRef) throws VisADException, RemoteException {
        super("EnergyProfileCell", new DataReference[]{buoyProfileRef}, noData);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Field buoyProfile = (Field)datums[0];
        Data energyProfile = noData;
        if (buoyProfile != null) {
            Util.vetType(MassicVolume.getRealType(), buoyProfile);
            FunctionType funcType = (FunctionType)buoyProfile.getType();
            RealTupleType domainType = funcType.getDomain();
            if (!Pressure.getRealType().equalsExceptNameButUnits(domainType)) {
                throw new TypeException(domainType.toString());
            }
            energyProfile = VisADMath.curveIntegralOfGradient(buoyProfile);
        }
        return energyProfile;
    }

    static {
        try {
            noData = new AtmosphericProfile(MassicEnergy.getRealType()).missingData();
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

