/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.unidata.view.sounding.DryTemperatureCalculatorFactory;
import ucar.unidata.view.sounding.TemperatureCalculator;
import ucar.unidata.view.sounding.TemperatureCalculatorFactory;
import ucar.visad.Util;
import ucar.visad.functiontypes.AirTemperatureProfile;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataReference;
import visad.ErrorEstimate;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.Set;
import visad.SingletonSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public class DryTrajectoryCell
extends ComputeCell {
    private TemperatureCalculatorFactory factory = DryTemperatureCalculatorFactory.instance();
    private static final double logMaxPresRatio;
    private static final RealType pressureRatioType;
    private static final FunctionType trajectoryType;
    private static final Field noData;

    public DryTrajectoryCell(DataReference initPresRef, DataReference initTempRef, DataReference lclPresRef) throws VisADException, RemoteException {
        super("DryTrajectoryCell", new DataReference[]{initPresRef, initTempRef, lclPresRef}, noData);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Real initPres = (Real)datums[0];
        Real initTemp = (Real)datums[1];
        Real lclPres = (Real)datums[2];
        Field dryTraj = noData;
        if (initPres != null && lclPres != null && initTemp != null) {
            Util.vetType(AirPressure.getRealType(), initPres);
            Util.vetType(AirPressure.getRealType(), lclPres);
            Util.vetType(AirTemperature.getRealType(), initTemp);
            Unit presUnit = AirPressure.getRealType().getDefaultUnit();
            double endPres = lclPres.getValue(presUnit);
            double startPres = initPres.getValue(presUnit);
            if (endPres < startPres) {
                double logPresExtent = Math.log(endPres / startPres);
                double logPresRatio = logPresExtent / Math.ceil(logPresExtent / logMaxPresRatio);
                int count = 1 + (int)Math.round(logPresExtent / logPresRatio);
                Real pressureRatio = new Real(pressureRatioType, Math.exp(logPresRatio));
                float[] pressures = new float[count];
                float[] temperatures = new float[count];
                Real pressure = new Real(AirPressure.getRealType(), initPres.getValue(presUnit), presUnit);
                Real temperature = initTemp;
                TemperatureCalculator calculator = this.factory.newTemperatureCalculator(pressure, initTemp);
                pressures[0] = (float)pressure.getValue(presUnit);
                Unit tempUnit = AirTemperature.getRealType().getDefaultUnit();
                temperatures[0] = (float)temperature.getValue(tempUnit);
                for (int i = 1; i < count; ++i) {
                    pressure = (Real)pressure.multiply(pressureRatio);
                    temperature = calculator.nextTemperature(pressure);
                    pressures[i] = (float)pressure.getValue(presUnit);
                    temperatures[i] = (float)temperature.getValue(tempUnit);
                }
                dryTraj = new FlatField(trajectoryType, (Set)(pressures.length == 1 ? new SingletonSet(AirPressure.getRealTupleType(), new double[]{pressures[0]}, (CoordinateSystem)null, new Unit[]{presUnit}, (ErrorEstimate[])null) : new Gridded1DSet((MathType)AirPressure.getRealTupleType(), (float[][])new float[][]{pressures}, pressures.length, (CoordinateSystem)null, new Unit[]{presUnit}, (ErrorEstimate[])null)), (CoordinateSystem[])null, (Set[])null, new Unit[]{tempUnit});
                dryTraj.setSamples(new float[][]{temperatures});
            }
        }
        return dryTraj;
    }

    static {
        RealType prt = null;
        FunctionType tt = null;
        try {
            tt = AirTemperatureProfile.instance();
            prt = RealType.getRealType("TrajectoryPressureRatio", CommonUnit.dimensionless, null);
            noData = (Field)AirTemperatureProfile.instance().missingData();
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            throw new RuntimeException();
        }
        trajectoryType = tt;
        logMaxPresRatio = Math.log(0.95);
        pressureRatioType = prt;
    }
}

