/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.AerologicalCoordinateSystem;
import ucar.unidata.view.sounding.BackgroundContours;
import ucar.unidata.view.sounding.SkewTCoordinateSystem;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.display.Displayable;
import ucar.visad.display.RegularContourLevels;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.PotentialTemperature;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.TypeException;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public final class DryAdiabats
extends BackgroundContours {
    private float rangeMaximum;
    private float rangeMinimum;
    private static RealType pressureType;
    private static RealType rangeType;

    private static RealType getPressureType() throws VisADException {
        return pressureType;
    }

    private static RealType getRangeType() throws VisADException {
        return rangeType;
    }

    public DryAdiabats() throws VisADException, RemoteException {
        this(SkewTCoordinateSystem.instance());
    }

    public DryAdiabats(AerologicalCoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        super("DryAdiabats", new RegularContourLevels(20.0f), DryAdiabats.getRangeType());
        this.coordinateSystemChange(coordinateSystem);
        this.setHSV(new float[]{40.0f, 0.5f, 1.0f});
    }

    protected DryAdiabats(DryAdiabats that) throws RemoteException, VisADException {
        super(that);
        this.rangeMaximum = that.rangeMaximum;
        this.rangeMinimum = that.rangeMinimum;
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new DryAdiabats(this);
    }

    @Override
    protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws TypeException, RemoteException, VisADException {
        try {
            FlatField ptField = VisADMath.fromReference(new FunctionType(RealTupleType.SpatialCartesian2DTuple, new RealTupleType(DryAdiabats.getPressureType(), DryAdiabats.getRangeType(), coordinateSystem, (Set)null)), VisADMath.newFlatField(new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, coordinateSystem.getMinimumX().getValue(), coordinateSystem.getMaximumX().getValue(), 20, coordinateSystem.getMinimumY().getValue(), coordinateSystem.getMaximumY().getValue(), 20)));
            this.field = (FlatField)Util.ensureMathType(PotentialTemperature.create(ptField.extract(0), ptField.extract(1)), DryAdiabats.getRangeType());
            this.setData(this.field);
            Unit tempUnit = PotentialTemperature.getRealType().getDefaultUnit();
            this.rangeMinimum = (float)((Real)this.field.evaluate(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new Real[]{coordinateSystem.getMinimumX(), coordinateSystem.getMinimumY()}, null))).getValue(tempUnit);
            this.rangeMaximum = (float)((Real)this.field.evaluate(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new Real[]{coordinateSystem.getMaximumX(), coordinateSystem.getMaximumY()}, null))).getValue(tempUnit);
            this.setRange(this.rangeMinimum, this.rangeMaximum);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
    }

    protected float getRangeMinimum() {
        return this.rangeMinimum;
    }

    protected float getRangeMaximum() {
        return this.rangeMaximum;
    }

    static {
        RealType pt = null;
        RealType rt = null;
        try {
            pt = Util.clone(AirPressure.getRealType(), "BackgroundContoursDryAdiabatsPressureType");
            rt = Util.clone(PotentialTemperature.getRealType(), "BackgroundContoursDryAdiabatsRangeType");
        }
        catch (Exception e) {
            System.err.println("Couldn't initialize class: " + e);
            e.printStackTrace();
            throw new RuntimeException();
        }
        pressureType = pt;
        rangeType = rt;
    }
}

