/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.Util;
import ucar.visad.functiontypes.DewPointProfile;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.DewPoint;
import visad.Data;
import visad.DataReference;
import visad.Field;
import visad.Real;
import visad.TypeException;
import visad.VisADException;

public final class DewPointExtractorCell
extends ComputeCell {
    private static final Real noData;

    public DewPointExtractorCell(DataReference dewProfileRef, DataReference presRef) throws VisADException, RemoteException {
        super("DewPointExtractorCell", new DataReference[]{dewProfileRef, presRef}, noData);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Field dew = (Field)datums[0];
        Real pres = (Real)datums[1];
        Real newDew = noData;
        if (pres != null && dew != null) {
            Util.vetType(AirPressure.getRealType(), pres);
            Util.vetType(DewPointProfile.instance(), dew);
            newDew = (Real)dew.evaluate(pres);
        }
        return newDew;
    }

    static {
        try {
            noData = (Real)DewPoint.getRealType().missingData();
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

