/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.TemperatureCalculator;
import ucar.visad.quantities.AirDensity;
import ucar.visad.quantities.PseudoAdiabaticLapseRate;
import ucar.visad.quantities.SaturationMixingRatio;
import ucar.visad.quantities.VirtualTemperature;
import visad.CommonUnit;
import visad.Real;
import visad.RealType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.UnitException;
import visad.VisADException;

public class DefaultWetTemperatureCalculator
implements TemperatureCalculator {
    private Real pressure;
    private Real temperature;
    private Real lapseRate;
    private static Real two;

    public DefaultWetTemperatureCalculator(Real saturationPressure, Real saturationTemperature) throws TypeException, VisADException, RemoteException {
        this.pressure = saturationPressure;
        this.temperature = saturationTemperature;
        this.lapseRate = (Real)PseudoAdiabaticLapseRate.create(saturationPressure, saturationTemperature);
    }

    @Override
    public Real nextTemperature(Real nextPressure) throws TypeException, UnitException, VisADException, RemoteException {
        Real nextTemperature = null;
        try {
            Real deltaPressure = (Real)this.pressure.subtract(nextPressure);
            Real density = (Real)AirDensity.create(this.pressure, VirtualTemperature.createFromMixingRatio(this.temperature, SaturationMixingRatio.create(this.pressure, this.temperature)));
            Real deltaTemperature = (Real)this.lapseRate.multiply(deltaPressure.divide(density));
            nextTemperature = (Real)this.temperature.subtract(deltaTemperature);
            Real nextLapseRate = (Real)PseudoAdiabaticLapseRate.create(nextPressure, nextTemperature);
            Real nextDensity = (Real)AirDensity.create(nextPressure, VirtualTemperature.createFromMixingRatio(nextTemperature, SaturationMixingRatio.create(nextPressure, nextTemperature)));
            nextTemperature = (Real)this.temperature.subtract(deltaTemperature.add(nextLapseRate.multiply(deltaPressure.divide(nextDensity))).divide(two));
            this.pressure = nextPressure;
            this.temperature = nextTemperature;
            this.lapseRate = (Real)PseudoAdiabaticLapseRate.create(this.pressure, this.temperature);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        return nextTemperature;
    }

    static {
        try {
            two = new Real(RealType.getRealType("DefaultWetTemperatureCalculator_CONSTANT", CommonUnit.dimensionless), 2.0);
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class");
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }
}

