/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.visad.functiontypes.AtmosphericProfile;
import visad.ActionImpl;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.FlatField;
import visad.RealType;
import visad.RemoteVisADException;
import visad.TypeException;
import visad.VisADException;

public abstract class ComputeCell {
    private final String name;
    private final DataReference outRef;
    private final DataReference[] inRefs;
    private final ActionImpl action;

    protected ComputeCell(String name, DataReference[] inRefs, Data initValue) throws RemoteVisADException, VisADException, RemoteException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (inRefs == null) {
            throw new NullPointerException();
        }
        if (initValue == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.outRef = new DataReferenceImpl(name + ".DataReference");
        this.outRef.setData(initValue);
        this.inRefs = (DataReference[])inRefs.clone();
        for (int i = 0; i < this.inRefs.length; ++i) {
            if (this.inRefs[i] != null) continue;
            throw new NullPointerException(Integer.toString(i));
        }
        final Data[] datums = new Data[inRefs.length];
        this.action = new ActionImpl(name + ".action"){

            @Override
            public void doAction() {
                try {
                    for (int i = 0; i < ComputeCell.this.inRefs.length; ++i) {
                        datums[i] = ComputeCell.this.inRefs[i].getData();
                    }
                    ComputeCell.this.getOutputRef().setData(ComputeCell.this.compute(datums));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    public final DataReference[] getInputRefs() {
        return (DataReference[])this.inRefs.clone();
    }

    public final DataReference getOutputRef() {
        return this.outRef;
    }

    public final void enableAllInputRefs() throws VisADException, RemoteException {
        for (int i = 0; i < this.inRefs.length; ++i) {
            DataReference ref = this.inRefs[i];
            if (ref == null) {
                throw new NullPointerException(Integer.toString(i));
            }
            if (this.action.findReference(ref) != null) continue;
            this.action.addReference(ref);
        }
    }

    public final boolean disableRef(DataReference ref) throws VisADException, RemoteException {
        boolean enabled;
        if (ref == null) {
            throw new NullPointerException();
        }
        boolean bl = enabled = this.action.findReference(ref) != null;
        if (enabled) {
            this.action.removeReference(ref);
        }
        return enabled;
    }

    protected abstract Data compute(Data[] var1) throws TypeException, VisADException, RemoteException;

    public final void clean() throws VisADException, RemoteException {
        this.action.stop();
    }

    public final String toString() {
        return this.name;
    }

    protected static FlatField noDataField(RealType rangeType) throws VisADException, RemoteException {
        return (FlatField)new AtmosphericProfile(rangeType).missingData();
    }
}

