/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.Display;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.VisADException;

public class CompassLabels
extends LineDrawing {
    private FieldImpl field;
    private FunctionType functionType;
    private float size = 1.0f;
    private volatile TextControl textControl;
    private static String uniqueName;
    private static TextType textType;
    private static RealType xAxisType;
    private static RealType yAxisType;

    public CompassLabels() throws VisADException, RemoteException {
        super("CompassLabels");
        this.functionType = new FunctionType(new RealTupleType(CompassLabels.getXAxisType(), CompassLabels.getYAxisType()), CompassLabels.getTextType());
        ScalarMap textMap = this.newTextMap();
        this.addTextMapListener(textMap);
        this.addScalarMap(textMap);
        ScalarMap xMap = new ScalarMap(CompassLabels.getXAxisType(), Display.XAxis);
        xMap.setScaleEnable(false);
        xMap.setRange(-1.0, 1.0);
        this.addScalarMap(xMap);
        ScalarMap yMap = new ScalarMap(CompassLabels.getYAxisType(), Display.YAxis);
        yMap.setScaleEnable(false);
        yMap.setRange(-1.0, 1.0);
        this.addScalarMap(yMap);
        this.setLabels();
    }

    protected CompassLabels(CompassLabels that) throws RemoteException, VisADException {
        super(that);
        this.field = (FieldImpl)this.getData();
        this.functionType = that.functionType;
        this.size = that.size;
        ScalarMap textMap = this.getScalarMap(this.newTextMap());
        this.addTextMapListener(textMap);
    }

    private ScalarMap newTextMap() throws VisADException {
        return new ScalarMap(CompassLabels.getTextType(), Display.Text);
    }

    private void addTextMapListener(final ScalarMap textMap) {
        textMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block3: {
                    block2: {
                        int id = event.getId();
                        if (id == 3) break block2;
                        if (id != 5) break block3;
                    }
                    CompassLabels.this.textControl = (TextControl)textMap.getControl();
                    CompassLabels.this.textControl.setSize(CompassLabels.this.size);
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getUniqueName() throws VisADException {
        if (uniqueName != null) return uniqueName;
        Class<CompassLabels> clazz = CompassLabels.class;
        synchronized (CompassLabels.class) {
            if (uniqueName != null) return uniqueName;
            uniqueName = CompassLabels.class.getName().replace('.', '_');
            // ** MonitorExit[var0] (shouldn't be in output)
            return uniqueName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TextType getTextType() throws VisADException {
        if (textType != null) return textType;
        Class<CompassLabels> clazz = CompassLabels.class;
        synchronized (CompassLabels.class) {
            if (textType != null) return textType;
            textType = TextType.getTextType(CompassLabels.getUniqueName() + "_CompassLabel");
            // ** MonitorExit[var0] (shouldn't be in output)
            return textType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RealType getXAxisType() throws VisADException {
        if (xAxisType != null) return xAxisType;
        Class<CompassLabels> clazz = CompassLabels.class;
        synchronized (CompassLabels.class) {
            if (xAxisType != null) return xAxisType;
            xAxisType = RealType.getRealType(CompassLabels.getUniqueName() + "_XAxis");
            // ** MonitorExit[var0] (shouldn't be in output)
            return xAxisType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RealType getYAxisType() throws VisADException {
        if (yAxisType != null) return yAxisType;
        Class<CompassLabels> clazz = CompassLabels.class;
        synchronized (CompassLabels.class) {
            if (yAxisType != null) return yAxisType;
            yAxisType = RealType.getRealType(CompassLabels.getUniqueName() + "_YAxis");
            // ** MonitorExit[var0] (shouldn't be in output)
            return yAxisType;
        }
    }

    public void setSize(double size) throws VisADException, RemoteException {
        if (this.textControl != null) {
            this.textControl.setSize(size);
        }
        this.size = (float)size;
        this.setLabels();
    }

    public boolean equals(Object obj) {
        CompassLabels that;
        boolean equals = !(obj instanceof CompassLabels) ? false : (that = (CompassLabels)obj) == this || this.size == that.size && this.field.equals(that.field) && super.equals(that);
        return equals;
    }

    public int hashCode() {
        return new Float(this.size).hashCode() ^ this.field.hashCode() ^ super.hashCode();
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new CompassLabels(this);
    }

    protected void setLabels() throws VisADException, RemoteException {
        this.field = new FieldImpl(this.functionType, new Gridded2DSet((MathType)this.functionType.getDomain(), (float[][])new float[][]{{-0.015f * this.size, -0.015f * this.size, 1.0f + 0.08f * this.size, -1.0f - 0.12f * this.size}, {1.0f + 0.06f * this.size, -1.0f - 0.12f * this.size, -0.025f * this.size, -0.025f * this.size}}, 4));
        TextType textType = CompassLabels.getTextType();
        this.field.setSamples(new Text[]{new Text(textType, "N"), new Text(textType, "S"), new Text(textType, "E"), new Text(textType, "W")}, false);
        this.setData(this.field);
    }
}

