/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ucar.unidata.view.sounding.CellCycleException;
import ucar.unidata.view.sounding.ComputeCell;
import visad.DataReference;
import visad.VisADException;

public final class CellNetwork {
    private boolean isDirty = true;
    private final Map refToCell = new HashMap();

    public void add(ComputeCell cell) {
        DataReference ref = cell.getOutputRef();
        if (this.refToCell.put(ref, cell) == null) {
            this.isDirty = true;
        }
    }

    public void remove(ComputeCell cell) {
        DataReference refs = cell.getOutputRef();
        if (this.refToCell.remove(refs) != null) {
            this.isDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure() throws VisADException, RemoteException {
        if (this.isDirty) {
            HashSet visited = new HashSet(this.refToCell.size());
            CellCycleException ex = new CellCycleException();
            for (ComputeCell cell : this.refToCell.values()) {
                DataReference[] inputRefs = cell.getInputRefs();
                cell.enableAllInputRefs();
                block4: for (int i = 0; i < inputRefs.length; ++i) {
                    ex.setAncestor(inputRefs[i]);
                    for (int j = 0; j < inputRefs.length; ++j) {
                        if (j == i) continue;
                        ex.setChild(inputRefs[j]);
                        try {
                            if (!this.dependsOn(inputRefs[j], inputRefs[i], visited, ex)) continue;
                            cell.disableRef(inputRefs[i]);
                            continue block4;
                        }
                        finally {
                            visited.clear();
                        }
                    }
                }
            }
            this.isDirty = false;
        }
    }

    private boolean dependsOn(DataReference r1, DataReference r2, Set visited, CellCycleException ex) {
        boolean dep;
        ComputeCell cell = (ComputeCell)this.refToCell.get(r1);
        if (cell == null) {
            dep = false;
        } else {
            int i;
            if (visited.contains(cell)) {
                ex.setFound(cell);
                throw ex;
            }
            DataReference[] refs = cell.getInputRefs();
            dep = false;
            for (i = 0; i < refs.length; ++i) {
                if (r2 != refs[i]) continue;
                dep = true;
                break;
            }
            if (!dep) {
                visited.add(cell);
                for (i = 0; i < refs.length; ++i) {
                    if (!this.dependsOn(refs[i], r2, visited, ex)) continue;
                    dep = true;
                    break;
                }
                visited.remove(cell);
            }
        }
        return dep;
    }
}

