/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.EnergyFeatureCell;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.CAPE;
import ucar.visad.quantities.MassicEnergy;
import ucar.visad.quantities.Pressure;
import visad.Data;
import visad.DataReference;
import visad.Field;
import visad.FunctionType;
import visad.Real;
import visad.RealTupleType;
import visad.TypeException;
import visad.VisADException;

public final class CapeCell
extends EnergyFeatureCell {
    public CapeCell(DataReference energyProfileRef, DataReference lfcRef, DataReference lnbRef) throws VisADException, RemoteException {
        super("CapeCell", energyProfileRef, lfcRef, lnbRef);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Field energyProfile = (Field)datums[0];
        Data cape = noData;
        if (energyProfile != null) {
            Util.vetType(MassicEnergy.getRealType(), energyProfile);
            Real lfc = (Real)datums[1];
            if (lfc != null) {
                Util.vetType(AirPressure.getRealType(), lfc);
                Real lnb = (Real)datums[2];
                if (lnb != null) {
                    Util.vetType(AirPressure.getRealType(), lnb);
                    FunctionType funcType = (FunctionType)energyProfile.getType();
                    RealTupleType domainType = funcType.getDomain();
                    if (!Pressure.getRealType().equalsExceptNameButUnits(domainType)) {
                        throw new TypeException(domainType.toString());
                    }
                    Real value = (Real)Util.clone(VisADMath.subtract(energyProfile.evaluate(lfc), energyProfile.evaluate(lnb)), CAPE.getRealType());
                    if (value.getValue() >= 0.0) {
                        cape = value;
                    }
                }
            }
        }
        return cape;
    }
}

