/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.functiontypes.AirTemperatureProfile;
import ucar.visad.quantities.AirDensity;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.CAPE;
import ucar.visad.quantities.SaturationVirtualPotentialTemperature;
import ucar.visad.quantities.VirtualPotentialTemperature;
import ucar.visad.quantities.VirtualTemperature;
import visad.CoordinateSystem;
import visad.Data;
import visad.ErrorEstimate;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.SampledSet;
import visad.SingletonSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public class CapeCalculator {
    public String CAPE = "cape";
    public String CIN = "cin";
    private volatile PropertyChangeSupport listeners;
    private Real cape = missingCape;
    private Real cin;
    private static Real missingCape;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(this.CAPE, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        if (name.equals(this.CAPE)) {
            if (this.listeners == null) {
                CapeCalculator capeCalculator = this;
                synchronized (capeCalculator) {
                    if (this.listeners == null) {
                        this.listeners = new PropertyChangeSupport(this);
                    }
                }
            }
            this.listeners.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(this.CAPE, listener);
    }

    public synchronized void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        if (name.equals(this.CAPE) && this.listeners != null) {
            this.listeners.removePropertyChangeListener(name, listener);
        }
    }

    public void setCape(Field temperatureProfile, Field dewPointProfile, Field wetTrajectory) throws TypeException, VisADException, RemoteException {
        FunctionType airTemperatureProfile = AirTemperatureProfile.instance();
        Util.vetType(airTemperatureProfile, temperatureProfile);
        Util.vetType(airTemperatureProfile, dewPointProfile);
        Util.vetType(airTemperatureProfile, wetTrajectory);
        Real newCape = null;
        Object newCin = null;
        boolean problem = false;
        if (temperatureProfile.isMissing() || dewPointProfile.isMissing() || wetTrajectory.isMissing()) {
            problem = true;
        } else {
            SampledSet commonDomain = null;
            Unit pressureUnit = AirPressure.getRealType().getDefaultUnit();
            SampledSet temperatureDomain = (SampledSet)temperatureProfile.getDomainSet();
            SampledSet dewPointDomain = (SampledSet)dewPointProfile.getDomainSet();
            SampledSet wetDomain = (SampledSet)wetTrajectory.getDomainSet();
            int temperatureCount = temperatureDomain.getLength();
            int dewPointCount = dewPointDomain.getLength();
            int wetCount = wetDomain.getLength();
            float[] pressures = new float[temperatureCount + dewPointCount + wetCount];
            int i = 0;
            System.arraycopy(pressureUnit.toThis(temperatureDomain.getSamples()[0], pressureUnit), 0, pressures, i, temperatureCount);
            System.arraycopy(pressureUnit.toThis(dewPointDomain.getSamples()[0], pressureUnit), 0, pressures, i += temperatureCount, dewPointCount);
            System.arraycopy(pressureUnit.toThis(wetDomain.getSamples()[0], pressureUnit), 0, pressures, i += dewPointCount, wetCount);
            for (i = 0; i < pressures.length; ++i) {
                if (pressures[i] == pressures[i]) continue;
                problem = true;
                break;
            }
            if (!problem) {
                int[] indexes = Util.strictlySortedIndexes(pressures, true);
                float[] sortedPressures = new float[indexes.length];
                for (int i2 = 0; i2 < indexes.length; ++i2) {
                    sortedPressures[i2] = pressures[indexes[i2]];
                }
                SampledSet sampledSet = commonDomain = sortedPressures.length == 1 ? new SingletonSet(AirPressure.getRealTupleType(), new double[]{sortedPressures[0]}, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null) : new Gridded1DSet((MathType)AirPressure.getRealTupleType(), (float[][])new float[][]{sortedPressures}, sortedPressures.length);
            }
            if (!problem) {
                temperatureProfile = temperatureProfile.resample(commonDomain, 101, 202);
                dewPointProfile = dewPointProfile.resample(commonDomain, 101, 202);
                wetTrajectory = wetTrajectory.resample(commonDomain, 101, 202);
            }
            if (!problem) {
                Field envVirtTemp = (Field)VirtualTemperature.createFromDewPoint(temperatureProfile.getDomainSet(), temperatureProfile, dewPointProfile);
                Field envVirtPotTemp = (Field)VirtualPotentialTemperature.createFromDewPoint(temperatureProfile.getDomainSet(), temperatureProfile, dewPointProfile);
                Field buoyancyProfile = (Field)VisADMath.divide(VisADMath.subtract(SaturationVirtualPotentialTemperature.create(wetTrajectory.getDomainSet(), wetTrajectory), envVirtPotTemp), VisADMath.multiply(AirDensity.create(envVirtTemp.getDomainSet(), envVirtTemp), (Data)envVirtPotTemp));
                float[][] rangeValues = buoyancyProfile.getFloats(true);
                float[] buoyancies = rangeValues[0];
                for (int i3 = 0; i3 < buoyancies.length; ++i3) {
                    if (buoyancies[i3] == buoyancies[i3] && !(buoyancies[i3] < 0.0f)) continue;
                    buoyancies[i3] = 0.0f;
                }
                rangeValues = Unit.convertTuple(rangeValues, buoyancyProfile.getDefaultRangeUnits(), Util.getRangeUnits((FlatField)buoyancyProfile));
                buoyancyProfile.setSamples(rangeValues);
                FlatField capeProfile = VisADMath.curveIntegralOfGradient((FlatField)buoyancyProfile);
                newCape = (Real)Util.clone((Real)capeProfile.getSample(capeProfile.getLength() - 1), ucar.visad.quantities.CAPE.getRealType());
            }
        }
        this.setCape(problem ? missingCape : newCape);
    }

    protected synchronized void setCape(Real newCape) {
        Real oldCAPE = this.cape;
        this.cape = newCape;
        if (this.listeners != null) {
            this.listeners.firePropertyChange(this.CAPE, oldCAPE, this.cape);
        }
    }

    public synchronized Real getCAPE() {
        return this.cape;
    }

    static {
        try {
            missingCape = new Real(ucar.visad.quantities.CAPE.getRealType());
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

