/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.functiontypes.AtmosphericProfile;
import ucar.visad.quantities.AirDensity;
import ucar.visad.quantities.MassicVolume;
import visad.Data;
import visad.DataReference;
import visad.Field;
import visad.TypeException;
import visad.VisADException;

public final class BuoyancyProfileCell
extends ComputeCell {
    private static final Data noData;

    public BuoyancyProfileCell(DataReference envDenProRef, DataReference parDenProRef) throws VisADException, RemoteException {
        super("BuoyancyProfileCell", new DataReference[]{envDenProRef, parDenProRef}, noData);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Data buoyPro = noData;
        Field envDenPro = (Field)datums[0];
        if (envDenPro != null) {
            Util.vetType(AirDensity.getRealType(), envDenPro);
            Field parDenPro = (Field)datums[1];
            if (parDenPro != null) {
                Util.vetType(AirDensity.getRealType(), parDenPro);
                buoyPro = Util.clone(VisADMath.subtract(VisADMath.invert(parDenPro), VisADMath.invert(envDenPro)), MassicVolume.getRealType());
            }
        }
        return buoyPro;
    }

    static {
        try {
            noData = new AtmosphericProfile(MassicVolume.getRealType()).missingData();
        }
        catch (Exception ex) {
            System.err.println("Couldn't initialize class");
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }
}

