/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.AerologicalCoordinateSystem;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class Box
extends LineDrawing {
    public Box(AerologicalCoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        super("Box");
        this.setLineWidth(2.0f);
        this.setCoordinateSystem(coordinateSystem);
    }

    public void setCoordinateSystem(AerologicalCoordinateSystem coordinateSystem) throws RemoteException, VisADException {
        float minX = (float)coordinateSystem.getMinimumX().getValue();
        float maxX = (float)coordinateSystem.getMaximumX().getValue();
        float minY = (float)coordinateSystem.getMinimumY().getValue();
        float maxY = (float)coordinateSystem.getMaximumY().getValue();
        this.setData(new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{{minX, maxX, maxX, minX, minX}, {minY, minY, maxY, maxY, minY}}, 5, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null));
    }

    protected Box(Box that) throws RemoteException, VisADException {
        super(that);
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new Box(this);
    }
}

