/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.quantities.PotentialTemperature;
import visad.Data;
import visad.DataReference;
import visad.TypeException;
import visad.VisADException;

public final class AirTemperatureCell
extends ComputeCell {
    private final Data noData;

    public AirTemperatureCell(DataReference presRef, DataReference potTempRef, Data noData) throws VisADException, RemoteException {
        super("AirTemperatureCell", new DataReference[]{presRef, potTempRef}, noData);
        this.noData = noData;
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Data output = this.noData;
        Data pres = datums[0];
        if (pres != null) {
            Data temp = datums[1];
            output = PotentialTemperature.createAirTemperature(pres, temp);
        }
        return output;
    }
}

