/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.Util;
import ucar.visad.functiontypes.AtmosphericProfile;
import ucar.visad.quantities.AirDensity;
import ucar.visad.quantities.VirtualTemperature;
import visad.Data;
import visad.DataReference;
import visad.Field;
import visad.TypeException;
import visad.VisADException;

public final class AirDensityProfileCell
extends ComputeCell {
    private static final Data noData;

    public AirDensityProfileCell(DataReference virtProRef) throws VisADException, RemoteException {
        super("AirDensityProfileCell", new DataReference[]{virtProRef}, noData);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Field virtPro = (Field)datums[0];
        Data denPro = noData;
        if (virtPro != null && !virtPro.isMissing()) {
            Util.vetType(VirtualTemperature.getRealType(), virtPro);
            denPro = AirDensity.create(virtPro.getDomainSet(), virtPro);
        }
        return denPro;
    }

    static {
        try {
            noData = new AtmosphericProfile(AirDensity.getRealType()).missingData();
        }
        catch (Exception ex) {
            System.err.println("Couldn't initialize class");
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }
}

