/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ucar.unidata.view.sounding.RealReadout;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.PotentialTemperature;
import ucar.visad.quantities.SaturationEquivalentPotentialTemperature;
import ucar.visad.quantities.SaturationPointPressure;
import ucar.visad.quantities.SaturationPointTemperature;
import ucar.visad.quantities.WaterVaporMixingRatio;
import visad.Real;
import visad.VisADException;
import visad.data.units.ParseException;

public final class AerologicalReadoutTable
extends JTable {
    private PressureReadout pressureReadout;
    private AltitudeReadout altitudeReadout;
    private TemperatureReadout bgTemperatureReadout;
    private PotentialTemperatureReadout bgPotentialTemperatureReadout;
    private SatEquivalentPotTempReadout bgSatEquivalentPotTempReadout;
    private MixingRatioReadout bgSatMixingRatioReadout;
    private TemperatureReadout profileTemperatureReadout;
    private TemperatureReadout profileDewPointReadout;
    private WindSpeedReadout profileWindSpeedReadout;
    private WindDirectionReadout profileWindDirectionReadout;
    private MyReadout profileMixingRatioReadout;
    private LCLPressureReadout lclPressureReadout;
    private LCLTemperatureReadout lclTemperatureReadout;
    private LCLAltitudeReadout lclAltitudeReadout;
    private PressureReadout lfcReadout;
    private TemperatureReadout lfcTempReadout;
    private PressureReadout lnbReadout;
    private final TemperatureReadout lnbTempReadout;
    private CapeReadout capeReadout;
    private CinReadout cinReadout;

    public AerologicalReadoutTable() throws VisADException, RemoteException {
        this.setShowVerticalLines(false);
        MyTableModel tableModel = new MyTableModel();
        try {
            this.pressureReadout = new PressureReadout();
            this.altitudeReadout = new AltitudeReadout();
            this.bgTemperatureReadout = new TemperatureReadout();
            this.bgPotentialTemperatureReadout = new PotentialTemperatureReadout();
            this.bgSatEquivalentPotTempReadout = new SatEquivalentPotTempReadout();
            this.bgSatMixingRatioReadout = new MixingRatioReadout("Saturation Mixing-Ratio");
            this.profileTemperatureReadout = new TemperatureReadout();
            this.profileDewPointReadout = new TemperatureReadout("Dew-Point");
            this.profileWindSpeedReadout = new WindSpeedReadout();
            this.profileWindDirectionReadout = new WindDirectionReadout();
            this.profileMixingRatioReadout = new MixingRatioReadout();
            this.lclPressureReadout = new LCLPressureReadout();
            this.lclTemperatureReadout = new LCLTemperatureReadout();
            this.lclAltitudeReadout = new LCLAltitudeReadout();
            this.capeReadout = new CapeReadout();
            this.cinReadout = new CinReadout();
            tableModel.addRowEntry(new SeparatorRowEntry("Background:"));
            tableModel.addRowEntry(new RealRowEntry(this.pressureReadout, "    "));
            tableModel.addRowEntry(new RealRowEntry(this.altitudeReadout, "    "));
            tableModel.addRowEntry(new RealRowEntry(this.bgTemperatureReadout, "    "));
            tableModel.addRowEntry(new RealRowEntry(this.bgPotentialTemperatureReadout, "    "));
            tableModel.addRowEntry(new RealRowEntry(this.bgSatEquivalentPotTempReadout, "    "));
            tableModel.addRowEntry(new RealRowEntry(this.bgSatMixingRatioReadout, "    "));
            tableModel.addRowEntry(new SeparatorRowEntry("Profile at Background Pressure:"));
            tableModel.addRowEntry(new RealRowEntry(this.profileTemperatureReadout, "    "));
            tableModel.addRowEntry(new RealRowEntry(this.profileDewPointReadout, "    "));
            tableModel.addRowEntry(new RealRowEntry(this.profileWindSpeedReadout, "    "));
            tableModel.addRowEntry(new RealRowEntry(this.profileWindDirectionReadout, "    "));
            tableModel.addRowEntry(new SeparatorRowEntry("LNB:"));
            this.lnbReadout = new PressureReadout();
            tableModel.addRowEntry(new RealRowEntry(this.lnbReadout, "    "));
            this.lnbTempReadout = new TemperatureReadout();
            tableModel.addRowEntry(new RealRowEntry(this.lnbTempReadout, "    "));
            tableModel.addRowEntry(new SeparatorRowEntry("LFC:"));
            this.lfcReadout = new PressureReadout();
            tableModel.addRowEntry(new RealRowEntry(this.lfcReadout, "    "));
            this.lfcTempReadout = new TemperatureReadout();
            tableModel.addRowEntry(new RealRowEntry(this.lfcTempReadout, "    "));
            tableModel.addRowEntry(new SeparatorRowEntry("LCL:"));
            tableModel.addRowEntry(new RealRowEntry(this.lclPressureReadout, "    "));
            tableModel.addRowEntry(new RealRowEntry(this.lclTemperatureReadout, "    "));
        }
        catch (ParseException e) {
            throw new RuntimeException("Couldn't set readouts: " + e);
        }
        tableModel.addRowEntry(new RealRowEntry(this.capeReadout, ""));
        tableModel.addRowEntry(new RealRowEntry(this.cinReadout, ""));
        this.setModel(tableModel);
        TableColumnModel columnModel = this.getColumnModel();
        DefaultTableCellRenderer numericRenderer = new DefaultTableCellRenderer();
        numericRenderer.setHorizontalAlignment(4);
        columnModel.getColumn(1).setCellRenderer(numericRenderer);
        this.setPreferredSize();
    }

    public void setPreferredSize() throws VisADException, RemoteException {
        AerologicalReadoutTable.setColumnWidth(this, 0);
        AerologicalReadoutTable.setColumnWidth(this, 1);
        AerologicalReadoutTable.setColumnWidth(this, 2);
    }

    public void setPressure(Real pressure) throws VisADException, RemoteException {
        this.pressureReadout.setPressure(pressure);
        this.altitudeReadout.setPressure(pressure);
        this.bgPotentialTemperatureReadout.setPressure(pressure);
        this.bgSatEquivalentPotTempReadout.setPressure(pressure);
        this.bgSatMixingRatioReadout.setPressure(pressure);
    }

    public void setBackgroundTemperature(Real temperature) throws VisADException, RemoteException {
        this.bgTemperatureReadout.setTemperature(temperature);
        this.bgPotentialTemperatureReadout.setTemperature(temperature);
        this.bgSatEquivalentPotTempReadout.setTemperature(temperature);
        this.bgSatMixingRatioReadout.setTemperature(temperature);
    }

    public void setProfileTemperature(Real temperature) throws VisADException, RemoteException {
        this.profileTemperatureReadout.setTemperature(temperature);
    }

    public void setProfileDewPoint(Real dewPoint) throws VisADException, RemoteException {
        this.profileDewPointReadout.setTemperature(dewPoint);
    }

    public void setProfileWindSpeed(Real windSpeed) throws VisADException, RemoteException {
        this.profileWindSpeedReadout.setWindSpeed(windSpeed);
    }

    public void setProfileWindDirection(Real windDir) throws VisADException, RemoteException {
        this.profileWindDirectionReadout.setWindDirection(windDir);
    }

    public void setProfileMixingRatio(Real ratio) {
        this.profileMixingRatioReadout.setReal(ratio);
    }

    public void setLclPressure(Real pres) {
        this.lclPressureReadout.setReal(pres);
    }

    public void setLclTemperature(Real temp) {
        this.lclTemperatureReadout.setReal(temp);
    }

    public void setLfc(Real lfc) {
        this.lfcReadout.setPressure(lfc);
    }

    public void setLfcTemperature(Real temp) {
        this.lfcTempReadout.setTemperature(temp);
    }

    public void setLnb(Real lnb) {
        this.lnbReadout.setPressure(lnb);
    }

    public void setLnbTemperature(Real temp) {
        this.lnbTempReadout.setTemperature(temp);
    }

    public void setCape(Real cape) {
        this.capeReadout.setCape(cape);
    }

    public void setCin(Real cin) {
        this.cinReadout.setCin(cin);
    }

    protected static void setColumnWidth(JTable table, int columnIndex) {
        int width = AerologicalReadoutTable.getPreferredColumnWidth(table, columnIndex);
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setMinWidth(width);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
    }

    protected static int getPreferredColumnWidth(JTable table, int columnIndex) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column = columnModel.getColumn(columnIndex);
        TableCellRenderer renderer = column.getHeaderRenderer();
        int maxWidth = 0;
        if (renderer != null) {
            maxWidth = renderer.getTableCellRendererComponent((JTable)table, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
        }
        int n = table.getRowCount();
        for (int rowIndex = 0; rowIndex < n; ++rowIndex) {
            renderer = table.getCellRenderer(rowIndex, columnIndex);
            Object value = table.getValueAt(rowIndex, columnIndex);
            int width = renderer.getTableCellRendererComponent((JTable)table, (Object)value, (boolean)false, (boolean)false, (int)rowIndex, (int)columnIndex).getPreferredSize().width;
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth + 1;
    }

    protected class CinReadout
    extends MyReadout {
        public CinReadout() throws ParseException {
            super("CIN", "J/kg", 0);
        }

        public void setCin(Real cin) {
            try {
                this.setReal(cin);
            }
            catch (Exception e) {
                System.err.println("Couldn't set CIN readout: " + e);
            }
        }
    }

    protected class CapeReadout
    extends MyReadout {
        public CapeReadout() throws ParseException {
            super("CAPE", "J/kg", 0);
        }

        public void setCape(Real cape) {
            try {
                this.setReal(cape);
            }
            catch (Exception e) {
                System.err.println("Couldn't set CAPE readout: " + e);
            }
        }
    }

    protected class LnbReadout
    extends MyReadout {
        public LnbReadout() throws ParseException {
            super("LNB", "hPa", 1);
        }

        public void setLnb(Real lnb) {
            try {
                this.setReal(lnb);
            }
            catch (Exception e) {
                System.err.println("Couldn't set LNB readout: " + e);
            }
        }
    }

    protected class LfcReadout
    extends MyReadout {
        public LfcReadout() throws ParseException {
            super("LFC", "hPa", 1);
        }

        public void setLfc(Real lfc) {
            try {
                this.setReal(lfc);
            }
            catch (Exception e) {
                System.err.println("Couldn't set LFC readout: " + e);
            }
        }
    }

    protected class LCLAltitudeReadout
    extends PTRDerivedReadout {
        public LCLAltitudeReadout() throws ParseException {
            super("Geopotential Altitude", "gpm", 0);
        }

        @Override
        protected Real compute(Real pressure, Real temperature, Real dewPoint) throws VisADException, RemoteException {
            return (Real)GeopotentialAltitude.fromAltitude(AirPressure.toAltitude(SaturationPointPressure.create(pressure, temperature, SaturationPointTemperature.create(pressure, temperature, WaterVaporMixingRatio.create(pressure, dewPoint)))));
        }
    }

    protected class LCLTemperatureReadout
    extends PTRDerivedReadout {
        public LCLTemperatureReadout() throws ParseException {
            super("Temperature", "degC", 2);
        }

        @Override
        protected Real compute(Real pressure, Real temperature, Real dewPoint) throws VisADException, RemoteException {
            return (Real)SaturationPointTemperature.create(pressure, temperature, WaterVaporMixingRatio.create(pressure, dewPoint));
        }
    }

    protected class LCLPressureReadout
    extends PTRDerivedReadout {
        public LCLPressureReadout() throws ParseException {
            super("Pressure", "hPa", 1);
        }

        @Override
        protected Real compute(Real pressure, Real temperature, Real dewPoint) throws VisADException, RemoteException {
            return (Real)SaturationPointPressure.create(pressure, temperature, SaturationPointTemperature.create(pressure, temperature, WaterVaporMixingRatio.create(pressure, dewPoint)));
        }
    }

    protected static abstract class PTRDerivedReadout
    extends MyReadout {
        private Real temperature;
        private Real pressure;
        private Real dewPoint;

        protected PTRDerivedReadout(String name, String unitString, int fractionDigitCount) throws ParseException {
            super(name, unitString, fractionDigitCount);
        }

        public void setPressure(Real pressure) throws VisADException, RemoteException {
            this.pressure = pressure;
            this.compute();
        }

        public Real getPressure() {
            return this.pressure;
        }

        public void setTemperature(Real temperature) throws VisADException, RemoteException {
            this.temperature = temperature;
            this.compute();
        }

        public Real getTemperature() {
            return this.temperature;
        }

        public void setDewPoint(Real dewPoint) throws VisADException, RemoteException {
            this.dewPoint = dewPoint;
            this.compute();
        }

        public Real getDewPoint() {
            return this.dewPoint;
        }

        protected void compute() throws VisADException, RemoteException {
            if (this.temperature != null && this.pressure != null && this.dewPoint != null) {
                try {
                    this.setReal(this.compute(this.pressure, this.temperature, this.dewPoint));
                }
                catch (Exception e) {
                    System.err.println("Couldn't compute " + this.getName() + ": " + e);
                }
            }
        }

        protected abstract Real compute(Real var1, Real var2, Real var3) throws VisADException, RemoteException;
    }

    protected static class MixingRatioReadout
    extends PTDerivedReadout {
        public MixingRatioReadout() throws ParseException {
            this("Mixing-Ratio");
        }

        public MixingRatioReadout(String name) throws ParseException {
            super(name, "g/kg", 3);
        }

        @Override
        protected Real compute(Real pressure, Real temperature) throws RemoteException, VisADException {
            return (Real)WaterVaporMixingRatio.create(pressure, temperature);
        }
    }

    protected static class SatEquivalentPotTempReadout
    extends PTDerivedReadout {
        public SatEquivalentPotTempReadout() throws ParseException {
            super("Sat' Equiv' Pot' Temp'", "K", 2);
        }

        @Override
        protected Real compute(Real pressure, Real temperature) throws RemoteException, VisADException {
            return (Real)SaturationEquivalentPotentialTemperature.create(pressure, temperature);
        }
    }

    protected static class PotentialTemperatureReadout
    extends PTDerivedReadout {
        public PotentialTemperatureReadout() throws ParseException {
            super("Potential Temperature", "K", 2);
        }

        @Override
        protected Real compute(Real pressure, Real temperature) throws RemoteException, VisADException {
            return (Real)PotentialTemperature.create(pressure, temperature);
        }
    }

    protected static abstract class PTDerivedReadout
    extends MyReadout {
        private Real temperature;
        private Real pressure;

        protected PTDerivedReadout(String name, String unitString, int fractionDigitCount) throws ParseException {
            super(name, unitString, fractionDigitCount);
        }

        public void setPressure(Real pressure) throws VisADException, RemoteException {
            this.pressure = pressure;
            this.compute();
        }

        public Real getPressure() {
            return this.pressure;
        }

        public void setTemperature(Real temperature) throws VisADException, RemoteException {
            this.temperature = temperature;
            this.compute();
        }

        public Real getTemperature() {
            return this.temperature;
        }

        protected void compute() throws VisADException, RemoteException {
            if (this.temperature != null && this.pressure != null) {
                try {
                    this.setReal(this.compute(this.pressure, this.temperature));
                }
                catch (Exception e) {
                    System.err.println("Couldn't compute " + this.getName() + ": " + e);
                }
            }
        }

        protected abstract Real compute(Real var1, Real var2) throws VisADException, RemoteException;
    }

    protected static class AltitudeReadout
    extends MyReadout {
        public AltitudeReadout() throws ParseException {
            super("Geopotential Altitude", "gpm", 0);
        }

        public void setPressure(Real pressure) {
            try {
                this.setReal((Real)GeopotentialAltitude.fromAltitude(AirPressure.toAltitude(pressure)));
            }
            catch (Exception e) {
                System.err.println("Couldn't set altitude readout: " + e);
            }
        }
    }

    protected static class TemperatureReadout
    extends MyReadout {
        public TemperatureReadout() throws ParseException {
            this("Temperature");
        }

        public TemperatureReadout(String name) throws ParseException {
            super(name, "degC", 2);
        }

        public void setTemperature(Real temperature) {
            this.setReal(temperature);
        }
    }

    protected static class WindDirectionReadout
    extends MyReadout {
        public WindDirectionReadout() throws ParseException {
            super("Wind Direction", "degree", 1);
        }

        public void setWindDirection(Real windDir) {
            this.setReal(windDir);
        }
    }

    protected static class WindSpeedReadout
    extends MyReadout {
        public WindSpeedReadout() throws ParseException {
            super("Wind Speed", "m/s", 1);
        }

        public void setWindSpeed(Real windSpeed) {
            this.setReal(windSpeed);
        }
    }

    protected static class PressureReadout
    extends MyReadout {
        public PressureReadout() throws ParseException {
            super("Pressure", "hPa", 1);
        }

        public void setPressure(Real pressure) {
            this.setReal(pressure);
        }
    }

    protected static class MyReadout
    extends RealReadout {
        public MyReadout(String name, String unitString, int fractionDigitCount) throws ParseException {
            this.setSpecifiedName(name);
            this.setNameUse(1);
            this.setSpecifiedUnit(unitString);
            this.setUnitUse(2);
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMinimumFractionDigits(fractionDigitCount);
            format.setMaximumFractionDigits(fractionDigitCount);
            this.setFormat(format);
        }
    }

    protected class SeparatorRowEntry
    extends RowEntry {
        private String name;

        public SeparatorRowEntry(String name) {
            this.name = name;
        }

        @Override
        public Object getValueAt(int column) {
            return column == 0 ? this.name + " " : null;
        }
    }

    protected class RealRowEntry
    extends RowEntry {
        private String prefix;
        private RealReadout readout;

        public RealRowEntry(RealReadout readout) {
            this(readout, "");
        }

        public RealRowEntry(RealReadout readout, String prefix) {
            this.readout = readout;
            this.prefix = prefix;
            readout.addPropertyChangeListener("name", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    ((MyTableModel)AerologicalReadoutTable.this.getModel()).fireTableCellUpdated(RealRowEntry.this.rowIndex, 0);
                }
            });
            readout.addPropertyChangeListener("numericString", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    ((MyTableModel)AerologicalReadoutTable.this.getModel()).fireTableCellUpdated(RealRowEntry.this.rowIndex, 1);
                }
            });
            readout.addPropertyChangeListener("unitString", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    ((MyTableModel)AerologicalReadoutTable.this.getModel()).fireTableCellUpdated(RealRowEntry.this.rowIndex, 2);
                }
            });
        }

        @Override
        public Object getValueAt(int column) {
            return column == 0 ? this.prefix + this.readout.getName() : (column == 1 ? this.readout.getNumericString() : this.readout.getUnitString());
        }
    }

    protected abstract class RowEntry {
        protected int rowIndex;

        protected RowEntry() {
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public abstract Object getValueAt(int var1);
    }

    protected class MyTableModel
    extends AbstractTableModel {
        private ArrayList rowEntries = new ArrayList();

        @Override
        public int getRowCount() {
            return this.rowEntries.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return ((RowEntry)this.rowEntries.get(row)).getValueAt(column);
        }

        public void addRowEntry(RowEntry entry) {
            entry.setRowIndex(this.rowEntries.size());
            this.rowEntries.add(entry);
        }
    }
}

