/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.view.sounding.AerologicalCoordinateSystem;
import ucar.unidata.view.sounding.AerologicalDisplayConstants;
import ucar.unidata.view.sounding.Box;
import ucar.unidata.view.sounding.CapeCalculator;
import ucar.unidata.view.sounding.DryAdiabats;
import ucar.unidata.view.sounding.DryTrajectory;
import ucar.unidata.view.sounding.EmagramCoordinateSystem;
import ucar.unidata.view.sounding.Isobars;
import ucar.unidata.view.sounding.Isotherms;
import ucar.unidata.view.sounding.MixingRatioTrajectory;
import ucar.unidata.view.sounding.SaturationAdiabats;
import ucar.unidata.view.sounding.SaturationMixingRatioContours;
import ucar.unidata.view.sounding.SaturationTrajectory;
import ucar.unidata.view.sounding.ScaleLabels;
import ucar.unidata.view.sounding.SkewTCoordinateSystem;
import ucar.unidata.view.sounding.Sounding;
import ucar.unidata.view.sounding.SoundingSet;
import ucar.unidata.view.sounding.StuveCoordinateSystem;
import ucar.unidata.view.sounding.TemperatureCalculator;
import ucar.unidata.view.sounding.TemperatureCalculatorFactory;
import ucar.unidata.view.sounding.WindBarbProfile;
import ucar.unidata.view.sounding.WindProfileSet;
import ucar.visad.Util;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.ContourLevels;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.Displayable;
import ucar.visad.display.ProfileLine;
import ucar.visad.display.ScalarMapSet;
import ucar.visad.functiontypes.CartesianHorizontalWindOfPressure;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.CartesianHorizontalWind;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.DewPoint;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.InSituAirTemperature;
import ucar.visad.quantities.SaturationEquivalentPotentialTemperature;
import ucar.visad.quantities.SaturationPointPressure;
import ucar.visad.quantities.SaturationPointTemperature;
import ucar.visad.quantities.SoutherlyWind;
import ucar.visad.quantities.VirtualTemperature;
import ucar.visad.quantities.WaterVaporMixingRatio;
import ucar.visad.quantities.WesterlyWind;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.DisplayTupleType;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Linear1DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.VisADRay;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.KeyboardBehaviorJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.KeyboardBehaviorJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;

public class AerologicalDisplay
extends DisplayMaster
implements AerologicalDisplayConstants {
    public static final String CURSOR_PRESSURE = "cursorPressure";
    public static final String POINTER_PRESSURE = "pointerPressure";
    public static final String CURSOR_TEMPERATURE = "cursorTemperature";
    public static final String POINTER_TEMPERATURE = "pointerTemperature";
    public static final String ACTIVE_SOUNDING = "activeSounding";
    public static final String ACTIVE_WIND_PROFILE = "activeWindProfile";
    public static final String PROFILE_TEMPERATURE = "profileTemperature";
    public static final String PROFILE_DEW_POINT = "profileDewPoint";
    public static final String PROFILE_WIND_SPEED = "profileWindSpeed";
    public static final String PROFILE_WIND_DIRECTION = "profileWindDirection";
    public static final String CAPE = "cAPE";
    private SoundingSet soundings;
    private WindProfileSet winds;
    private WindProfileSet winds1;
    private DisplayRealType displayPressureType;
    private DisplayRealType displayTemperatureType;
    private DisplayRealType displayZAxisType;
    private DisplayTupleType displayTupleType;
    private AerologicalCoordinateSystem coordinateSystem;
    private ScalarMap pressureMap;
    private ScalarMap inSituTempMap;
    private ScalarMap airTempMap;
    private ScalarMap virtTempMap;
    private ScalarMap dewPointMap;
    private CapeCalculator capeCalculator;
    private DryAdiabats dryAdiabats;
    private SaturationAdiabats saturationAdiabats;
    private SaturationMixingRatioContours satMixingRatios;
    private Isobars isobars;
    private Isotherms isotherms;
    private RightPressureAxisLabels rightPressureLabels;
    private LeftPressureAxisLabels leftPressureLabels;
    private LowerTemperatureAxisLabels lowerTemperatureLabels;
    private UpperTemperatureAxisLabels upperTemperatureLabels;
    private Box box;
    private MyWindStaff windStaff;
    private MyWindStaff windStaff1;
    private volatile Real pointerPressure;
    private volatile Real cursorTemperature;
    private volatile Real pointerTemperature;
    private DisplayablePseudoAdiabaticTrajectory pseudoAdiabaticTrajectory;
    private boolean constrainProfiles = true;
    private FlowControl flowControl = null;
    private int barbOrientation = 0;
    private int barbScale = 4;
    private int activeIndex = 0;
    private double WIND_STAFF_XPOS = 1.2;
    private static int instance = 0;
    private static Object INSTANCE_MUTEX = new Object();
    private List csDependentDisplays = new ArrayList();
    private boolean init = false;

    protected AerologicalDisplay(DisplayImpl display, int initialCapacity, DisplayRealType displayPressureType, DisplayRealType displayTemperatureType, AerologicalCoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        super(display, initialCapacity);
        this.displayPressureType = displayPressureType;
        this.displayTemperatureType = displayTemperatureType;
        this.coordinateSystem = coordinateSystem;
        this.initializeClass();
    }

    public AerologicalDisplay(AerologicalCoordinateSystem acs) throws VisADException, RemoteException {
        this(acs, null);
    }

    public AerologicalDisplay(AerologicalCoordinateSystem acs, GraphicsConfiguration gc) throws VisADException, RemoteException {
        this(new DisplayImplJ3D("Aerological Display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D(), gc), 6, null, null, acs);
    }

    protected void initializeClass() throws VisADException, RemoteException {
        this.setDisplayTypes();
        DisplayImpl display = (DisplayImpl)this.getDisplay();
        DisplayRenderer dispRend = display.getDisplayRenderer();
        dispRend.setBoxOn(false);
        dispRend.setCursorStringOn(false);
        if (dispRend instanceof DisplayRendererJ2D) {
            ((DisplayRendererJ2D)dispRend).addKeyboardBehavior(new KeyboardBehaviorJ2D((DisplayRendererJ2D)dispRend));
        } else {
            ((DisplayRendererJ3D)dispRend).addKeyboardBehavior(new KeyboardBehaviorJ3D((DisplayRendererJ3D)dispRend));
        }
        ((JPanel)this.getDisplay().getComponent()).setPreferredSize(new Dimension(512, 390));
        this.saveProjection();
        GraphicsModeControl gmc = this.getDisplay().getGraphicsModeControl();
        gmc.setPointSize(5.0f);
        this.soundings = new SoundingSet(display);
        this.winds = new WindProfileSet(new WindBarbProfile(display), display);
        this.winds.addConstantMap(new ConstantMap(this.WIND_STAFF_XPOS, Display.XAxis));
        this.winds1 = new WindProfileSet(new WindBarbProfile(display), display);
        this.winds1.addConstantMap(new ConstantMap(this.WIND_STAFF_XPOS + 0.4, Display.XAxis));
        this.soundings.setConstrainProfiles(this.constrainProfiles);
        this.pseudoAdiabaticTrajectory = new DisplayablePseudoAdiabaticTrajectory(this.getDisplay(), this.displayPressureType, this.displayTemperatureType);
        this.soundings.addPropertyChangeListener(SoundingSet.TEMPERATURE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(AerologicalDisplay.this, AerologicalDisplay.PROFILE_TEMPERATURE, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                AerologicalDisplay.this.firePropertyChange(newEvent);
            }
        });
        this.soundings.addPropertyChangeListener(SoundingSet.DEW_POINT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(AerologicalDisplay.this, AerologicalDisplay.PROFILE_DEW_POINT, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                AerologicalDisplay.this.firePropertyChange(newEvent);
                try {
                    AerologicalDisplay.this.pseudoAdiabaticTrajectory.recompute();
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + ".propertyChange(): " + "Couldn't handle profile dew-point change: " + e);
                }
            }
        });
        this.winds.addPropertyChangeListener(WindProfileSet.SPEED, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(AerologicalDisplay.this, AerologicalDisplay.PROFILE_WIND_SPEED, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                AerologicalDisplay.this.firePropertyChange(newEvent);
            }
        });
        this.winds.addPropertyChangeListener(WindProfileSet.DIRECTION, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(AerologicalDisplay.this, AerologicalDisplay.PROFILE_WIND_DIRECTION, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                AerologicalDisplay.this.firePropertyChange(newEvent);
            }
        });
        this.winds1.addPropertyChangeListener(WindProfileSet.SPEED, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(AerologicalDisplay.this, AerologicalDisplay.PROFILE_WIND_SPEED, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                AerologicalDisplay.this.firePropertyChange(newEvent);
            }
        });
        this.winds1.addPropertyChangeListener(WindProfileSet.DIRECTION, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(AerologicalDisplay.this, AerologicalDisplay.PROFILE_WIND_DIRECTION, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                AerologicalDisplay.this.firePropertyChange(newEvent);
            }
        });
        this.soundings.addPropertyChangeListener(SoundingSet.ACTIVE_SOUNDING, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                try {
                    if (!AerologicalDisplay.this.isPseudoAdiabaticTrajectoryEnabled()) {
                        AerologicalDisplay.this.pseudoAdiabaticTrajectory.clear();
                    }
                    PropertyChangeEvent newEvent = new PropertyChangeEvent(AerologicalDisplay.this, AerologicalDisplay.ACTIVE_SOUNDING, null, event.getNewValue());
                    newEvent.setPropagationId(event.getPropagationId());
                    AerologicalDisplay.this.firePropertyChange(newEvent);
                }
                catch (Exception e) {
                    System.err.println("ACTIVE_SOUNDING: " + e.toString());
                }
            }
        });
        this.winds.addPropertyChangeListener(WindProfileSet.ACTIVE_WIND_PROFILE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                try {
                    PropertyChangeEvent newEvent = new PropertyChangeEvent(AerologicalDisplay.this, AerologicalDisplay.ACTIVE_WIND_PROFILE, null, event.getNewValue());
                    newEvent.setPropagationId(event.getPropagationId());
                    AerologicalDisplay.this.firePropertyChange(newEvent);
                }
                catch (Exception e) {
                    System.err.println("ACTIVE_WIND_PROFILE: " + e.toString());
                }
            }
        });
        this.winds1.addPropertyChangeListener(WindProfileSet.ACTIVE_WIND_PROFILE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                try {
                    PropertyChangeEvent newEvent = new PropertyChangeEvent(AerologicalDisplay.this, AerologicalDisplay.ACTIVE_WIND_PROFILE, null, event.getNewValue());
                    newEvent.setPropagationId(event.getPropagationId());
                    AerologicalDisplay.this.firePropertyChange(newEvent);
                }
                catch (Exception e) {
                    System.err.println("ACTIVE_WIND_PROFILE: " + e.toString());
                }
            }
        });
        display.enableEvent(21);
        display.enableEvent(18);
        this.addDisplayListener(new DisplayListener(){

            @Override
            public void displayChanged(DisplayEvent event) {
                int id = event.getId();
                try {
                    if (id == 4) {
                        AerologicalDisplay.this.cursorMoved();
                    } else if (id == 21) {
                        AerologicalDisplay.this.pointerMoved(event.getX(), event.getY());
                    } else if (id == 18) {
                        int mods = event.getInputEvent().getModifiers();
                        if ((mods & 8) != 0) {
                            AerologicalDisplay.this.cursorMoved();
                        } else if ((mods & 4) != 0) {
                            AerologicalDisplay.this.pointerMoved(event.getX(), event.getY());
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("MOUSE_EVENT: " + e.toString());
                }
            }
        });
        this.capeCalculator = new CapeCalculator();
        this.capeCalculator.addPropertyChangeListener(this.capeCalculator.CAPE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(this, AerologicalDisplay.CAPE, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                AerologicalDisplay.this.firePropertyChange(newEvent);
            }
        });
        this.addDisplayable(this.soundings);
        this.setWindColor(this.getForeground());
        this.addDisplayable(this.winds);
        this.addDisplayable(this.winds1);
        this.addDisplayable(this.pseudoAdiabaticTrajectory);
        this.box = new Box(this.coordinateSystem);
        this.addDisplayable(this.box);
        this.isobars = new Isobars(this.coordinateSystem);
        this.addDisplayable(this.isobars);
        this.isobars.setVisible(true);
        this.isotherms = new Isotherms(this.coordinateSystem);
        this.addDisplayable(this.isotherms);
        this.setBackgroundLineColor(this.getForeground());
        this.dryAdiabats = new DryAdiabats(this.coordinateSystem);
        this.addDisplayable(this.dryAdiabats);
        this.saturationAdiabats = new SaturationAdiabats(this.coordinateSystem);
        this.addDisplayable(this.saturationAdiabats);
        this.satMixingRatios = new SaturationMixingRatioContours(this.coordinateSystem);
        this.addDisplayable(this.satMixingRatios);
        this.satMixingRatios.setVisible(false);
        this.windStaff = new MyWindStaff(this.coordinateSystem);
        this.addDisplayable(this.windStaff);
        this.windStaff1 = new MyWindStaff(this.coordinateSystem, 0.4);
        this.addDisplayable(this.windStaff1);
        this.windStaff.setVisible(false);
        this.windStaff1.setVisible(false);
        this.leftPressureLabels = new LeftPressureAxisLabels(this.coordinateSystem, this.isobars.getContourLevels());
        this.addDisplayable(this.leftPressureLabels);
        this.rightPressureLabels = new RightPressureAxisLabels(this.coordinateSystem, this.isobars.getContourLevels());
        this.addDisplayable(this.rightPressureLabels);
        this.rightPressureLabels.setVisible(false);
        this.lowerTemperatureLabels = new LowerTemperatureAxisLabels(this.coordinateSystem, this.isotherms.getContourLevels());
        this.addDisplayable(this.lowerTemperatureLabels);
        this.upperTemperatureLabels = new UpperTemperatureAxisLabels(this.coordinateSystem, this.isotherms.getContourLevels());
        this.addDisplayable(this.upperTemperatureLabels);
        this.setLabelColor(this.getForeground());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisplayTypes() throws VisADException, RemoteException {
        int myInstance;
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            myInstance = instance++;
        }
        double minP = this.getCoordinateSystem().getMinimumPressure().getValue(CommonUnits.HECTOPASCAL);
        double maxP = this.getCoordinateSystem().getMaximumPressure().getValue(CommonUnits.HECTOPASCAL);
        this.displayPressureType = new DisplayRealType("ADPressure" + myInstance, true, minP, maxP, (maxP - minP) / 2.0, CommonUnits.HECTOPASCAL);
        double minT = this.getCoordinateSystem().getMinimumTemperature().getValue(CommonUnits.CELSIUS);
        double maxT = this.getCoordinateSystem().getMaximumTemperature().getValue(CommonUnits.CELSIUS);
        this.displayTemperatureType = new DisplayRealType("ADTemperature" + myInstance, true, minT, maxT, (maxT - minT) / 2.0, CommonUnits.CELSIUS);
        this.displayZAxisType = new DisplayRealType("ADZAxis" + myInstance, true, 0.0, null);
        this.displayTupleType = new DisplayTupleType(new DisplayRealType[]{this.displayPressureType, this.displayTemperatureType, this.displayZAxisType}, this.getCoordinateSystem().createDisplayCoordinateSystem(this.coordinateSystem));
        this.setDisplayScalarMaps();
    }

    protected void setDisplayScalarMaps() throws VisADException, RemoteException {
        this.setDisplayInactive();
        ScalarMapSet mapSet = new ScalarMapSet();
        if (!this.init) {
            ScalarMap map = new ScalarMap(RealType.XAxis, Display.XAxis);
            double[] range = new double[2];
            Display.XAxis.getRange(range);
            map.setRange(range[0], range[1]);
            mapSet.add(map);
            Display.YAxis.getRange(range);
            map = new ScalarMap(RealType.YAxis, Display.YAxis);
            map.setRange(range[0], range[1]);
            mapSet.add(map);
            ScalarMap xFlow = new ScalarMap(WesterlyWind.getRealType(), Display.Flow1X);
            xFlow.setRange(-1.0, 1.0);
            xFlow.addScalarMapListener(new ScalarMapListener(){

                @Override
                public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                    block5: {
                        block4: {
                            int id = event.getId();
                            if (id == 3) break block4;
                            if (id != 5) break block5;
                        }
                        AerologicalDisplay.this.flowControl = (FlowControl)event.getControl();
                        if (AerologicalDisplay.this.flowControl != null) {
                            AerologicalDisplay.this.flowControl.setBarbOrientation(AerologicalDisplay.this.barbOrientation);
                            AerologicalDisplay.this.setFlowScale();
                        }
                    }
                }

                @Override
                public void mapChanged(ScalarMapEvent event) {
                }
            });
            mapSet.add(xFlow);
            ScalarMap yFlow = new ScalarMap(SoutherlyWind.getRealType(), Display.Flow1Y);
            yFlow.setRange(-1.0, 1.0);
            mapSet.add(yFlow);
            this.init = true;
        }
        if (this.pressureMap != null) {
            this.removeScalarMap(this.pressureMap);
        }
        this.pressureMap = new ScalarMap(AirPressure.getRealType(), this.displayPressureType);
        this.pressureMap.setRangeByUnits();
        mapSet.add(this.pressureMap);
        if (this.inSituTempMap != null) {
            this.removeScalarMap(this.inSituTempMap);
        }
        this.inSituTempMap = new ScalarMap(InSituAirTemperature.getRealType(), this.displayTemperatureType);
        this.inSituTempMap.setRangeByUnits();
        mapSet.add(this.inSituTempMap);
        if (this.airTempMap != null) {
            this.removeScalarMap(this.airTempMap);
        }
        this.airTempMap = new ScalarMap(AirTemperature.getRealType(), this.displayTemperatureType);
        this.airTempMap.setRangeByUnits();
        mapSet.add(this.airTempMap);
        if (this.virtTempMap != null) {
            this.removeScalarMap(this.virtTempMap);
        }
        this.virtTempMap = new ScalarMap(VirtualTemperature.getRealType(), this.displayTemperatureType);
        this.virtTempMap.setRangeByUnits();
        mapSet.add(this.virtTempMap);
        if (this.dewPointMap != null) {
            this.removeScalarMap(this.dewPointMap);
        }
        this.dewPointMap = new ScalarMap(DewPoint.getRealType(), this.displayTemperatureType);
        this.dewPointMap.setRangeByUnits();
        mapSet.add(this.dewPointMap);
        this.addScalarMaps(mapSet);
        this.setDisplayActive();
    }

    public AerologicalCoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setCoordinateSystem(String type) throws VisADException, RemoteException {
        if (type.equals("skewT")) {
            this.setCoordinateSystem(SkewTCoordinateSystem.instance());
        } else if (type.equals("stuve")) {
            this.setCoordinateSystem(StuveCoordinateSystem.instance());
        } else if (type.equals("emagram")) {
            this.setCoordinateSystem(EmagramCoordinateSystem.instance());
        } else {
            throw new IllegalArgumentException("Unknown aerological display type " + type);
        }
    }

    public void setCoordinateSystem(AerologicalCoordinateSystem acs) throws VisADException, RemoteException {
        if (Misc.equals(this.coordinateSystem, acs)) {
            return;
        }
        this.coordinateSystemChange(acs);
    }

    protected void coordinateSystemChange(AerologicalCoordinateSystem acs) throws VisADException, RemoteException {
        WindBarbProfile wbp;
        this.setDisplayInactive();
        this.box.setCoordinateSystem(acs);
        this.isobars.setCoordinateSystem(acs);
        this.isotherms.setCoordinateSystem(acs);
        this.dryAdiabats.setCoordinateSystem(acs);
        this.saturationAdiabats.setCoordinateSystem(acs);
        this.satMixingRatios.setCoordinateSystem(acs);
        this.rightPressureLabels.setCoordinateSystem(acs);
        this.leftPressureLabels.setCoordinateSystem(acs);
        this.lowerTemperatureLabels.setCoordinateSystem(acs);
        this.upperTemperatureLabels.setCoordinateSystem(acs);
        this.windStaff.setCoordinateSystem(acs);
        this.windStaff1.setCoordinateSystem(acs);
        Iterator iter = this.winds.iterator();
        while (iter.hasNext()) {
            wbp = (WindBarbProfile)iter.next();
            if (wbp == null) continue;
            wbp.setCoordinateSystem(acs);
        }
        iter = this.winds1.iterator();
        while (iter.hasNext()) {
            wbp = (WindBarbProfile)iter.next();
            if (wbp == null) continue;
            wbp.setCoordinateSystem(acs);
        }
        this.coordinateSystem = acs;
        this.setDisplayTypes();
        this.setDisplayActive();
    }

    public void addProfile(Field temperature, Field dewPoint) throws VisADException, RemoteException {
        this.addProfile(this.soundings.displayableCount(), temperature, dewPoint, null);
    }

    public void addProfile(Field temperature, Field dewPoint, Field windProfile) throws VisADException, RemoteException {
        this.addProfile(this.soundings.displayableCount(), temperature, dewPoint, windProfile);
    }

    public void addProfile(int index, Field temperature, Field dewPoint, Field windProfile) throws VisADException, RemoteException {
        Sounding sounding = (Sounding)this.soundings.getDisplayable(index);
        if (sounding == null) {
            sounding = new Sounding(this.getDisplay());
            this.soundings.addSounding(index, sounding);
        }
        WindBarbProfile windBarbs = (WindBarbProfile)this.winds.getDisplayable(index);
        WindBarbProfile windBarbs1 = (WindBarbProfile)this.winds1.getDisplayable(index);
        if (windBarbs == null) {
            windBarbs = new WindBarbProfile(this.getDisplay(), this.getCoordinateSystem());
            this.winds.addWindProfile(index, windBarbs);
            this.winds.setColor(this.getForeground());
        }
        if (windBarbs1 == null) {
            windBarbs1 = new WindBarbProfile(this.getDisplay(), this.getCoordinateSystem());
            this.winds1.addWindProfile(index, windBarbs1);
            this.winds1.setColor(this.getForeground());
        }
        sounding.setFields(temperature, dewPoint);
        Field ff = this.vetWinds(windProfile);
        if (ff != null) {
            windBarbs.setProfile(ff);
            this.windStaff.setVisible(true);
        }
        if (ff != null) {
            windBarbs1.setProfile(ff);
            this.windStaff1.setVisible(false);
        }
        windBarbs.setVisible(false);
        windBarbs1.setVisible(false);
    }

    public int profileCount() {
        return this.soundings.displayableCount();
    }

    public void removeProfiles() throws VisADException, RemoteException {
        this.soundings.clear();
        this.winds.clear();
        this.winds1.clear();
    }

    public void removeProfile(int index) throws VisADException, RemoteException {
        this.soundings.removeSounding(index);
        this.winds.removeWindProfile(index);
        this.winds1.removeWindProfile(index);
    }

    public void setProfileVisible(int index, boolean visible) throws VisADException, RemoteException {
        this.soundings.setVisible(visible, index, index);
        this.winds.setVisible(visible, index, index);
    }

    public void setProfilesVisibility(boolean visible, int index) throws VisADException, RemoteException {
        int n = this.soundings.displayableCount();
        if (n < 2) {
            return;
        }
        this.soundings.setVisible(false, 0, n - 1);
        this.winds.setVisible(false, 0, n - 1);
        this.winds1.setVisible(false, 0, n - 1);
        this.windStaff1.setVisible(visible);
        for (int i = 0; i < n; ++i) {
            this.soundings.setLineStyle(0, i);
        }
        if (visible) {
            this.soundings.setVisible(true, index, index + 1);
            this.winds.setVisible(true, index, index);
            this.winds1.setVisible(true, index + 1, index + 1);
            this.soundings.setLineStyle(1, index);
        } else {
            this.soundings.setVisible(true, 0, 0);
            this.soundings.setActiveSounding(0);
            this.winds.setActiveWindProfile(0);
            this.winds.setVisible(true, 0, 0);
        }
    }

    public void setActiveSounding(int index) throws VisADException, RemoteException {
        this.soundings.setActiveSounding(index);
        this.winds.setActiveWindProfile(index);
        this.activeIndex = index;
    }

    public void setOriginalProfiles(int index) throws VisADException, RemoteException {
        this.soundings.setOriginalProfiles(index);
        this.winds.setOriginalProfile(index);
    }

    public void clearProfiles() throws VisADException, RemoteException {
        this.soundings.clear();
        this.winds.clear();
        this.winds1.clear();
        this.pseudoAdiabaticTrajectory.clear();
    }

    public void setConstrainProfiles(boolean yes) throws VisADException, RemoteException {
        this.soundings.setConstrainProfiles(yes);
    }

    public final void setCursorPressure(Real pressure) throws UnitException, VisADException, RemoteException {
        Real oldPressure = this.getCursorPressure();
        this.soundings.setPressure(pressure);
        this.winds.setPressure(pressure);
        this.firePropertyChange(CURSOR_PRESSURE, oldPressure, pressure);
    }

    public final void setPointerPressure(Real pressure) throws UnitException, VisADException, RemoteException {
        Real oldPressure = this.getPointerPressure();
        this.pointerPressure = pressure;
        this.firePropertyChange(POINTER_PRESSURE, oldPressure, pressure);
    }

    public Real getCursorPressure() {
        return this.soundings.getPressure();
    }

    public Real getPointerPressure() {
        return this.pointerPressure;
    }

    protected final void setCursorTemperature(Real temperature) throws UnitException, VisADException, RemoteException {
        Real oldTemperature = this.cursorTemperature;
        this.cursorTemperature = temperature;
        this.pseudoAdiabaticTrajectory.recompute();
        this.firePropertyChange(CURSOR_TEMPERATURE, oldTemperature, this.cursorTemperature);
    }

    protected final void setPointerTemperature(Real temperature) throws UnitException, VisADException, RemoteException {
        Real oldTemperature = this.pointerTemperature;
        this.pointerTemperature = temperature;
        this.firePropertyChange(POINTER_TEMPERATURE, oldTemperature, this.pointerTemperature);
    }

    public Real getCursorTemperature() {
        return this.cursorTemperature;
    }

    public Real getPointerTemperature() {
        return this.pointerTemperature;
    }

    public Real getProfileTemperature() {
        return this.soundings.getTemperature();
    }

    public Real getProfileDewPoint() {
        return this.soundings.getDewPoint();
    }

    public Real getProfileWindSpeed() {
        return this.winds.getSpeed();
    }

    public Real getProfileWindDirection() {
        return this.winds.getDirection();
    }

    public void setPseudoAdiabaticTrajectoryEnabled(boolean enable) throws VisADException, RemoteException {
        this.pseudoAdiabaticTrajectory.setEnabled(enable);
    }

    public boolean isPseudoAdiabaticTrajectoryEnabled() {
        return this.pseudoAdiabaticTrajectory.isEnabled();
    }

    public void setPseudoAdiabaticTrajectoryVisible(boolean visible) throws VisADException, RemoteException {
        this.pseudoAdiabaticTrajectory.setVisible(visible);
    }

    public boolean isPseudoAdiabaticTrajectoryVisible() {
        return this.pseudoAdiabaticTrajectory.getVisible();
    }

    public void clearPseudoAdiabaticTrajectory() throws VisADException, RemoteException {
        this.pseudoAdiabaticTrajectory.clear();
    }

    public Real getMinimumPressure() {
        return this.coordinateSystem.getMinimumPressure();
    }

    public Real getMaximumPressure() {
        return this.coordinateSystem.getMaximumPressure();
    }

    public Real getMinimumTemperature() {
        return this.coordinateSystem.getMinimumTemperature();
    }

    public Real getMaximumTemperature() {
        return this.coordinateSystem.getMaximumTemperature();
    }

    public void setDryAdiabatVisibility(boolean on) throws VisADException, RemoteException {
        this.dryAdiabats.setVisible(on);
    }

    public void setIsobarsVisibility(boolean on) throws VisADException, RemoteException {
        this.isobars.setVisible(on);
    }

    public boolean getDryAdiabatVisibility() {
        return this.dryAdiabats.getVisible();
    }

    public boolean getIsoBarsVisibility() {
        return this.isobars.getVisible();
    }

    public void setSaturationAdiabatVisibility(boolean on) throws VisADException, RemoteException {
        this.saturationAdiabats.setVisible(on);
    }

    public boolean getSaturationAdiabatVisibility() {
        return this.saturationAdiabats.getVisible();
    }

    public void setWindStaffVisibility(boolean on) throws VisADException, RemoteException {
        this.windStaff.setVisible(on);
    }

    public boolean getWindStaffVisibility() {
        return this.windStaff.getVisible();
    }

    public void setWindLevels(Gridded1DSet levels) throws VisADException, RemoteException {
        this.winds.setWindLevels(levels);
    }

    public void setSaturationMixingRatioVisibility(boolean on) throws VisADException, RemoteException {
        this.satMixingRatios.setVisible(on);
    }

    public boolean getSaturationMixingRatioVisibility() {
        return this.satMixingRatios.getVisible();
    }

    private void cursorMoved() throws UnitException, VisADException, RemoteException {
        double[] cursor = this.getDisplay().getDisplayRenderer().getCursor();
        Real[] aeroCoords = this.aeroCoords(cursor[0], cursor[1]);
        this.setCursorPressure(aeroCoords[0]);
        this.setCursorTemperature(aeroCoords[1]);
    }

    private void pointerMoved(int x, int y) throws UnitException, VisADException, RemoteException {
        VisADRay ray = this.getDisplay().getDisplayRenderer().getMouseBehavior().findRay(x, y);
        Real[] aeroCoords = this.aeroCoords(ray.position[0], ray.position[1]);
        this.setPointerPressure(aeroCoords[0]);
        this.setPointerTemperature(aeroCoords[1]);
    }

    private void setFlowScale() {
        if (this.flowControl != null) {
            try {
                this.flowControl.setFlowScale((float)this.getBarbScale() * 0.02f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setBarbOrientation(int orient) {
        if (orient != 0 && orient != 1) {
            throw new IllegalArgumentException("Unknown orientation: " + orient);
        }
        if (orient != this.barbOrientation) {
            this.barbOrientation = orient;
            if (this.flowControl != null) {
                try {
                    this.flowControl.setBarbOrientation(this.barbOrientation);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public int getBarbOrientation() {
        return this.barbOrientation;
    }

    public void setBarbScale(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than 0");
        }
        if (size != this.barbScale) {
            this.barbScale = size;
            this.setFlowScale();
        }
    }

    public int getBarbScale() {
        return this.barbScale;
    }

    private Field vetWinds(Field profile) throws VisADException, RemoteException {
        if (profile == null) {
            return profile;
        }
        boolean isSequence = GridUtil.isTimeSequence((FieldImpl)profile);
        FlatField data = isSequence ? (FlatField)profile.getSample(0) : (FlatField)profile;
        data = this.ensureCartesian(data);
        return data;
    }

    private FlatField ensureCartesian(FlatField input) throws VisADException, RemoteException {
        FlatField output;
        FunctionType inputFunction = (FunctionType)input.getType();
        if (inputFunction.getDomain().getComponent(0).equals(GeopotentialAltitude.getRealType())) {
            input = Util.convertDomain(input, AirPressure.getRealTupleType(), (CoordinateSystem)AirPressure.getStandardAtmosphereCS());
        }
        if (Unit.canConvert(input.getDefaultRangeUnits()[0], CommonUnit.meterPerSecond) && Unit.canConvert(input.getDefaultRangeUnits()[1], CommonUnit.meterPerSecond)) {
            output = input;
        } else {
            RealTupleType cartesianType = CartesianHorizontalWind.getRealTupleType();
            output = new FlatField(CartesianHorizontalWindOfPressure.instance(), input.getDomainSet());
            RealTupleType inputType = (RealTupleType)((FunctionType)input.getType()).getRange();
            ErrorEstimate[] inputErrors = input.getRangeErrors();
            ErrorEstimate[] outputErrors = new ErrorEstimate[inputErrors.length];
            output.setSamples(CoordinateSystem.transformCoordinates(cartesianType, cartesianType.getCoordinateSystem(), cartesianType.getDefaultUnits(), outputErrors, inputType, Util.getRangeCoordinateSystem(input), Util.getRangeUnits(input), inputErrors, input.getValues()));
        }
        return output;
    }

    private Real[] aeroCoords(double x, double y) throws UnitException, VisADException, RemoteException {
        double[][] coords = this.getCoordinateSystem().fromReference(new double[][]{{x}, {y}});
        return new Real[]{new Real(AirPressure.getRealType(), coords[0][0], this.getCoordinateSystem().getCoordinateSystemUnits()[0]), new Real(AirTemperature.getRealType(), coords[1][0], this.getCoordinateSystem().getCoordinateSystemUnits()[1])};
    }

    public static AerologicalDisplay getInstance(String type) throws VisADException, RemoteException {
        return AerologicalDisplay.getInstance(type, null);
    }

    public static AerologicalDisplay getInstance(String type, GraphicsConfiguration gc) throws VisADException, RemoteException {
        if (type.equals("skewT")) {
            return AerologicalDisplay.getInstance(SkewTCoordinateSystem.instance(), gc);
        }
        if (type.equals("stuve")) {
            return AerologicalDisplay.getInstance(StuveCoordinateSystem.instance(), gc);
        }
        if (type.equals("emagram")) {
            return AerologicalDisplay.getInstance(EmagramCoordinateSystem.instance(), gc);
        }
        throw new IllegalArgumentException("Unknown aerological display type " + type);
    }

    public static AerologicalDisplay getInstance(AerologicalCoordinateSystem acs, GraphicsConfiguration gc) throws VisADException, RemoteException {
        return new AerologicalDisplay(acs, gc);
    }

    public Sounding getActiveSounding() {
        return this.soundings.getActiveSounding();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.setLabelColor(color);
        this.setWindColor(color);
        this.setBackgroundLineColor(color);
    }

    public void setLabelColor(Color color) {
        try {
            if (this.leftPressureLabels != null) {
                this.leftPressureLabels.setColor(color);
                this.rightPressureLabels.setColor(color);
                this.lowerTemperatureLabels.setColor(color);
                this.upperTemperatureLabels.setColor(color);
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setWindColor(Color color) {
        try {
            if (this.winds != null) {
                this.winds.setColor(color);
                this.winds1.setColor(color);
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setBackgroundLineColor(Color color) {
        try {
            if (this.isotherms != null) {
                this.box.setColor(color);
                this.isobars.setColor(color);
                this.isotherms.setColor(color);
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    protected class MyWindStaff
    extends ProfileLine {
        public MyWindStaff(AerologicalCoordinateSystem acs) throws VisADException, RemoteException {
            super("WindStaff");
            this.setColor(Color.yellow);
            this.addConstantMap(new ConstantMap(AerologicalDisplay.this.WIND_STAFF_XPOS, Display.XAxis));
            this.setCoordinateSystem(acs);
        }

        public MyWindStaff(AerologicalCoordinateSystem acs, double xp0) throws VisADException, RemoteException {
            super("WindStaff");
            this.setColor(Color.yellow);
            this.addConstantMap(new ConstantMap(AerologicalDisplay.this.WIND_STAFF_XPOS + xp0, Display.XAxis));
            this.setCoordinateSystem(acs);
        }

        public void setCoordinateSystem(AerologicalCoordinateSystem acs) throws VisADException, RemoteException {
            this.setData(new Linear1DSet((MathType)RealType.YAxis, acs.getMinimumY().getValue(), acs.getMaximumY().getValue(), 2));
        }
    }

    protected class MyWetTemperatureCalculator
    implements TemperatureCalculator {
        private Real satEquivPotTemp;

        public MyWetTemperatureCalculator(Real saturationPressure, Real saturationTemperature) throws TypeException, VisADException, RemoteException {
            this.satEquivPotTemp = (Real)SaturationEquivalentPotentialTemperature.create(saturationPressure, saturationTemperature);
        }

        @Override
        public Real nextTemperature(Real nextPressure) throws VisADException {
            return AerologicalDisplay.this.saturationAdiabats.getTemperature(nextPressure, this.satEquivPotTemp);
        }
    }

    protected class MyWetTemperatureCalculatorFactory
    implements TemperatureCalculatorFactory {
        @Override
        public TemperatureCalculator newTemperatureCalculator(Real saturationPressure, Real saturationTemperature) throws TypeException, VisADException, RemoteException {
            return new MyWetTemperatureCalculator(saturationPressure, saturationTemperature);
        }
    }

    protected class DisplayablePseudoAdiabaticTrajectory
    extends CompositeDisplayable {
        private DryTrajectory dryTrajectory;
        private SaturationTrajectory wetTrajectory;
        private MixingRatioTrajectory mixingRatioTrajectory;
        private boolean isEnabled;
        private RealType pressureType;
        private RealType temperatureType;

        public DisplayablePseudoAdiabaticTrajectory(LocalDisplay display, DisplayRealType displayPressureType, DisplayRealType displayTemperatureType) throws VisADException, RemoteException {
            super(display);
            this.isEnabled = false;
            this.pressureType = AirPressure.getRealType();
            this.temperatureType = AirTemperature.getRealType();
            this.dryTrajectory = new DryTrajectory();
            this.mixingRatioTrajectory = new MixingRatioTrajectory();
            this.wetTrajectory = new SaturationTrajectory(new MyWetTemperatureCalculatorFactory());
            this.dryTrajectory.setLineWidth(2.0f);
            this.dryTrajectory.setHSV(0.0, 0.2, 1.0);
            this.mixingRatioTrajectory.setLineWidth(2.0f);
            this.mixingRatioTrajectory.setHSV(120.0, 0.2, 1.0);
            this.wetTrajectory.setLineWidth(2.0f);
            this.wetTrajectory.setHSV(240.0, 0.2, 1.0);
            this.wetTrajectory.addPropertyChangeListener(SaturationTrajectory.TRAJECTORY, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    try {
                        Sounding sounding = AerologicalDisplay.this.soundings.getActiveSounding();
                        AerologicalDisplay.this.capeCalculator.setCape(sounding.getTemperatureField(), sounding.getDewPointField(), (FlatField)event.getNewValue());
                    }
                    catch (Exception e) {
                        System.err.println(this.getClass().getName() + ".propertyChange(): " + "Couldn't handle change to parcel's saturation-trajectory: " + e);
                    }
                }
            });
            this.addDisplayable(this.dryTrajectory);
            this.addDisplayable(this.mixingRatioTrajectory);
            this.addDisplayable(this.wetTrajectory);
        }

        public void setEnabled(boolean enable) throws VisADException, RemoteException {
            this.isEnabled = enable;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public RealType getPressureType() {
            return this.dryTrajectory.getPressureType();
        }

        public RealType getTemperatureType() {
            return this.dryTrajectory.getTemperatureType();
        }

        public void clear() throws VisADException, RemoteException {
            this.dryTrajectory.clear();
            this.mixingRatioTrajectory.clear();
            this.wetTrajectory.clear();
        }

        public void recompute() throws TypeException, RemoteException, VisADException {
            if (this.isEnabled) {
                Real startingPressure = AerologicalDisplay.this.getCursorPressure();
                Real startingTemperature = AerologicalDisplay.this.getCursorTemperature();
                Real startingDewPoint = AerologicalDisplay.this.getProfileDewPoint();
                Real minPressure = AerologicalDisplay.this.getMinimumPressure();
                if (startingPressure == null || startingTemperature == null || startingDewPoint == null || minPressure == null) {
                    this.clear();
                } else {
                    Real saturationPointMixingRatio = (Real)WaterVaporMixingRatio.create(startingPressure, startingDewPoint);
                    Real saturationPointTemperature = (Real)SaturationPointTemperature.create(startingPressure, startingTemperature, saturationPointMixingRatio);
                    Real saturationPointPressure = (Real)SaturationPointPressure.create(startingPressure, startingTemperature, saturationPointTemperature);
                    this.dryTrajectory.setTrajectory(startingPressure, startingTemperature, saturationPointPressure);
                    this.mixingRatioTrajectory.setTrajectory(saturationPointPressure, saturationPointTemperature, startingPressure);
                    this.wetTrajectory.setTrajectory(saturationPointPressure, saturationPointTemperature, minPressure);
                }
            }
        }
    }

    protected static class UpperTemperatureAxisLabels
    extends TemperatureAxisLabels {
        private ContourLevels contourLevels;

        public UpperTemperatureAxisLabels(AerologicalCoordinateSystem coordinateSystem, ContourLevels contourLevels) throws RemoteException, VisADException {
            super("UpperTemperatureAxisLabels");
            this.contourLevels = contourLevels;
            this.setCoordinateSystem(coordinateSystem);
        }

        @Override
        protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws RemoteException, VisADException {
            this.set(coordinateSystem, coordinateSystem.getMaximumY(), this.contourLevels, coordinateSystem.getMinimumPressure(), 0.02);
        }

        protected UpperTemperatureAxisLabels(UpperTemperatureAxisLabels that) throws RemoteException, VisADException {
            super(that);
            this.contourLevels = that.contourLevels;
        }

        @Override
        public Displayable cloneForDisplay() throws RemoteException, VisADException {
            return new UpperTemperatureAxisLabels(this);
        }
    }

    protected static class LowerTemperatureAxisLabels
    extends TemperatureAxisLabels {
        private ContourLevels contourLevels;

        public LowerTemperatureAxisLabels(AerologicalCoordinateSystem coordinateSystem, ContourLevels contourLevels) throws RemoteException, VisADException {
            super("LowerTemperatureAxisLabels");
            this.contourLevels = contourLevels;
            this.setCoordinateSystem(coordinateSystem);
        }

        @Override
        protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws RemoteException, VisADException {
            this.set(coordinateSystem, coordinateSystem.getMinimumY(), this.contourLevels, coordinateSystem.getMaximumPressure(), -0.08);
        }

        protected LowerTemperatureAxisLabels(LowerTemperatureAxisLabels that) throws RemoteException, VisADException {
            super(that);
            this.contourLevels = that.contourLevels;
        }

        @Override
        public Displayable cloneForDisplay() throws RemoteException, VisADException {
            return new LowerTemperatureAxisLabels(this);
        }
    }

    protected static abstract class TemperatureAxisLabels
    extends ScaleLabels {
        protected TemperatureAxisLabels(String name) throws RemoteException, VisADException {
            super(name, RealType.XAxis);
            DecimalFormat format = new DecimalFormat("##0");
            this.setFormat(format);
            this.setXAlignment(0.5f);
        }

        protected TemperatureAxisLabels(TemperatureAxisLabels that) throws RemoteException, VisADException {
            super(that);
        }

        protected final void set(AerologicalCoordinateSystem coordinateSystem, Real yValue, ContourLevels contourLevels, Real pressure, double separation) throws RemoteException, VisADException {
            double y = yValue.getValue();
            float[] temperatureValues = contourLevels.getLevels((float)coordinateSystem.fromReference(new double[][]{{coordinateSystem.getMinimumX().getValue()}, {y}})[1][0], (float)coordinateSystem.fromReference(new double[][]{{coordinateSystem.getMaximumX().getValue()}, {y}})[1][0]);
            float[] pressureValues = new float[temperatureValues.length];
            Arrays.fill(pressureValues, (float)pressure.getValue());
            this.setPositionValues(coordinateSystem.toReference(new float[][]{pressureValues, temperatureValues})[0]);
            this.setLabelValues(temperatureValues);
            this.addConstantMap(new ConstantMap(y + separation, Display.YAxis));
        }

        public void setCoordinateSystem(AerologicalCoordinateSystem acs) throws VisADException, RemoteException {
            this.coordinateSystemChange(acs);
        }

        protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        }
    }

    protected static class RightPressureAxisLabels
    extends PressureAxisLabels {
        private ContourLevels contourLevels;

        public RightPressureAxisLabels(AerologicalCoordinateSystem coordinateSystem, ContourLevels contourLevels) throws RemoteException, VisADException {
            super("RightPressureAxisLabels");
            this.contourLevels = contourLevels;
            this.setCoordinateSystem(coordinateSystem);
        }

        @Override
        protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws RemoteException, VisADException {
            this.set(coordinateSystem, coordinateSystem.getMaximumX(), this.contourLevels, coordinateSystem.getMaximumTemperature(), 0.02);
        }

        protected RightPressureAxisLabels(RightPressureAxisLabels that) throws RemoteException, VisADException {
            super(that);
            this.contourLevels = that.contourLevels;
        }

        @Override
        public Displayable cloneForDisplay() throws RemoteException, VisADException {
            return new RightPressureAxisLabels(this);
        }
    }

    protected static class LeftPressureAxisLabels
    extends PressureAxisLabels {
        private ContourLevels contourLevels;

        public LeftPressureAxisLabels(AerologicalCoordinateSystem coordinateSystem, ContourLevels contourLevels) throws RemoteException, VisADException {
            super("LeftPressureAxisLabels");
            this.contourLevels = contourLevels;
            this.setCoordinateSystem(coordinateSystem);
        }

        @Override
        protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws RemoteException, VisADException {
            this.set(coordinateSystem, coordinateSystem.getMinimumX(), this.contourLevels, coordinateSystem.getMinimumTemperature(), -0.23);
        }

        protected LeftPressureAxisLabels(LeftPressureAxisLabels that) throws RemoteException, VisADException {
            super(that);
            this.contourLevels = that.contourLevels;
        }

        @Override
        public Displayable cloneForDisplay() throws RemoteException, VisADException {
            return new LeftPressureAxisLabels(this);
        }
    }

    protected static abstract class PressureAxisLabels
    extends ScaleLabels {
        protected PressureAxisLabels(String name) throws RemoteException, VisADException {
            super(name, RealType.YAxis);
            DecimalFormat format = new DecimalFormat("###0");
            this.setFormat(format);
            this.setXAlignment(1.0f);
        }

        protected PressureAxisLabels(PressureAxisLabels that) throws RemoteException, VisADException {
            super(that);
        }

        protected void set(AerologicalCoordinateSystem coordinateSystem, Real xValue, ContourLevels contourLevels, Real temperature, double separation) throws RemoteException, VisADException {
            double x = xValue.getValue();
            float[] pressureValues = contourLevels.getLevels((float)coordinateSystem.fromReference(new double[][]{{x}, {coordinateSystem.getMaximumY().getValue()}})[0][0], (float)coordinateSystem.fromReference(new double[][]{{x}, {coordinateSystem.getMinimumY().getValue()}})[0][0]);
            float[] temperatureValues = new float[pressureValues.length];
            Arrays.fill(temperatureValues, (float)temperature.getValue());
            this.setPositionValues(coordinateSystem.toReference(new float[][]{pressureValues, temperatureValues})[1]);
            this.setLabelValues(pressureValues);
            this.addConstantMap(new ConstantMap(x + separation, Display.XAxis));
        }

        public void setCoordinateSystem(AerologicalCoordinateSystem acs) throws VisADException, RemoteException {
            this.coordinateSystemChange(acs);
        }

        protected void coordinateSystemChange(AerologicalCoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        }
    }
}

