/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.AirDensityProfileCell;
import ucar.unidata.view.sounding.AirTemperatureCell;
import ucar.unidata.view.sounding.BuoyancyProfileCell;
import ucar.unidata.view.sounding.CapeCell;
import ucar.unidata.view.sounding.CellNetwork;
import ucar.unidata.view.sounding.CinCell;
import ucar.unidata.view.sounding.DewPointExtractorCell;
import ucar.unidata.view.sounding.DomainEvaluatorCell;
import ucar.unidata.view.sounding.DomainExtractorCell;
import ucar.unidata.view.sounding.DryTrajectoryCell;
import ucar.unidata.view.sounding.EnergyProfileCell;
import ucar.unidata.view.sounding.LayerMeanCell;
import ucar.unidata.view.sounding.LclPressureCell;
import ucar.unidata.view.sounding.LclTemperatureCell;
import ucar.unidata.view.sounding.LfcCell;
import ucar.unidata.view.sounding.LnbCell;
import ucar.unidata.view.sounding.MaxPressureCell;
import ucar.unidata.view.sounding.MixingRatioCell;
import ucar.unidata.view.sounding.MixingRatioProfileCell;
import ucar.unidata.view.sounding.ParcelMode;
import ucar.unidata.view.sounding.PotentialTemperatureProfileCell;
import ucar.unidata.view.sounding.ProfileCleanerCell;
import ucar.unidata.view.sounding.ProfileCombinerCell;
import ucar.unidata.view.sounding.RealEvaluatorCell;
import ucar.unidata.view.sounding.SelectorCell;
import ucar.unidata.view.sounding.VirtualTemperatureProfileCell;
import ucar.unidata.view.sounding.WetTrajectoryCell;
import ucar.visad.functiontypes.AtmosphericProfile;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.MassicVolume;
import ucar.visad.quantities.PolarHorizontalWind;
import ucar.visad.quantities.VirtualTemperature;
import ucar.visad.quantities.WaterVaporMixingRatio;
import visad.CommonUnit;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Field;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.Set;
import visad.VisADException;

public final class AerologicalCellNetwork {
    private final DewPointExtractorCell dewExtractorCell;
    private final RealEvaluatorCell proTempAtPresCell;
    private final RealEvaluatorCell proWindAtPresCell;
    private final MixingRatioCell proMixingRatioCell;
    private final LclTemperatureCell lclTempCell;
    private final LclPressureCell lclPresCell;
    private final DryTrajectoryCell dryTrajectoryCell;
    private final WetTrajectoryCell wetTrajectoryCell;
    private final VirtualTemperatureProfileCell dryVirtTempProCell;
    private final VirtualTemperatureProfileCell wetVirtTempProCell;
    private final ProfileCombinerCell parVirtTempProCell;
    private final VirtualTemperatureProfileCell envVirtTempProCell;
    private final AirDensityProfileCell parDenProCell;
    private final AirDensityProfileCell envDenProCell;
    private final BuoyancyProfileCell buoyProfileCell;
    private final ProfileCleanerCell cleanBuoyCell;
    private final CapeCell capeCell;
    private final LfcCell lfcCell;
    private final RealEvaluatorCell lfcTempCell;
    private final LnbCell lnbCell;
    private final RealEvaluatorCell lnbTempCell;
    private final CinCell cinCell;
    private final DataReference parIndexRef;
    private static Real zero;
    private static Real one;
    private static Real two;
    private static Real three;

    public AerologicalCellNetwork(DataReference tempProfileRef, DataReference dewProfileRef, DataReference presRef, DataReference tempRef, DataReference minPresRef) throws VisADException, RemoteException {
        this(tempProfileRef, dewProfileRef, presRef, tempRef, minPresRef, new DataReferenceImpl("WindProfile"));
    }

    public AerologicalCellNetwork(DataReference tempProfileRef, DataReference dewProfileRef, DataReference presRef, DataReference tempRef, DataReference minPresRef, DataReference windProfileRef) throws VisADException, RemoteException {
        CellNetwork net = new CellNetwork();
        Real noPres = (Real)AirPressure.getRealType().missingData();
        Real noTemp = (Real)AirTemperature.getRealType().missingData();
        RealTuple noWind = (RealTuple)PolarHorizontalWind.getRealTupleType().missingData();
        Real noRatio = (Real)WaterVaporMixingRatio.getRealType().missingData();
        Field noRatioPro = (Field)new AtmosphericProfile(noRatio.getType()).missingData();
        Field noTempPro = (Field)new AtmosphericProfile(noTemp.getType()).missingData();
        MaxPressureCell maxProPresCell = new MaxPressureCell(tempProfileRef, noPres);
        Set noPresDomain = noTempPro.getDomainSet();
        net.add(maxProPresCell);
        PotentialTemperatureProfileCell potTempProCell = new PotentialTemperatureProfileCell(tempProfileRef, noTempPro);
        net.add(potTempProCell);
        LayerMeanCell meanPotTempCell = new LayerMeanCell(potTempProCell.getOutputRef(), maxProPresCell.getOutputRef(), presRef, noTemp);
        net.add(meanPotTempCell);
        AirTemperatureCell meanTempCell = new AirTemperatureCell(meanPotTempCell.getMeanPresRef(), meanPotTempCell.getOutputRef(), (Data)noTemp);
        net.add(meanTempCell);
        MixingRatioProfileCell mixingRatioProCell = new MixingRatioProfileCell(dewProfileRef, noRatioPro);
        net.add(mixingRatioProCell);
        LayerMeanCell meanMixingRatioCell = new LayerMeanCell(mixingRatioProCell.getOutputRef(), maxProPresCell.getOutputRef(), presRef, noRatio);
        net.add(meanMixingRatioCell);
        this.parIndexRef = new DataReferenceImpl("ParcelIndexRef");
        this.setParcelMode(ParcelMode.BOTTOM);
        this.dewExtractorCell = new DewPointExtractorCell(dewProfileRef, presRef);
        net.add(this.dewExtractorCell);
        this.proMixingRatioCell = new MixingRatioCell(this.dewExtractorCell.getOutputRef(), presRef);
        net.add(this.proMixingRatioCell);
        SelectorCell parPresCell = new SelectorCell(this.parIndexRef, new DataReference[]{presRef, meanPotTempCell.getMeanPresRef(), maxProPresCell.getOutputRef(), presRef}, (Data)noPres);
        net.add(parPresCell);
        this.proTempAtPresCell = new RealEvaluatorCell(tempProfileRef, presRef, (Data)noTemp);
        net.add(this.proTempAtPresCell);
        this.proWindAtPresCell = new RealEvaluatorCell(windProfileRef, presRef, (Data)noWind);
        net.add(this.proWindAtPresCell);
        RealEvaluatorCell proTempAtMaxPresCell = new RealEvaluatorCell(tempProfileRef, maxProPresCell.getOutputRef(), (Data)noTemp);
        net.add(proTempAtMaxPresCell);
        SelectorCell parTempCell = new SelectorCell(this.parIndexRef, new DataReference[]{tempRef, meanTempCell.getOutputRef(), proTempAtMaxPresCell.getOutputRef(), this.proTempAtPresCell.getOutputRef()}, (Data)noTemp);
        net.add(parTempCell);
        RealEvaluatorCell proMixingRatioAtMaxPresCell = new RealEvaluatorCell(mixingRatioProCell.getOutputRef(), maxProPresCell.getOutputRef(), (Data)noRatio);
        net.add(proMixingRatioAtMaxPresCell);
        SelectorCell parMixingRatioCell = new SelectorCell(this.parIndexRef, new DataReference[]{this.proMixingRatioCell.getOutputRef(), meanMixingRatioCell.getOutputRef(), proMixingRatioAtMaxPresCell.getOutputRef(), this.proMixingRatioCell.getOutputRef()}, (Data)noRatio);
        net.add(parMixingRatioCell);
        this.lclTempCell = new LclTemperatureCell(parMixingRatioCell.getOutputRef(), parPresCell.getOutputRef(), parTempCell.getOutputRef());
        net.add(this.lclTempCell);
        this.lclPresCell = new LclPressureCell(parPresCell.getOutputRef(), parTempCell.getOutputRef(), this.lclTempCell.getOutputRef());
        net.add(this.lclPresCell);
        this.dryTrajectoryCell = new DryTrajectoryCell(parPresCell.getOutputRef(), parTempCell.getOutputRef(), this.lclPresCell.getOutputRef());
        net.add(this.dryTrajectoryCell);
        this.wetTrajectoryCell = new WetTrajectoryCell(this.lclTempCell.getOutputRef(), this.lclPresCell.getOutputRef(), minPresRef);
        net.add(this.wetTrajectoryCell);
        this.dryVirtTempProCell = new VirtualTemperatureProfileCell(this.dryTrajectoryCell.getOutputRef(), parMixingRatioCell.getOutputRef());
        net.add(this.dryVirtTempProCell);
        this.wetVirtTempProCell = new VirtualTemperatureProfileCell(this.wetTrajectoryCell.getOutputRef(), this.wetTrajectoryCell.getOutputRef());
        net.add(this.wetVirtTempProCell);
        this.parVirtTempProCell = new ProfileCombinerCell(this.dryVirtTempProCell.getOutputRef(), this.wetVirtTempProCell.getOutputRef(), VirtualTemperature.getRealType());
        net.add(this.parVirtTempProCell);
        this.parDenProCell = new AirDensityProfileCell(this.parVirtTempProCell.getOutputRef());
        net.add(this.parDenProCell);
        this.envVirtTempProCell = new VirtualTemperatureProfileCell(tempProfileRef, dewProfileRef);
        net.add(this.envVirtTempProCell);
        DomainExtractorCell parDomainCell = new DomainExtractorCell(this.parVirtTempProCell.getOutputRef(), noPresDomain);
        net.add(parDomainCell);
        DomainEvaluatorCell envVirtTempProParDomainCell = new DomainEvaluatorCell(this.envVirtTempProCell.getOutputRef(), parDomainCell.getOutputRef(), (Data)noTempPro);
        net.add(envVirtTempProParDomainCell);
        this.envDenProCell = new AirDensityProfileCell(envVirtTempProParDomainCell.getOutputRef());
        net.add(this.envDenProCell);
        this.buoyProfileCell = new BuoyancyProfileCell(this.envDenProCell.getOutputRef(), this.parDenProCell.getOutputRef());
        net.add(this.buoyProfileCell);
        this.cleanBuoyCell = new ProfileCleanerCell(this.buoyProfileCell.getOutputRef(), MassicVolume.getRealType());
        net.add(this.cleanBuoyCell);
        this.lfcCell = new LfcCell(this.cleanBuoyCell.getOutputRef());
        net.add(this.lfcCell);
        this.lfcTempCell = new RealEvaluatorCell(tempProfileRef, this.lfcCell.getOutputRef(), (Data)noTemp);
        net.add(this.lfcTempCell);
        this.lnbCell = new LnbCell(this.cleanBuoyCell.getOutputRef());
        net.add(this.lnbCell);
        this.lnbTempCell = new RealEvaluatorCell(tempProfileRef, this.lnbCell.getOutputRef(), (Data)noTemp);
        net.add(this.lnbTempCell);
        EnergyProfileCell energyProCell = new EnergyProfileCell(this.cleanBuoyCell.getOutputRef());
        net.add(energyProCell);
        this.capeCell = new CapeCell(energyProCell.getOutputRef(), this.lfcCell.getOutputRef(), this.lnbCell.getOutputRef());
        net.add(this.capeCell);
        this.cinCell = new CinCell(energyProCell.getOutputRef(), parPresCell.getOutputRef(), this.lfcCell.getOutputRef());
        net.add(this.cinCell);
        net.configure();
    }

    public void setParcelMode(ParcelMode mode) throws VisADException, RemoteException {
        if (mode == ParcelMode.POINT) {
            this.parIndexRef.setData(zero);
        } else if (mode == ParcelMode.LAYER) {
            this.parIndexRef.setData(one);
        } else if (mode == ParcelMode.BOTTOM) {
            this.parIndexRef.setData(two);
        } else if (mode == ParcelMode.PRESSURE) {
            this.parIndexRef.setData(three);
        } else {
            throw new Error("Assertion failure");
        }
    }

    public DataReference getProfileTemperatureRef() {
        return this.proTempAtPresCell.getOutputRef();
    }

    public DataReference getProfileDewPointRef() {
        return this.dewExtractorCell.getOutputRef();
    }

    public DataReference getProfileMixingRatioRef() {
        return this.proMixingRatioCell.getOutputRef();
    }

    public DataReference getProfileWindRef() {
        return this.proWindAtPresCell.getOutputRef();
    }

    public DataReference getLclTemperatureRef() {
        return this.lclTempCell.getOutputRef();
    }

    public DataReference getLclPressureRef() {
        return this.lclPresCell.getOutputRef();
    }

    public DataReference getDryTrajectoryRef() {
        return this.dryTrajectoryCell.getOutputRef();
    }

    public DataReference getWetTrajectoryRef() {
        return this.wetTrajectoryCell.getOutputRef();
    }

    public DataReference getDryVirtualTemperatureProfileRef() {
        return this.dryVirtTempProCell.getOutputRef();
    }

    public DataReference getWetVirtualTemperatureProfileRef() {
        return this.wetVirtTempProCell.getOutputRef();
    }

    public DataReference getParcelVirtualTemperatureProfileRef() {
        return this.parVirtTempProCell.getOutputRef();
    }

    public DataReference getEnvironmentVirtualTemperatureProfileRef() {
        return this.envVirtTempProCell.getOutputRef();
    }

    public DataReference getBuoyancyProfileRef() {
        return this.buoyProfileCell.getOutputRef();
    }

    public DataReference getCapeRef() {
        return this.capeCell.getOutputRef();
    }

    public DataReference getLfcRef() {
        return this.lfcCell.getOutputRef();
    }

    public DataReference getLfcTemperatureRef() {
        return this.lfcTempCell.getOutputRef();
    }

    public DataReference getLnbRef() {
        return this.lnbCell.getOutputRef();
    }

    public DataReference getLnbTemperatureRef() {
        return this.lnbTempCell.getOutputRef();
    }

    public DataReference getCinRef() {
        return this.cinCell.getOutputRef();
    }

    static {
        try {
            zero = new Real(RealType.getRealType("dimensionless_constant", CommonUnit.dimensionless), 0.0);
            one = new Real(RealType.getRealType("dimensionless_constant", CommonUnit.dimensionless), 1.0);
            two = new Real(RealType.getRealType("dimensionless_constant", CommonUnit.dimensionless), 2.0);
            three = new Real(RealType.getRealType("dimensionless_constant", CommonUnit.dimensionless), 3.0);
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

