/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.ViewpointControl;
import ucar.unidata.view.geoloc.ViewpointInfo;

public class ViewpointDialog
extends JDialog
implements ActionListener {
    private JTextField azimuthFld;
    private JTextField tiltFld;
    private boolean ok;
    private JButton okButton;
    private JButton cancelButton;
    private ViewpointControl viewpointControl;

    public ViewpointDialog(ViewpointControl vc, JFrame parent) {
        super(parent, new String("Viewpoint Settings"), false);
        this.viewpointControl = vc;
        GuiUtils.tmpInsets = new Insets(5, 5, 0, 0);
        Component[] componentArray = new Component[4];
        componentArray[0] = GuiUtils.rLabel("Azimuth from North: ");
        this.azimuthFld = new JTextField("", 7);
        componentArray[1] = this.azimuthFld;
        componentArray[2] = GuiUtils.rLabel("Tilt down from top: ");
        this.tiltFld = new JTextField("", 7);
        componentArray[3] = this.tiltFld;
        JPanel panel = GuiUtils.doLayout(componentArray, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        this.azimuthFld.setActionCommand(GuiUtils.CMD_OK);
        this.azimuthFld.addActionListener(this);
        this.tiltFld.setActionCommand(GuiUtils.CMD_OK);
        this.tiltFld.addActionListener(this);
        this.getContentPane().add("Center", GuiUtils.inset((Component)panel, 5));
        this.getContentPane().add("South", GuiUtils.makeApplyOkCancelButtons(this));
        this.pack();
        this.setLocation(100, 100);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
            try {
                double azmo = Misc.parseNumber(this.azimuthFld.getText());
                double tilt = Misc.parseNumber(this.tiltFld.getText());
                this.viewpointControl.setViewpointInfo(new ViewpointInfo(azmo, tilt));
            }
            catch (NumberFormatException nfe) {
                LogUtil.userErrorMessage("Invalid azimuth or tilt value");
                return;
            }
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL) || cmd.equals(GuiUtils.CMD_OK)) {
            this.setVisible(false);
        }
    }

    public void showDialog(ViewpointInfo transfer) {
        this.azimuthFld.setText(Misc.format(transfer.azimuth));
        this.tiltFld.setText(Misc.format(transfer.tilt));
        this.setVisible(true);
    }
}

