/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.GlobeDisplay;
import ucar.unidata.view.geoloc.GlobeScaleDialog;
import ucar.unidata.view.geoloc.MapProjectionDisplay;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.view.geoloc.VertScaleDialog;
import ucar.unidata.view.geoloc.VertScaleInfo;
import ucar.unidata.view.geoloc.ViewpointDialog;
import ucar.unidata.view.geoloc.ViewpointInfo;
import visad.Unit;

public class ViewpointControl
implements ActionListener {
    private static final String CMD_ROTATEDIALOG = "cmd.rotatedialog";
    private static final String CMD_SETBOTTOM = "cmd.setbottomview";
    private static final String CMD_SETEAST = "cmd.seteastview";
    private static final String CMD_SETEYEPOSITION = "cmd.seteyeposition";
    private static final String CMD_SETNORTH = "cmd.setnorthview";
    private static final String CMD_SETSOUTH = "cmd.setsouthview";
    private static final String CMD_SETTOP = "cmd.settopview";
    private static final String CMD_SETVERTICALSCALE = "cmd.setverticalscale";
    private static final String CMD_SETVERTICALRANGE = "cmd.setverticalrange";
    private static final String CMD_SETWEST = "cmd.setwestview";
    private static final String ICON_BOTTOM = "/auxdata/ui/icons/Bottom16.gif";
    private static final String ICON_EAST = "/auxdata/ui/icons/East16.gif";
    private static final String ICON_NORTH = "/auxdata/ui/icons/North16.gif";
    private static final String ICON_PARALLEL = "/auxdata/ui/icons/parallel_view.gif";
    private static final String ICON_PERSPECTIVE = "/auxdata/ui/icons/perspective_view.gif";
    private static final String ICON_SETVERTICALSCALE = "/auxdata/ui/icons/Vert16.gif";
    private static final String ICON_SETVERTICALRANGE = "/auxdata/ui/icons/Vert16.gif";
    private static final String ICON_SOUTH = "/auxdata/ui/icons/South16.gif";
    private static final String ICON_TOP = "/auxdata/ui/icons/Top16.gif";
    private static final String ICON_USERVIEW = "/auxdata/ui/icons/UserView16.gif";
    private static final String ICON_WEST = "/auxdata/ui/icons/West16.gif";
    private static final String ROTATE_CLOCKWISE = "rotate.clockwise";
    private static final String ROTATE_COUNTERCLOCKWISE = "rotate.counterclockwise";
    private static final String ROTATE_DOWN = "rotate.down";
    private static final String ROTATE_LEFT = "rotate.left";
    private static final String ROTATE_RIGHT = "rotate.right";
    private static final String ROTATE_UP = "rotate.up";
    private static final String[] perspectiveCmds = new String[]{"cmd.settopview", "cmd.setbottomview", "cmd.setnorthview", "cmd.seteastview", "cmd.setsouthview", "cmd.setwestview"};
    private static final String[] perspectiveIcons = new String[]{"/auxdata/ui/icons/Top16.gif", "/auxdata/ui/icons/Bottom16.gif", "/auxdata/ui/icons/North16.gif", "/auxdata/ui/icons/East16.gif", "/auxdata/ui/icons/South16.gif", "/auxdata/ui/icons/West16.gif"};
    private double eyePosition = 0.004;
    private double vpAz = 180.0;
    private double vpTilt = 45.0;
    private boolean okToAcceptChangesFromPerspectiveWidgets = true;
    private boolean okToAcceptChangesFromAutoRotateWidgets = true;
    private boolean autoRotate;
    private JMenuItem eyePositionMenu;
    private boolean isPerspective;
    private JMenu menu;
    private NavigatedDisplay navDisplay;
    private JToggleButton pButton;
    private JCheckBoxMenuItem pMenu;
    private String[] perspectiveNames;
    private JToggleButton rotateButton;
    private JCheckBoxMenuItem rotateMenu;
    private JToolBar toolbar;
    ViewpointDialog viewpointDialog;
    private VertScaleDialog vsDialog;
    private VertScaleInfo vsi;

    public ViewpointControl(NavigatedDisplay navDisplay) {
        if (navDisplay == null) {
            throw new NullPointerException("ViewPointControl.ctor: NavigatedDisplay cannot be null");
        }
        this.navDisplay = navDisplay;
        this.isPerspective = navDisplay.isPerspectiveView();
        this.perspectiveNames = new String[]{navDisplay.getTopViewName(), navDisplay.getBottomViewName(), navDisplay.getNorthViewName(), navDisplay.getEastViewName(), navDisplay.getSouthViewName(), navDisplay.getWestViewName()};
    }

    public JToolBar getToolBar() {
        return this.getToolBar(false);
    }

    public JToolBar getToolBar(int orientation) {
        return this.getToolBar(false, orientation);
    }

    public JToolBar getToolBar(boolean floatable) {
        return this.getToolBar(floatable, 1);
    }

    public JToolBar getToolBar(boolean floatable, int orientation) {
        if (this.toolbar == null) {
            this.toolbar = this.makeToolBar(floatable);
        }
        this.toolbar.setFloatable(floatable);
        this.toolbar.setOrientation(orientation);
        return this.toolbar;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(CMD_SETTOP)) {
            this.setTopView();
        } else if (cmd.equals(CMD_SETBOTTOM)) {
            this.setBottomView();
        } else if (cmd.equals(CMD_SETNORTH)) {
            this.setNorthView();
        } else if (cmd.equals(CMD_SETEAST)) {
            this.setEastView();
        } else if (cmd.equals(CMD_SETSOUTH)) {
            this.setSouthView();
        } else if (cmd.equals(CMD_SETWEST)) {
            this.setWestView();
        } else if (cmd.equals(CMD_ROTATEDIALOG)) {
            this.rotateViewpoint(new ViewpointInfo(this.vpAz, this.vpTilt));
        } else if (cmd.equals(CMD_SETVERTICALRANGE) || cmd.equals(CMD_SETVERTICALSCALE)) {
            this.changeVerticalRange(this.getVsi());
        } else if (cmd.equals(CMD_SETEYEPOSITION)) {
            this.changeEyePosition();
        }
    }

    protected JToolBar makeToolBar() {
        return this.makeToolBar(false);
    }

    protected JToolBar makeToolBar(boolean floatable) {
        JToolBar toolbar = new JToolBar("Viewpoint Toolbar");
        toolbar.setFloatable(floatable);
        for (int i = 0; i < perspectiveCmds.length; ++i) {
            toolbar.add(this.makeButton(perspectiveIcons[i], perspectiveCmds[i], "Rotate to " + this.perspectiveNames[i].toLowerCase() + " viewpoint"));
        }
        this.pButton = GuiUtils.getToggleImageButton(GuiUtils.getScaledImageIcon(ICON_PERSPECTIVE, null, true), GuiUtils.getScaledImageIcon(ICON_PARALLEL, null, true), 2, 2);
        this.pButton.setSelected(this.isPerspective);
        this.pButton.setToolTipText("Set parallel/perspective projection");
        this.pButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ViewpointControl.this.okToAcceptChangesFromPerspectiveWidgets) {
                    return;
                }
                boolean value = ((JToggleButton)e.getSource()).isSelected();
                ViewpointControl.this.changePerspectiveView(value);
            }
        });
        toolbar.add(this.pButton);
        toolbar.add(this.makeButton(ICON_USERVIEW, CMD_ROTATEDIALOG, "Rotate to user specified view"));
        JButton vertRangeButton = this.makeButton("/auxdata/ui/icons/Vert16.gif", CMD_SETVERTICALRANGE, "<html>Set the vertical range<br>Right mouse:<br>&nbsp;&nbsp;Click: increase upper 10%<br>&nbsp;&nbsp;Control-Click: decrease upper 10%<br>&nbsp;&nbsp;Shift-Click: decrease lower 10%<br>&nbsp;&nbsp;Shift-Control-Click: increase lower 10%</html>");
        vertRangeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (!SwingUtilities.isRightMouseButton(me)) {
                    return;
                }
                try {
                    double[] range = ViewpointControl.this.navDisplay.getVerticalRange();
                    double diff = range[1] - range[0];
                    diff = (range[1] - range[0]) * (me.isControlDown() ? -0.1 : 0.1);
                    if (me.isShiftDown()) {
                        ViewpointControl.this.navDisplay.setVerticalRange(range[0] - diff, range[1]);
                    } else {
                        ViewpointControl.this.navDisplay.setVerticalRange(range[0], range[1] + diff);
                    }
                    range = ViewpointControl.this.navDisplay.getVerticalRange();
                    LogUtil.message("Setting vertical range to: " + Misc.format(range[0]) + " - " + Misc.format(range[1]) + " " + ViewpointControl.this.navDisplay.getVerticalRangeUnit());
                }
                catch (Exception exp) {
                    LogUtil.logException("Setting vertical range", exp);
                }
            }
        });
        toolbar.add(vertRangeButton);
        this.rotateButton = GuiUtils.getToggleImageButton(GuiUtils.getScaledImageIcon("/auxdata/ui/icons/arrow_rotate_clockwise.png", null, true), GuiUtils.getScaledImageIcon("/auxdata/ui/icons/arrow_rotate_clockwise.png", null, true), 2, 2);
        this.rotateButton.setToolTipText("Auto-rotate;Right click to show menu");
        this.rotateButton.setSelected(this.getAutoRotate());
        this.rotateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewpointControl.this.changeAutoRotate(ViewpointControl.this.rotateButton.isSelected());
            }
        });
        this.rotateButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (!SwingUtilities.isRightMouseButton(me)) {
                    return;
                }
                ArrayList<Object> items = new ArrayList<Object>();
                items.add(GuiUtils.makeMenuItem("Rotate Right", ViewpointControl.this, "setRotate", ViewpointControl.ROTATE_RIGHT));
                items.add(GuiUtils.makeMenuItem("Rotate Left", ViewpointControl.this, "setRotate", ViewpointControl.ROTATE_LEFT));
                items.add(GuiUtils.makeMenuItem("Rotate Up", ViewpointControl.this, "setRotate", ViewpointControl.ROTATE_UP));
                items.add(GuiUtils.makeMenuItem("Rotate Down", ViewpointControl.this, "setRotate", ViewpointControl.ROTATE_DOWN));
                items.add(GuiUtils.makeMenuItem("Rotate Clockwise", ViewpointControl.this, "setRotate", ViewpointControl.ROTATE_CLOCKWISE));
                items.add(GuiUtils.makeMenuItem("Rotate CounterClockwise", ViewpointControl.this, "setRotate", ViewpointControl.ROTATE_COUNTERCLOCKWISE));
                items.add("separator");
                items.add(GuiUtils.makeMenuItem("Rotate Faster", ViewpointControl.this.navDisplay, "rotateFaster"));
                items.add(GuiUtils.makeMenuItem("Rotate Slower", ViewpointControl.this.navDisplay, "rotateSlower"));
                GuiUtils.showPopupMenu(items, ViewpointControl.this.rotateButton);
            }
        });
        toolbar.add(this.rotateButton);
        return toolbar;
    }

    public void setRotate(String dir) {
        if (dir.equals(ROTATE_RIGHT)) {
            this.navDisplay.setRotationMultiplierMatrix(0.0, -1.0, 0.0);
        } else if (dir.equals(ROTATE_LEFT)) {
            this.navDisplay.setRotationMultiplierMatrix(0.0, 1.0, 0.0);
        } else if (dir.equals(ROTATE_UP)) {
            this.navDisplay.setRotationMultiplierMatrix(1.0, 0.0, 0.0);
        } else if (dir.equals(ROTATE_DOWN)) {
            this.navDisplay.setRotationMultiplierMatrix(-1.0, 0.0, 0.0);
        } else if (dir.equals(ROTATE_CLOCKWISE)) {
            this.navDisplay.setRotationMultiplierMatrix(0.0, 0.0, 1.0);
        } else if (dir.equals(ROTATE_COUNTERCLOCKWISE)) {
            this.navDisplay.setRotationMultiplierMatrix(0.0, 0.0, -1.0);
        }
        this.setAutoRotate(true);
    }

    private JButton makeButton(String icon, String cmd, String tooltip) {
        JButton button = GuiUtils.getScaledImageButton(icon, this.getClass(), 2, 2);
        button.setToolTipText(tooltip);
        button.setActionCommand(cmd);
        button.addActionListener(this);
        return button;
    }

    public JMenu getMenu() {
        return this.menu != null ? this.menu : this.makeMenu();
    }

    protected JMenu makeMenu() {
        JMenuItem mi;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenu viewMenu = new JMenu("Viewpoint");
        viewMenu.setToolTipText(" Get Viewpoint control widget");
        for (int i = 0; i < perspectiveCmds.length; ++i) {
            mi = new JMenuItem(this.perspectiveNames[i]);
            mi.setMnemonic(this.perspectiveNames[i].charAt(0));
            mi.setIcon(GuiUtils.getScaledImageIcon(perspectiveIcons[i], null, true));
            mi.setActionCommand(perspectiveCmds[i]);
            mi.addActionListener(this);
            viewMenu.add(mi);
        }
        this.pMenu = new JCheckBoxMenuItem("Perspective View", this.isPerspective);
        viewMenu.add(this.pMenu);
        this.pMenu.setMnemonic('P');
        this.pMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ViewpointControl.this.okToAcceptChangesFromPerspectiveWidgets) {
                    return;
                }
                ViewpointControl.this.changePerspectiveView(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        mi = new JMenuItem("Viewpoint Dialog...");
        viewMenu.add(mi);
        mi.setMnemonic('D');
        mi.setIcon(GuiUtils.getScaledImageIcon(ICON_USERVIEW, null, true));
        mi.setActionCommand(CMD_ROTATEDIALOG);
        mi.addActionListener(this);
        this.makeVerticalRangeMenuItem(viewMenu);
        this.rotateMenu = new JCheckBoxMenuItem("Auto-Rotate View", this.autoRotate);
        viewMenu.add(this.rotateMenu);
        this.rotateMenu.setMnemonic('R');
        this.rotateMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ViewpointControl.this.okToAcceptChangesFromPerspectiveWidgets) {
                    return;
                }
                ViewpointControl.this.changeAutoRotate(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        if (this.navDisplay.getStereoAvailable()) {
            this.eyePositionMenu = new JMenuItem("Stereo Controls...");
            viewMenu.add(this.eyePositionMenu);
            this.eyePositionMenu.setActionCommand(CMD_SETEYEPOSITION);
            this.eyePositionMenu.addActionListener(this);
        }
        return viewMenu;
    }

    public void makeVerticalScaleMenuItem(JMenu viewMenu) {
        this.makeVerticalRangeMenuItem(viewMenu);
    }

    public void makeVerticalRangeMenuItem(JMenu viewMenu) {
        JMenuItem mi = new JMenuItem("Vertical Scale...");
        viewMenu.add(mi);
        mi.setMnemonic('V');
        mi.setIcon(GuiUtils.getScaledImageIcon("/auxdata/ui/icons/Vert16.gif", null, true));
        mi.setActionCommand(CMD_SETVERTICALRANGE);
        mi.addActionListener(this);
    }

    public void setTopView() {
        try {
            this.navDisplay.setView(3);
        }
        catch (Exception exp) {
            System.out.println("  set viewpoint to top view got " + exp);
        }
    }

    public void setBottomView() {
        try {
            this.navDisplay.setView(0);
        }
        catch (Exception exp) {
            System.out.println("  set viewpoint to bottom view got " + exp);
        }
    }

    public void setNorthView() {
        try {
            this.navDisplay.setView(1);
        }
        catch (Exception exp) {
            System.out.println("  set viewpoint to north view got " + exp);
        }
    }

    public void setSouthView() {
        try {
            this.navDisplay.setView(4);
        }
        catch (Exception exp) {
            System.out.println("  set viewpoint to south view got " + exp);
        }
    }

    public void setEastView() {
        try {
            this.navDisplay.setView(2);
        }
        catch (Exception exp) {
            System.out.println("  set viewpoint to east view got " + exp);
        }
    }

    public void setWestView() {
        try {
            this.navDisplay.setView(5);
        }
        catch (Exception exp) {
            System.out.println("  set viewpoint to west view got " + exp);
        }
    }

    public void setEyePosition(double position) {
        this.eyePosition = position;
    }

    public double getEyePosition() {
        return this.eyePosition;
    }

    public void changeEyePosition() {
        final JLabel label = new JLabel(Misc.format(this.eyePosition));
        final JSlider slider = new JSlider(0, 1000, (int)(this.eyePosition * 1000.0));
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double value = (double)slider.getValue() / 1000.0;
                label.setText(Misc.format(value));
                if (!slider.getValueIsAdjusting()) {
                    try {
                        ViewpointControl.this.navDisplay.setEyePosition(value);
                    }
                    catch (Exception exp) {
                        System.out.println("  set the eye position got " + exp);
                    }
                    ViewpointControl.this.eyePosition = value;
                }
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add("Center", slider);
        p.add("East", label);
        GuiUtils.showOkCancelDialog(null, "Set Eye Position", p, this.eyePositionMenu);
    }

    public boolean getPerspectiveView() {
        return this.isPerspective;
    }

    public void changePerspectiveView(boolean v) {
        this.setPerspectiveView(v);
    }

    public void setPerspectiveView(boolean perspective) {
        if (perspective == this.isPerspective) {
            return;
        }
        try {
            this.isPerspective = perspective;
            this.okToAcceptChangesFromPerspectiveWidgets = false;
            this.navDisplay.setPerspectiveView(perspective);
            if (this.pMenu != null && perspective != this.pMenu.isSelected()) {
                this.pMenu.setSelected(perspective);
            }
            if (this.pButton != null && perspective != this.pButton.isSelected()) {
                this.pButton.setSelected(perspective);
            }
            this.okToAcceptChangesFromPerspectiveWidgets = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            System.out.println("  set perspective to " + perspective + " got " + exp);
        }
    }

    public boolean getAutoRotate() {
        return this.autoRotate;
    }

    public void changeAutoRotate(boolean v) {
        this.setAutoRotate(v);
    }

    public void setAutoRotate(boolean rotate) {
        if (rotate == this.autoRotate) {
            return;
        }
        try {
            this.autoRotate = rotate;
            this.okToAcceptChangesFromAutoRotateWidgets = false;
            this.navDisplay.setAutoRotate(this.autoRotate);
            if (this.rotateMenu != null && this.autoRotate != this.rotateMenu.isSelected()) {
                this.rotateMenu.setSelected(this.autoRotate);
            }
            if (this.rotateButton != null && rotate != this.rotateButton.isSelected()) {
                this.rotateButton.setSelected(rotate);
            }
            this.okToAcceptChangesFromAutoRotateWidgets = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            System.out.println("  set autorotate to " + rotate + " got " + exp);
        }
    }

    public ViewpointInfo rotateViewpoint(ViewpointInfo transfer) {
        if (this.viewpointDialog == null) {
            this.viewpointDialog = new ViewpointDialog(this, GuiUtils.getFrame(this.navDisplay.getComponent()));
        }
        this.viewpointDialog.showDialog(transfer);
        return transfer;
    }

    public ViewpointInfo getViewpointInfo() {
        return new ViewpointInfo(this.vpAz, this.vpTilt);
    }

    public void setViewpointInfo(ViewpointInfo vpi) {
        this.vpAz = vpi.azimuth;
        this.vpTilt = vpi.tilt;
        try {
            if (this.navDisplay != null) {
                this.navDisplay.rotateView(this.navDisplay.getSavedProjectionMatrix(), vpi.azimuth, vpi.tilt);
            }
        }
        catch (Exception exp) {
            System.out.println("   rotateViewpoint got " + exp);
        }
    }

    protected VertScaleInfo getVsi() {
        if (this.vsi == null) {
            double[] range = this.navDisplay.getVerticalRange();
            Unit u = this.navDisplay.getVerticalRangeUnit();
            this.vsi = new VertScaleInfo(range[0], range[1], u);
        }
        return this.vsi;
    }

    public VertScaleDialog makeVerticalScaleWidget(boolean visible) {
        return this.makeVerticalRangeWidget(visible);
    }

    public VertScaleDialog makeVerticalRangeWidget(boolean visible) {
        VertScaleInfo tmpVsi = this.getVsi();
        tmpVsi.visible = visible;
        return new VertScaleDialog(GuiUtils.getFrame(this.navDisplay.getComponent()), this, tmpVsi);
    }

    public void changeVerticalScale(VertScaleInfo transfer) {
        this.changeVerticalRange(transfer);
    }

    public void changeVerticalRange(VertScaleInfo transfer) {
        this.vsi = transfer;
        if (this.vsDialog == null) {
            this.vsDialog = this.navDisplay instanceof GlobeDisplay ? new GlobeScaleDialog(GuiUtils.getFrame(this.navDisplay.getComponent()), this, this.vsi) : new VertScaleDialog(GuiUtils.getFrame(this.navDisplay.getComponent()), this, this.vsi);
        }
        this.vsDialog.showDialog(transfer);
    }

    protected void applyVerticalScale(VertScaleInfo transfer) throws Exception {
        this.vsi = transfer;
        this.applyVerticalRange(transfer);
    }

    protected void applyVerticalRange(VertScaleInfo transfer) throws Exception {
        this.vsi = transfer;
        this.navDisplay.setDisplayInactive();
        if (this.navDisplay instanceof MapProjectionDisplay) {
            ((MapProjectionDisplay)this.navDisplay).setVertScaleInfo(transfer);
        }
        this.navDisplay.setVerticalRangeVisible(transfer.visible);
        this.navDisplay.setVerticalRangeUnit(transfer.unit);
        this.navDisplay.setVerticalRange(transfer.minVertRange, transfer.maxVertRange);
        this.navDisplay.setDisplayActive();
    }
}

