/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import ucar.visad.display.AxisScaleInfo;
import visad.CommonUnit;
import visad.Unit;

public class VertScaleInfo
extends AxisScaleInfo {
    public double maxVertRange;
    public double minVertRange;
    public Unit unit;
    public boolean visible;
    private double majorIncrement;
    private int minorDivision;
    public static final int DEFAULT_MAJ_DIVISIONS = 4;
    public static final String DEFAULT_AXIS_LABEL = "Altitude";

    public VertScaleInfo(double min, double max) {
        this(min, max, CommonUnit.meter);
    }

    public VertScaleInfo(double min, double max, Unit unit) {
        this.minVertRange = min;
        this.maxVertRange = max;
        this.unit = unit;
        this.minorDivision = 1;
        this.visible = true;
        this.setVisible(true);
        this.majorIncrement = (max - min) / 4.0;
        this.setLabel("Altitude (" + unit.getIdentifier() + ")");
    }

    public double getMajorIncrement() {
        return this.majorIncrement;
    }

    public void setMajorIncrement(double majorIncrement) {
        this.majorIncrement = majorIncrement;
    }

    public int getMinorDivision() {
        return this.minorDivision;
    }

    public void setMinorDivision(int minorDivision) {
        this.minorDivision = minorDivision;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.maxVertRange);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minVertRange);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.visible ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VertScaleInfo other = (VertScaleInfo)obj;
        if (Double.doubleToLongBits(this.maxVertRange) != Double.doubleToLongBits(other.maxVertRange)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minVertRange) != Double.doubleToLongBits(other.minVertRange)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        if (this.visible != other.visible) {
            return false;
        }
        if (this.majorIncrement != other.majorIncrement) {
            return false;
        }
        return this.minorDivision == other.minorDivision;
    }
}

