/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import ucar.unidata.ui.FontSelector;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.VertScaleInfo;
import ucar.unidata.view.geoloc.ViewpointControl;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.Unit;

public class VertScaleDialog
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    ViewpointControl control;
    JDialog dialog;
    private JTextField min;
    private JTextField max;
    private JTextField jtfAxisLabel;
    JFrame parent;
    VertScaleInfo vertScaleInfo;
    private JComboBox unitCombo;
    private JCheckBox jcbVisible;
    private JTextField vertIncrement;
    private JSpinner vertMinorSpinner;
    private FontSelector fontSelector;

    public VertScaleDialog(JFrame parent, ViewpointControl control, VertScaleInfo vertScaleInfo) {
        this.control = control;
        this.parent = parent;
        this.vertScaleInfo = vertScaleInfo;
        this.doMakeContents();
    }

    protected void doMakeContents() {
        this.setLayout(new BorderLayout());
        GuiUtils.tmpInsets = new Insets(5, 5, 0, 0);
        this.fontSelector = new FontSelector(0, false, false);
        this.jtfAxisLabel = new JTextField(20);
        Component[] componentArray = new Component[14];
        componentArray[0] = GuiUtils.rLabel("Min Value: ");
        this.min = new JTextField("");
        componentArray[1] = this.min;
        componentArray[2] = GuiUtils.rLabel("Max Value: ");
        this.max = new JTextField("");
        componentArray[3] = this.max;
        componentArray[4] = GuiUtils.rLabel("Axis Label: ");
        componentArray[5] = this.jtfAxisLabel;
        componentArray[6] = GuiUtils.rLabel("Units: ");
        this.unitCombo = GuiUtils.getEditableBox(Misc.toList(new String[]{"m", "km", "feet", "fathoms"}), null);
        componentArray[7] = this.unitCombo;
        componentArray[8] = GuiUtils.rLabel("Major Increment: ");
        this.vertIncrement = new JTextField();
        componentArray[9] = this.vertIncrement;
        componentArray[10] = GuiUtils.rLabel("Minor Division: ");
        this.vertMinorSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 10, 1));
        componentArray[11] = this.vertMinorSpinner;
        componentArray[12] = GuiUtils.rLabel("Visible: ");
        this.jcbVisible = new JCheckBox("", true);
        componentArray[13] = this.jcbVisible;
        JPanel vertPanel = GuiUtils.doLayout(componentArray, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        vertPanel.setBorder(BorderFactory.createTitledBorder("Vertical Scale Parameters"));
        this.min.setActionCommand(GuiUtils.CMD_OK);
        this.min.addActionListener(this);
        this.max.setActionCommand(GuiUtils.CMD_OK);
        this.max.addActionListener(this);
        JPanel fontPanel = GuiUtils.doLayout(new Component[]{GuiUtils.left(this.fontSelector.getComponent())}, 1, GuiUtils.WT_N, GuiUtils.WT_N);
        fontPanel.setBorder(BorderFactory.createTitledBorder("Font"));
        List<Component> pnls = Arrays.asList(GuiUtils.left(vertPanel), GuiUtils.left(fontPanel));
        this.add("Center", GuiUtils.doLayout(pnls, 1, 5, 5));
        if (this.vertScaleInfo != null) {
            String tmpStr;
            this.min.setText(Misc.format(this.vertScaleInfo.minVertRange));
            this.max.setText(Misc.format(this.vertScaleInfo.maxVertRange));
            this.vertIncrement.setText("" + this.vertScaleInfo.getMajorIncrement());
            this.vertMinorSpinner.setValue(this.vertScaleInfo.getMinorDivision());
            if (this.vertScaleInfo.unit != null) {
                this.unitCombo.setSelectedItem(this.vertScaleInfo.unit.toString());
            }
            if ((tmpStr = this.vertScaleInfo.getLabel()) == null || tmpStr.isEmpty()) {
                tmpStr = "Altitude";
            } else if (tmpStr.indexOf(" (") > 0) {
                tmpStr = tmpStr.substring(0, tmpStr.indexOf(" ("));
            }
            this.jtfAxisLabel.setText(tmpStr);
            this.jcbVisible.setSelected(this.vertScaleInfo.visible);
            this.fontSelector.setFont(this.vertScaleInfo.getFont());
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_OK)) {
            if (!this.doApply()) {
                return;
            }
            this.setVisible(false);
        } else if (cmd.equals(GuiUtils.CMD_APPLY)) {
            this.doApply();
        } else if (cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.setVisible(false);
        }
    }

    @Override
    public void setVisible(boolean v) {
        if (this.dialog != null) {
            this.dialog.setVisible(v);
        }
    }

    public void showDialog(VertScaleInfo transfer) {
        if (this.dialog == null) {
            JPanel buttons = GuiUtils.makeApplyOkCancelButtons(this);
            this.add("South", buttons);
            this.dialog = new JDialog(this.parent, "Vertical Scale", false);
            this.dialog.getContentPane().add("Center", this);
            this.dialog.pack();
            this.dialog.setLocation(100, 100);
        }
        this.vertScaleInfo = transfer;
        this.min.setText(Misc.format(transfer.minVertRange));
        this.max.setText(Misc.format(transfer.maxVertRange));
        this.unitCombo.setSelectedItem(transfer.unit.toString());
        this.vertMinorSpinner.setValue(transfer.getMinorDivision());
        this.fontSelector.setFont(transfer.getFont());
        String tmpStr = transfer.getLabel();
        if (tmpStr == null || tmpStr.isEmpty()) {
            tmpStr = "Altitude";
        } else if (tmpStr.indexOf(" (") > 0) {
            tmpStr = tmpStr.substring(0, tmpStr.indexOf(" ("));
        }
        this.jtfAxisLabel.setText(tmpStr);
        this.vertIncrement.setText("" + transfer.getMajorIncrement());
        this.jcbVisible.setSelected(transfer.isVisible());
        this.dialog.setVisible(true);
    }

    public boolean doApply() {
        float minValue = Float.NaN;
        float maxValue = Float.NaN;
        try {
            minValue = (float)Misc.parseNumber(this.min.getText());
            maxValue = (float)Misc.parseNumber(this.max.getText());
        }
        catch (NumberFormatException nfe) {
            LogUtil.userMessage("Invalid max or min value");
            return false;
        }
        Unit newUnit = null;
        try {
            newUnit = Util.parseUnit((String)this.unitCombo.getSelectedItem());
            if (!Unit.canConvert(newUnit, CommonUnit.meter)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            LogUtil.userMessage("Unknown or incompatible unit " + this.unitCombo.getSelectedItem());
            return false;
        }
        VertScaleInfo newTransfer = new VertScaleInfo(minValue, maxValue, newUnit);
        newTransfer.setLabel(this.jtfAxisLabel.getText() + " (" + newUnit.getIdentifier() + ")");
        newTransfer.setVisible(this.jcbVisible.isSelected());
        newTransfer.visible = this.jcbVisible.isSelected();
        newTransfer.setMajorIncrement(Misc.parseNumber(this.vertIncrement.getText()));
        newTransfer.setMinorDivision(Integer.valueOf(this.vertMinorSpinner.getValue().toString()));
        newTransfer.setFont(this.fontSelector.getFont());
        this.vertScaleInfo = newTransfer;
        try {
            this.control.applyVerticalRange(this.vertScaleInfo);
        }
        catch (Exception exc) {
            LogUtil.userMessage("An error has occurred: " + exc);
            return false;
        }
        return true;
    }

    public boolean isAxisVisible() {
        return this.jcbVisible.isSelected();
    }

    public VertScaleInfo getVertScaleInfo() {
        return this.vertScaleInfo;
    }
}

