/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.view.geoloc.NavigatedDisplayCursorReadout;
import ucar.visad.ProjectionCoordinateSystem;
import ucar.visad.display.RubberBandBox;
import ucar.visad.display.ScalarMapSet;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.Length;
import visad.ActionImpl;
import visad.AxisScale;
import visad.CommonUnit;
import visad.ControlEvent;
import visad.ControlListener;
import visad.CoordinateSystem;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.KeyboardBehavior;
import visad.MathType;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.ScalarMap;
import visad.ScalarType;
import visad.SetType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.VisADRay;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;
import visad.java3d.DefaultDisplayRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.KeyboardBehaviorJ3D;

public class TransectDisplay
extends NavigatedDisplay
implements DisplayListener,
ControlListener {
    private static final int CACHE_THRESHOLD = 100;
    private static final int CACHE_SIZE = 10;
    public static final float DEFAULT_Z = 0.0f;
    private ScalarMap latitudeMap = null;
    private ScalarMap longitudeMap = null;
    private ScalarMap altitudeMap = null;
    private ScalarMap xMap = null;
    private ScalarMap yMap = null;
    private ScalarMap zMap = null;
    private ScalarMap distanceMap = null;
    private ScalarMap heightMap = null;
    private ScalarMap pressureMap = null;
    private DisplayRealType displayLatitudeType;
    private DisplayRealType displayLongitudeType;
    private DisplayRealType displayAltitudeType;
    private DisplayTupleType displayTupleType;
    private AxisScale heightScale = null;
    private AxisScale pressureScale = null;
    private AxisScale latlonScale = null;
    private AxisScale distanceScale = null;
    private double altitudeMin = 0.0;
    private double altitudeMax = 16000.0;
    private boolean init = false;
    private CoordinateSystem coordinateSystem = null;
    private static int instance = 0;
    private static Object INSTANCE_MUTEX = new Object();
    private Unit[] csUnits = new Unit[]{CommonUnit.degree, CommonUnit.degree, CommonUnit.meter};
    private Gridded2DSet transect = null;
    private RealType verticalParameter = RealType.Altitude;
    private Real surface = new Real(RealType.Altitude, 0.0);
    private Unit verticalRangeUnit = CommonUnit.meter;
    private Unit horizontalRangeUnit = CommonUnits.KILOMETER;
    private int view = 4;
    DecimalFormat labelFormat = new DecimalFormat("####0.0");
    private NavigatedDisplay.VerticalMapSet verticalMapSet = new NavigatedDisplay.VerticalMapSet();
    private boolean gridLinesVisible = true;
    private double SCALE_OFFSET = 0.1111111111111111;
    private Real maxDistance = null;
    public static String[] DEFAULT_PRESSURE_LABELS = new String[]{"1000", "850", "700", "500", "400", "300", "250", "200", "150", "100"};
    private String[] pressureLabels = DEFAULT_PRESSURE_LABELS;
    private double pressureMin = 1013.25;
    private Font axisFont;
    List cacheInfos = new ArrayList();

    public TransectDisplay() throws VisADException, RemoteException {
        this(TransectDisplay.makeDefaultLine());
    }

    public TransectDisplay(Gridded2DSet line) throws VisADException, RemoteException {
        this(line, false, null);
    }

    public TransectDisplay(Gridded2DSet line, boolean offscreen, Dimension dimension) throws VisADException, RemoteException {
        if (offscreen) {
            if (dimension == null) {
                dimension = new Dimension(600, 400);
            }
            this.setOffscreenDimension(dimension);
        }
        DisplayImplJ3D displayImpl = null;
        int api = offscreen ? 2 : 1;
        displayImpl = offscreen ? new DisplayImplJ3D("TransectDisplay", (DisplayRendererJ3D)new TransectDisplayRenderer(), dimension.width, dimension.height) : new DisplayImplJ3D("TransectDisplay", (DisplayRendererJ3D)new TransectDisplayRenderer());
        super.init(displayImpl);
        if (line.getManifoldDimension() != 1) {
            throw new VisADException("Set needs to define a line, not a grid");
        }
        this.maxDistance = new Real(Length.getRealType());
        this.transect = this.ensureLatLon(line);
        this.coordinateSystem = new TransectCoordinateSystem(line);
        this.setBoxVisible(false);
        this.setScalesVisible(true);
        this.setMapParameters();
        this.initializeClass();
    }

    @Override
    protected void initializeClass() throws VisADException, RemoteException {
        super.initializeClass();
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        KeyboardBehaviorJ3D kb = new KeyboardBehaviorJ3D(rend);
        rend.addKeyboardBehavior(kb);
        this.setKeyboardBehavior(kb);
        this.setPerspectiveView(false);
        RubberBandBox rubberBandBox = new RubberBandBox(RealType.XAxis, RealType.YAxis, 1);
        rubberBandBox.addAction(new ActionImpl("RBB Action"){

            @Override
            public void doAction() throws VisADException, RemoteException {
                RubberBandBox box = TransectDisplay.this.getRubberBandBox();
                if (box == null || box.getBounds() == null) {
                    return;
                }
                TransectDisplay.this.setMapRegion(box.getBounds());
            }
        });
        this.setRubberBandBox(rubberBandBox);
        this.enableRubberBanding(true);
        int[][][] functions = new int[][][]{new int[][]{{6, 6}, {6, 6}}, new int[][]{{-1, -1}, {-1, -1}}, new int[][]{{2, 1}, {2, 1}}};
        this.setMouseFunctions(functions);
        this.getDisplay().getGraphicsModeControl().setPolygonOffsetFactor(1.0f);
        this.getDisplay().getProjectionControl().addControlListener(this);
        this.addDisplayListener(this);
    }

    public EarthLocation[] getScaleEndPoints() {
        Rectangle bounds = this.getScreenBounds();
        EarthLocation leftEl = this.getEarthLocation(this.getSpatialCoordinatesFromScreen(0 + (int)(this.SCALE_OFFSET * (double)bounds.width), bounds.height, 0.0));
        EarthLocation rightEl = this.getEarthLocation(this.getSpatialCoordinatesFromScreen(bounds.width - (int)(this.SCALE_OFFSET * (double)bounds.width), bounds.height, 0.0));
        return new EarthLocation[]{leftEl, rightEl};
    }

    @Override
    public void addKeyboardBehavior(KeyboardBehavior behavior) {
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        KeyboardBehaviorWrapper3D beh = new KeyboardBehaviorWrapper3D(rend, behavior);
        rend.addKeyboardBehavior(beh);
    }

    @Override
    public void displayChanged(DisplayEvent event) throws VisADException, RemoteException {
        int id = event.getId();
        if (id == 12) {
            this.getDisplay().getProjectionControl().addControlListener(this);
        }
    }

    @Override
    public void controlChanged(ControlEvent ce) {
        if (this.isClippingEnabled()) {
            this.clipAtScales(true);
        }
    }

    private static Gridded2DSet makeDefaultLine() throws VisADException {
        return new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, (float[][])new float[][]{{-90.0f, 90.0f}, {-180.0f, 180.0f}}, 2, null, null, null, false);
    }

    @Override
    protected void cursorMoved() throws VisADException, RemoteException {
        this.updateLocation(this.getEarthLocation(this.getDisplay().getDisplayRenderer().getCursor()));
    }

    @Override
    protected void pointerMoved(int x, int y) throws UnitException, VisADException, RemoteException {
        VisADRay ray = this.getRay(x, y);
        this.updateLocation(this.getEarthLocation(new double[]{ray.position[0], ray.position[1], ray.position[2]}));
    }

    private void setSpatialScalarMaps() throws VisADException, RemoteException {
        this.setDisplayInactive();
        ScalarMapSet mapSet = new ScalarMapSet();
        if (this.latitudeMap != null) {
            this.removeScalarMap(this.latitudeMap);
        }
        this.latitudeMap = new ScalarMap(RealType.Latitude, this.displayLatitudeType);
        mapSet.add(this.latitudeMap);
        this.latitudeMap.setRangeByUnits();
        this.latitudeMap.setScaleEnable(false);
        if (this.longitudeMap != null) {
            this.removeScalarMap(this.longitudeMap);
        }
        this.longitudeMap = new ScalarMap(RealType.Longitude, this.displayLongitudeType);
        mapSet.add(this.longitudeMap);
        this.longitudeMap.setRangeByUnits();
        this.longitudeMap.setScaleEnable(false);
        ScalarMapSet newVertMaps = new ScalarMapSet();
        if (this.verticalMapSet.size() > 0) {
            Iterator iter = this.verticalMapSet.iterator();
            while (iter.hasNext()) {
                ScalarType r = ((ScalarMap)iter.next()).getScalar();
                ScalarMap newMap = new ScalarMap(r, this.displayAltitudeType);
                newMap.setScaleEnable(false);
                if (r.equals(RealType.Altitude)) {
                    this.altitudeMap = newMap;
                }
                newVertMaps.add(newMap);
            }
        } else {
            this.altitudeMap = new ScalarMap(RealType.Altitude, this.displayAltitudeType);
            this.altitudeMap.setScaleEnable(false);
            newVertMaps.add(this.altitudeMap);
        }
        this.removeScalarMaps(this.verticalMapSet);
        this.verticalMapSet.clear();
        this.verticalMapSet.add(newVertMaps);
        mapSet.add(this.verticalMapSet);
        if (!this.init) {
            this.xMap = new ScalarMap(RealType.XAxis, Display.XAxis);
            this.xMap.setRange(-1.0, 1.0);
            mapSet.add(this.xMap);
            this.xMap.setScaleEnable(true);
            this.latlonScale = this.xMap.getAxisScale();
            this.latlonScale.setScreenBased(true);
            this.latlonScale.setSide(1);
            this.latlonScale.setLabelSize(10);
            this.distanceMap = new ScalarMap(Length.getRealType(), Display.XAxis);
            mapSet.add(this.distanceMap);
            this.distanceMap.setScaleEnable(true);
            this.distanceScale = this.distanceMap.getAxisScale();
            this.distanceScale.setScreenBased(true);
            this.distanceScale.setLabelAllTicks(true);
            this.distanceScale.setSide(0);
            this.distanceScale.setLabelSize(10);
            this.yMap = new ScalarMap(RealType.YAxis, Display.YAxis);
            this.yMap.setRange(-1.0, 1.0);
            mapSet.add(this.yMap);
            this.yMap.setScaleEnable(false);
            this.heightMap = new ScalarMap(Length.getRealType(), Display.YAxis);
            mapSet.add(this.heightMap);
            this.heightMap.setScaleEnable(true);
            this.heightScale = this.heightMap.getAxisScale();
            this.heightScale.setScreenBased(true);
            this.heightScale.setLabelAllTicks(true);
            this.heightScale.setLabelSize(10);
            this.pressureMap = new ScalarMap(RealType.getRealType("PressureForScale"), Display.YAxis);
            mapSet.add(this.pressureMap);
            this.pressureMap.setScaleEnable(true);
            this.pressureScale = this.pressureMap.getAxisScale();
            this.pressureScale.setScreenBased(true);
            this.pressureScale.setSide(1);
            this.pressureScale.setTicksVisible(false);
            this.pressureScale.setLabelSize(10);
            this.setPressureLabels(DEFAULT_PRESSURE_LABELS);
            this.zMap = new ScalarMap(RealType.ZAxis, Display.ZAxis);
            this.zMap.setRange(-1.0, 1.0);
            mapSet.add(this.zMap);
            this.zMap.setScaleEnable(false);
            this.init = true;
        }
        this.setFontOnScales();
        this.setVerticalRange(this.altitudeMin, this.altitudeMax);
        this.setVerticalRangeUnit(this.verticalRangeUnit);
        this.makeVerticalScales();
        this.addScalarMaps(mapSet);
        this.setDisplayActive();
    }

    @Override
    public void addVerticalMap(RealType newVertType) throws VisADException, RemoteException {
        if (this.getDisplayMode() == 0) {
            Unit u = newVertType.getDefaultUnit();
            if (!Unit.canConvert(u, CommonUnit.meter) && !Unit.canConvert(u, GeopotentialAltitude.getGeopotentialMeter())) {
                throw new VisADException("Unable to handle units of " + newVertType);
            }
            ScalarMap newMap = new ScalarMap(newVertType, this.getDisplayAltitudeType());
            this.setVerticalMapUnit(newMap, this.verticalRangeUnit);
            newMap.setRange(this.altitudeMin, this.altitudeMax);
            this.verticalMapSet.add(newMap);
            this.addScalarMaps(this.verticalMapSet);
        }
    }

    @Override
    public void removeVerticalMap(RealType vertType) throws VisADException, RemoteException {
        if (this.getDisplayMode() == 0) {
            ScalarMapSet sms = new ScalarMapSet();
            Iterator iter = this.verticalMapSet.iterator();
            while (iter.hasNext()) {
                ScalarMap s = (ScalarMap)iter.next();
                if (!((RealType)s.getScalar()).equals(vertType)) continue;
                sms.add(s);
            }
            if (sms.size() != 0) {
                this.verticalMapSet.remove(sms);
                this.removeScalarMaps(sms);
            }
        }
    }

    @Override
    public void setVerticalRangeUnit(Unit newUnit) throws VisADException, RemoteException {
        super.setVerticalRangeUnit(newUnit);
        if (newUnit != null && Unit.canConvert(newUnit, CommonUnit.meter)) {
            this.verticalMapSet.setVerticalUnit(newUnit);
            this.verticalRangeUnit = newUnit;
        }
        this.heightMap.setOverrideUnit(newUnit);
        this.makeVerticalScales();
    }

    @Override
    public void setVerticalRange(double min, double max) throws VisADException, RemoteException {
        super.setVerticalRange(min, max);
        this.verticalMapSet.setVerticalRange(min, max);
        this.altitudeMin = min;
        this.altitudeMax = max;
        this.heightMap.setRange(min, max);
        this.pressureMap.setRange(min, max);
        this.makeVerticalScales();
    }

    @Override
    public double[] getVerticalRange() {
        double[] dArray;
        ScalarMap vertMap = this.getAltitudeMap();
        if (vertMap != null) {
            dArray = vertMap.getRange();
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = this.altitudeMin;
            dArray = dArray2;
            dArray2[1] = this.altitudeMax;
        }
        return dArray;
    }

    public void setHorizontalRangeUnit(Unit newUnit) throws VisADException, RemoteException {
        if (newUnit != null && Unit.canConvert(newUnit, CommonUnit.meter)) {
            this.horizontalRangeUnit = newUnit;
        }
        this.distanceMap.setOverrideUnit(newUnit);
        this.setTransectRange();
    }

    public Unit getHorizontalRangeUnit() {
        return this.horizontalRangeUnit;
    }

    private void makeVerticalScales() throws VisADException, RemoteException {
        this.setDisplayInactive();
        if (this.heightScale != null) {
            double[] zRange = this.heightMap.getRange();
            String title = "Altitude (" + this.verticalRangeUnit.getIdentifier() + ")";
            this.heightScale.setSnapToBox(true);
            this.heightScale.setTitle(title);
            this.heightScale.setGridLinesVisible(this.gridLinesVisible);
            this.heightScale.setTickBase(zRange[0]);
        }
        if (this.pressureScale != null) {
            this.setPressureLabels(this.pressureLabels);
            String title = "Pressure (" + CommonUnits.MILLIBAR + ")";
            this.pressureScale.setSnapToBox(true);
            this.pressureScale.setTitle(title);
        }
        this.setDisplayActive();
    }

    private void setMapParameters() throws VisADException, RemoteException {
        this.setDisplayInactive();
        if (this.displayAltitudeType == null) {
            this.setDisplayTypes();
        }
        this.makeLatLonScale();
        this.setTransectRange();
        this.reDisplayAll();
        this.setDisplayActive();
    }

    public void setMaxDataDistance(Real r) throws VisADException {
        if (!Unit.canConvert(r.getUnit(), SI.meter)) {
            throw new VisADException("Value must be in units of length");
        }
        this.maxDistance = r;
        this.cacheInfos = new ArrayList();
        this.reDisplayAll();
    }

    public void setMaxDataDistance(double distance) throws VisADException {
        this.setMaxDataDistance(new Real((RealType)this.maxDistance.getType(), distance, this.getHorizontalRangeUnit()));
    }

    public Real getMaxDataDistance() {
        return this.maxDistance;
    }

    public void setGridLinesVisible(boolean on) throws VisADException, RemoteException {
        this.gridLinesVisible = on;
        this.makeScales();
    }

    @Override
    public boolean getScalesVisible() {
        return this.getDisplay().getGraphicsModeControl().getScaleEnable();
    }

    private void makeScales() throws VisADException, RemoteException {
        this.makeLatLonScale();
        this.makeVerticalScales();
        this.makeDistanceScale();
    }

    private void makeLatLonScale() throws VisADException, RemoteException {
        if (this.latlonScale == null || this.coordinateSystem == null) {
            return;
        }
        this.setDisplayInactive();
        double[] xRange = this.xMap.getRange();
        this.latlonScale.setSnapToBox(true);
        this.latlonScale.setTitle("Location");
        Hashtable<Double, String> labelTable = new Hashtable<Double, String>();
        float[][] linePoints = this.transect.getSamples();
        int numpoints = linePoints[0].length;
        float[][] xyzPoints = this.coordinateSystem.toReference(new float[][]{linePoints[0], linePoints[1], new float[numpoints]});
        LatLonPointImpl workPoint = new LatLonPointImpl();
        for (int i = 0; i < xyzPoints[0].length; ++i) {
            workPoint.set(linePoints[0][i], linePoints[1][i]);
            String txtLabel = i == 0 ? workPoint.toString() + " (B)" : (i == xyzPoints[0].length - 1 ? workPoint.toString() + " (E)" : "W" + i);
            labelTable.put(new Double(xyzPoints[0][i]), txtLabel);
        }
        this.latlonScale.setLabelTable(labelTable);
        this.latlonScale.setTickBase(xRange[0]);
        this.latlonScale.setMajorTickSpacing(Math.abs(xRange[1] - xRange[0]));
        this.latlonScale.setMinorTickSpacing(Math.abs(xRange[1] - xRange[0]));
        this.setDisplayActive();
    }

    private void makeDistanceScale() throws VisADException, RemoteException {
        if (this.distanceScale == null || this.coordinateSystem == null) {
            return;
        }
        this.setDisplayInactive();
        double[] distRange = this.distanceMap.getRange();
        this.distanceScale.setSnapToBox(true);
        this.distanceScale.setTitle("Distance (" + this.horizontalRangeUnit + ")");
        this.distanceScale.setGridLinesVisible(this.gridLinesVisible);
        this.distanceScale.setTickBase(0.0);
        this.setDisplayActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisplayTypes() throws VisADException, RemoteException {
        if (this.coordinateSystem == null) {
            System.out.println("coordSys == null");
            this.displayLongitudeType = Display.XAxis;
            this.displayAltitudeType = Display.YAxis;
            this.displayLatitudeType = Display.ZAxis;
            this.displayTupleType = Display.DisplaySpatialCartesianTuple;
        } else {
            int myInstance;
            Object object = INSTANCE_MUTEX;
            synchronized (object) {
                myInstance = instance++;
            }
            this.displayLatitudeType = new DisplayRealType("TransectProjectionLat" + myInstance, true, -90.0, 90.0, 0.0, CommonUnit.degree);
            this.displayLongitudeType = new DisplayRealType("TransectProjectionLon" + myInstance, true, -180.0, 180.0, 0.0, CommonUnit.degree);
            this.displayAltitudeType = new DisplayRealType("TransectProjectionAlt" + myInstance, true, -1.0, 1.0, -1.0, null);
            this.displayTupleType = new DisplayTupleType(new DisplayRealType[]{this.displayLatitudeType, this.displayLongitudeType, this.displayAltitudeType}, this.coordinateSystem);
        }
        this.setSpatialScalarMaps();
    }

    private void setTransectRange() throws VisADException, RemoteException {
        float[][] linePoints = this.transect.getSamples();
        int numpoints = linePoints[0].length;
        double distance = 0.0;
        for (int p = 0; p < numpoints - 1; ++p) {
            LatLonPointImpl startPoint = new LatLonPointImpl(linePoints[0][p], linePoints[1][p]);
            LatLonPointImpl endPoint = new LatLonPointImpl(linePoints[0][p + 1], linePoints[1][p + 1]);
            Bearing workBearing = Bearing.calculateBearing(startPoint, endPoint);
            distance += workBearing.getDistance();
        }
        distance = this.horizontalRangeUnit.toThis(distance, CommonUnits.KILOMETER);
        if (this.distanceMap != null) {
            this.distanceMap.setRange(0.0, distance);
        }
        this.makeDistanceScale();
    }

    @Override
    public void setMapArea(ProjectionRect mapArea) throws VisADException, RemoteException {
    }

    public void setMapRegion(Gridded2DSet region) throws VisADException, RemoteException {
        Gridded2DSet xyRegion;
        if (region == null) {
            throw new VisADException("Region can't be null");
        }
        if (region.isMissing()) {
            return;
        }
        RealTupleType regionType = ((SetType)region.getType()).getDomain();
        if (regionType.equals(RealTupleType.SpatialCartesian2DTuple)) {
            xyRegion = region;
        } else if (regionType.equals(RealTupleType.SpatialEarth2DTuple) || regionType.equals(RealTupleType.LatitudeLongitudeTuple)) {
            int latIndex = regionType.equals(RealTupleType.LatitudeLongitudeTuple) ? 0 : 1;
            int lonIndex = latIndex == 0 ? 1 : 0;
            float[][] values = region.getSamples(true);
            float[][] xy = new float[3][values[0].length];
            xy[0] = values[latIndex];
            xy[1] = values[lonIndex];
            xy = this.coordinateSystem.toReference(xy);
            values[0] = xy[0];
            values[1] = xy[1];
            xyRegion = new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, values, 2);
        } else {
            throw new VisADException("Invalid domain for region " + regionType);
        }
        Dimension d = this.getComponent().getSize();
        int componentCenterX = d.width / 2;
        int componentCenterY = d.height / 2;
        MouseBehavior behavior = this.getDisplay().getDisplayRenderer().getMouseBehavior();
        ProjectionControl proj = this.getDisplay().getProjectionControl();
        double[] aspect = this.getDisplayAspect();
        double[] center_ray = behavior.findRay((int)componentCenterX, (int)componentCenterY).position;
        double[] center_ray_x = behavior.findRay((int)(componentCenterX + 1), (int)componentCenterY).position;
        double[] center_ray_y = behavior.findRay((int)componentCenterX, (int)(componentCenterY + 1)).position;
        double[] tstart = proj.getMatrix();
        double[] rot = new double[3];
        double[] scale = new double[3];
        double[] trans = new double[3];
        behavior.instance_unmake_matrix(rot, scale, trans, tstart);
        double stx = scale[0];
        double sty = scale[1];
        double[] trot = behavior.make_matrix(rot[0], rot[1], rot[2], scale[0], scale[1], scale[2], 0.0, 0.0, 0.0);
        double[] xmat = behavior.make_translate(center_ray_x[0] - center_ray[0], center_ray_x[1] - center_ray[1], center_ray_x[2] - center_ray[2]);
        double[] ymat = behavior.make_translate(center_ray_y[0] - center_ray[0], center_ray_y[1] - center_ray[1], center_ray_y[2] - center_ray[2]);
        double[] xmatmul = behavior.multiply_matrix(trot, xmat);
        double[] ymatmul = behavior.multiply_matrix(trot, ymat);
        behavior.instance_unmake_matrix(rot, scale, trans, xmatmul);
        double xmul = trans[0];
        behavior.instance_unmake_matrix(rot, scale, trans, ymatmul);
        double ymul = trans[1];
        if (Math.abs(xmul) > 0.0 && Math.abs(ymul) > 0.0) {
            float[] lows = xyRegion.getLow();
            float[] highs = xyRegion.getHi();
            float boxCenterDisplayX = (highs[0] + lows[0]) / 2.0f;
            float boxCenterDisplayY = (highs[1] + lows[1]) / 2.0f;
            int boxWidth = (int)Math.abs((double)(highs[0] - lows[0]) / xmul * stx);
            int boxHeight = (int)Math.abs((double)(highs[1] - lows[1]) / ymul * sty);
            if (boxWidth > 5 && boxHeight > 5) {
                int boxCenterX = componentCenterX + (int)(((double)boxCenterDisplayX - center_ray[0]) / xmul);
                int boxCenterY = componentCenterY - (int)(((double)boxCenterDisplayY - center_ray[1]) / ymul);
                double transx = (double)(componentCenterX - boxCenterX) * xmul * stx;
                double transy = (double)(componentCenterY - boxCenterY) * ymul * sty;
                double zoom = boxWidth / boxHeight >= d.width / d.height ? d.getWidth() / (double)boxWidth : d.getHeight() / (double)boxHeight;
                this.translate(transx, -transy);
                this.zoom(zoom);
            }
        }
    }

    @Override
    public void setMapProjection(MapProjection mapProjection) throws VisADException, RemoteException {
        Rectangle2D rect = mapProjection.getDefaultMapArea();
        LatLonRect region = null;
        if (mapProjection instanceof ProjectionCoordinateSystem) {
            ProjectionImpl proj = ((ProjectionCoordinateSystem)mapProjection).getProjection();
            region = proj.getDefaultMapAreaLL();
        } else if (mapProjection instanceof TrivialMapProjection) {
            Rectangle2D r2d2 = mapProjection.getDefaultMapArea();
            double x = r2d2.getX();
            double y = r2d2.getY();
            double width = r2d2.getWidth();
            double height = r2d2.getHeight();
            LatLonPointImpl start = mapProjection.isLatLonOrder() ? new LatLonPointImpl(x, y) : new LatLonPointImpl(y, x);
            region = mapProjection.isLatLonOrder() ? new LatLonRect(start, width, height) : new LatLonRect(start, height, width);
        } else {
            throw new VisADException("unable to get transect for " + mapProjection);
        }
        this.transect = TransectDisplay.rectToLine(region);
        this.setMapParameters();
    }

    private static Gridded2DSet rectToLine(LatLonRect llr) throws VisADException {
        LatLonPointImpl start = llr.getLowerLeftPoint();
        LatLonPointImpl end = llr.getUpperRightPoint();
        Gridded2DSet line = new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, (float[][])new float[][]{{(float)start.getLatitude(), (float)end.getLatitude()}, {(float)start.getLongitude(), (float)end.getLongitude()}}, 2, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, false);
        return line;
    }

    @Override
    public DisplayRealType getDisplayLatitudeType() {
        return this.displayLatitudeType;
    }

    @Override
    public DisplayRealType getDisplayLongitudeType() {
        return this.displayLongitudeType;
    }

    @Override
    public DisplayRealType getDisplayAltitudeType() {
        return this.displayAltitudeType;
    }

    public DisplayTupleType getDisplayTupleType() {
        return this.displayTupleType;
    }

    @Override
    protected ScalarMap getAltitudeMap() {
        return this.altitudeMap;
    }

    protected Gridded2DSet getTransect() {
        return this.transect;
    }

    public void setTransect(Gridded2DSet newLine) throws VisADException, RemoteException {
        this.cacheInfos = new ArrayList();
        this.transect = newLine;
        this.setMapParameters();
    }

    protected void cursorChange() throws VisADException, RemoteException {
        this.setCursorLatitude(this.getCursorValue(RealType.Latitude, 0));
        this.setCursorLongitude(this.getCursorValue(RealType.Longitude, 1));
        Real fakeAltitude = this.getCursorValue(RealType.Radius, 2);
        double realValue = fakeAltitude.getValue() * (this.altitudeMax - this.altitudeMin) / 2.0 + this.altitudeMin;
        this.setCursorAltitude(new Real(RealType.Altitude, realValue));
    }

    @Override
    public void setView(int view) {
        this.view = view;
    }

    @Override
    public void enableClipping(boolean clip) {
        this.clipAtScales(clip);
        super.enableClipping(clip);
    }

    private void clipAtScales(boolean clip) {
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        Dimension d = this.getComponent().getSize();
        if (d.width == 0 && d.height == 0) {
            return;
        }
        int numXPix = (int)((double)d.width * this.SCALE_OFFSET);
        double[] xy1 = this.getSpatialCoordinatesFromScreen(numXPix, d.height - numXPix);
        double[] xy2 = this.getSpatialCoordinatesFromScreen(d.width - numXPix, numXPix);
        try {
            dr.setClip(0, clip, 1.0f, 0.0f, 0.0f, (float)(-xy2[0]));
            dr.setClip(1, clip, -1.0f, 0.0f, 0.0f, (float)xy1[0]);
            dr.setClip(2, clip, 0.0f, 1.0f, 0.0f, (float)(-xy2[1]));
            dr.setClip(3, clip, 0.0f, -1.0f, 0.0f, (float)xy1[1]);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't set clipping " + ve);
        }
    }

    public double[][] getXAxisEndPoints() {
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        Dimension d = this.getComponent().getSize();
        if (d.width == 0 && d.height == 0) {
            return null;
        }
        int numXPix = d.width / 9;
        double[] xy1 = this.getSpatialCoordinatesFromScreen(numXPix, d.height - numXPix);
        double[] xy2 = this.getSpatialCoordinatesFromScreen(d.width - numXPix, d.height - numXPix);
        return new double[][]{xy1, xy2};
    }

    public double[][] getYAxisEndPoints() {
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        Dimension d = this.getComponent().getSize();
        if (d.width == 0 && d.height == 0) {
            return null;
        }
        int numXPix = d.width / 9;
        double[] xy1 = this.getSpatialCoordinatesFromScreen(numXPix, d.height - numXPix);
        double[] xy2 = this.getSpatialCoordinatesFromScreen(numXPix, numXPix);
        return new double[][]{xy1, xy2};
    }

    @Override
    public void setDisplayAspect(double[] aspect) throws VisADException, RemoteException {
        super.setDisplayAspect(aspect);
    }

    @Override
    public void setPerspectiveView(boolean perspective) {
        if (perspective == this.isPerspectiveView()) {
            return;
        }
        try {
            this.getDisplay().getGraphicsModeControl().setProjectionPolicy(perspective ? 1 : 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setPerspectiveView(perspective);
    }

    @Override
    public EarthLocation getEarthLocation(double x, double y, double z, boolean setZToZeroIfOverhead) {
        EarthLocationTuple value = null;
        try {
            float[][] numbers = this.coordinateSystem.fromReference(new float[][]{{(float)x}, {(float)y}, {(float)z}});
            Real lat = new Real(RealType.Latitude, this.getScaledValue(this.latitudeMap, numbers[0][0]), this.csUnits[0]);
            Real lon = new Real(RealType.Longitude, this.getScaledValue(this.longitudeMap, numbers[1][0]), this.csUnits[1]);
            Real alt = new Real(RealType.Altitude, (double)this.getScaledValue(this.altitudeMap, numbers[2][0]));
            value = new EarthLocationTuple(lat, lon, alt);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public RealTuple getSpatialCoordinates(EarthLocation el) {
        if (el == null) {
            throw new NullPointerException("MapProjectionDisplay.getSpatialCoorindate():  null input EarthLocation");
        }
        RealTuple spatialLoc = null;
        try {
            double[] xyz = this.getSpatialCoordinates(el, null);
            spatialLoc = new RealTuple(RealTupleType.SpatialCartesian3DTuple, xyz);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return spatialLoc;
    }

    @Override
    public double[] getSpatialCoordinates(EarthLocation el, double[] xyz, double altitude) throws VisADException, RemoteException {
        float[][] temp = this.coordinateSystem.toReference(new float[][]{this.latitudeMap.scaleValues(new double[]{el.getLatitude().getValue(CommonUnit.degree)}), this.longitudeMap.scaleValues(new double[]{el.getLongitude().getValue(CommonUnit.degree)}), this.altitudeMap.scaleValues(new double[]{altitude})});
        if (xyz == null) {
            xyz = new double[]{temp[0][0], temp[1][0], temp[2][0]};
        }
        return xyz;
    }

    private Real getCursorValue(RealType realType, int index) {
        double[] cursor = this.getDisplay().getDisplayRenderer().getCursor();
        Real value = null;
        try {
            value = new Real(realType, this.coordinateSystem.fromReference(new double[][]{{cursor[0]}, {cursor[1]}, {cursor[2]}})[index][0], this.csUnits[index]);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public boolean getStereoAvailable() {
        return false;
    }

    @Override
    public CoordinateSystem getDisplayCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setScaleFont(Font f) {
        this.axisFont = f;
        this.setFontOnScales();
    }

    private void setFontOnScales() {
        if (this.heightScale != null) {
            this.heightScale.setFont(this.axisFont);
        }
        if (this.pressureScale != null) {
            this.pressureScale.setFont(this.axisFont);
        }
        if (this.latlonScale != null) {
            this.latlonScale.setFont(this.axisFont);
        }
        if (this.distanceScale != null) {
            this.distanceScale.setFont(this.axisFont);
        }
    }

    private Gridded2DSet ensureLatLon(Gridded2DSet line) throws VisADException {
        RealTupleType type = ((SetType)line.getType()).getDomain();
        if (type.equals(RealTupleType.LatitudeLongitudeTuple)) {
            return line;
        }
        if (type.equals(RealTupleType.SpatialEarth2DTuple)) {
            return new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, line.getSamples(false), line.getLength(), line.getCoordinateSystem(), line.getSetUnits(), line.getSetErrors(), false);
        }
        throw new VisADException("Line must be lat/lon or lon/lat");
    }

    public void extendTransect(double amount) {
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        Dimension d = this.getComponent().getSize();
        if (d.width == 0 && d.height == 0) {
            return;
        }
        double[][] points = this.getXAxisEndPoints();
        EarthLocation el = this.getEarthLocation(points[0][0], points[0][1], 0.0);
        this.zoom(amount, 1.0, 1.0);
        MouseBehavior behavior = dr.getMouseBehavior();
        ProjectionControl proj = this.getDisplay().getProjectionControl();
        double[] tstart = proj.getMatrix();
        double[] rot = new double[3];
        double[] scale = new double[3];
        double[] trans = new double[3];
        behavior.instance_unmake_matrix(rot, scale, trans, tstart);
        double stx = scale[0];
        double[][] newpoints = this.getXAxisEndPoints();
        double[] elxyz = this.getSpatialCoordinates(el).getValues();
        double xtrans = (newpoints[0][0] - elxyz[0]) * stx;
        this.translate(xtrans, 0.0);
    }

    public void extendVerticalRange(double amount) {
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        Dimension d = this.getComponent().getSize();
        if (d.width == 0 && d.height == 0) {
            return;
        }
        double[][] points = this.getYAxisEndPoints();
        EarthLocation el = this.getEarthLocation(points[0][0], points[0][1], points[0][2]);
        this.zoom(1.0, amount, 1.0);
        MouseBehavior behavior = dr.getMouseBehavior();
        ProjectionControl proj = this.getDisplay().getProjectionControl();
        double[] tstart = proj.getMatrix();
        double[] rot = new double[3];
        double[] scale = new double[3];
        double[] trans = new double[3];
        behavior.instance_unmake_matrix(rot, scale, trans, tstart);
        double sty = scale[1];
        double[][] newpoints = this.getYAxisEndPoints();
        double[] elxyz = this.getSpatialCoordinates(el).getValues();
        double ytrans = (newpoints[0][1] - elxyz[1]) * sty;
        this.translate(0.0, ytrans);
    }

    public void setPressureLabels(String[] labels) throws VisADException {
        int numLabels = labels.length;
        double value = Double.NaN;
        double[] values = new double[labels.length];
        Hashtable<Double, String> labelTable = new Hashtable<Double, String>();
        for (int i = 0; i < numLabels; ++i) {
            try {
                value = Misc.parseNumber(labels[i]);
            }
            catch (NumberFormatException ne) {
                value = Double.NaN;
            }
            values[i] = value;
        }
        double[] heights = AirPressure.getStandardAtmosphereCS().toReference(new double[][]{values})[0];
        heights = this.getVerticalRangeUnit().toThis(heights, CommonUnit.meter, true);
        for (int i = 0; i < numLabels; ++i) {
            labelTable.put(new Double(heights[i]), labels[i]);
        }
        if (this.pressureScale != null) {
            this.pressureScale.setLabelTable(labelTable);
        }
        this.pressureLabels = labels;
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        float[][] points = new float[][]{{39.0f, 38.0f, 41.0f}, {-110.0f, -107.0f, -105.0f}};
        Gridded2DSet line = new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, (float[][])points, points[0].length, null, null, null, false);
        TransectDisplay navDisplay = new TransectDisplay(line);
        navDisplay.setCursorStringOn(true);
        navDisplay.setScalesVisible(true);
        navDisplay.setGridLinesVisible(true);
        navDisplay.setBoxVisible(false);
        navDisplay.setHorizontalRangeUnit(CommonUnits.NAUTICAL_MILE);
        navDisplay.setVerticalRangeUnit(CommonUnits.FOOT);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(navDisplay.getComponent(), "Center");
        panel.add((Component)new NavigatedDisplayCursorReadout(navDisplay), "South");
        navDisplay.draw();
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
        EarthLocationTuple el = new EarthLocationTuple(44.254, -121.15, 938.0);
        System.out.println("Earth location " + el + " translates to:");
        Misc.printArray("xyz", navDisplay.getSpatialCoordinates(el, null));
    }

    private static class TransectDisplayRenderer
    extends DefaultDisplayRendererJ3D {
        @Override
        public boolean getMode2D() {
            return true;
        }
    }

    protected class TransectCoordinateSystem
    extends CoordinateSystem {
        private Gridded2DSet transect;
        private double[] lenToPoint;
        private double[] distances;
        private double[] angles;
        private double totalLength;
        private int numLinePoints;
        private int numSegments;

        public TransectCoordinateSystem(Gridded2DSet line) throws VisADException {
            super(Display.DisplaySpatialCartesianTuple, new Unit[]{CommonUnit.degree, CommonUnit.degree, null});
            this.transect = null;
            this.lenToPoint = null;
            this.distances = null;
            this.angles = null;
            this.totalLength = 0.0;
            this.transect = TransectDisplay.this.ensureLatLon(line);
            this.precalculate();
        }

        @Override
        public float[][] toReference(float[][] latlonalt) throws VisADException {
            CacheInfo cacheInfo;
            int index;
            if (latlonalt == null || latlonalt[0].length < 1) {
                return latlonalt;
            }
            int numpoints = latlonalt[0].length;
            this.checkForNewLine();
            float[][] linePoints = this.transect.getSamples(false);
            if (numpoints > 100 && (index = TransectDisplay.this.cacheInfos.indexOf(cacheInfo = new CacheInfo(latlonalt, linePoints))) >= 0) {
                cacheInfo = (CacheInfo)TransectDisplay.this.cacheInfos.get(index);
                return Misc.cloneArray(cacheInfo.xyz);
            }
            float[][] xyz = new float[3][numpoints];
            this.call1("toReference(f)", numpoints);
            float[] x = xyz[0];
            float[] y = xyz[1];
            float[] z = xyz[2];
            float[] lat = latlonalt[0];
            float[] lon = latlonalt[1];
            float[] alt = latlonalt[2];
            double minDistance = Double.MAX_VALUE;
            double minAngle = 0.0;
            double lastDistance = 0.0;
            double lastAngle = 0.0;
            double segmentAngle = this.angles[0];
            double len = this.lenToPoint[0];
            double maxDataDistance = Double.MAX_VALUE;
            try {
                maxDataDistance = TransectDisplay.this.getMaxDataDistance().getValue(CommonUnits.KILOMETER);
                if (Double.isNaN(maxDataDistance)) {
                    maxDataDistance = Double.MAX_VALUE;
                }
            }
            catch (Exception e) {
                maxDataDistance = Double.MAX_VALUE;
            }
            for (int i = 0; i < numpoints; ++i) {
                if (this.numLinePoints == 2) {
                    Bearing workBearing = Bearing.calculateBearing(linePoints[0][0], linePoints[1][0], lat[i], lon[i]);
                    minDistance = workBearing.getDistance();
                    minAngle = workBearing.getAngle();
                } else {
                    minDistance = Double.MAX_VALUE;
                    double minDistToSegment = Double.MAX_VALUE;
                    for (int j = 0; j < this.numLinePoints - 1; ++j) {
                        Bearing workBearing = Bearing.calculateBearing(linePoints[0][j], linePoints[1][j], lat[i], lon[i]);
                        double dist = workBearing.getDistance();
                        double angle = workBearing.getAngle();
                        int segment = j < this.numLinePoints - 1 ? j : j - 1;
                        double thisSegmentAngle = this.angles[segment];
                        double segmentLength = this.distances[segment];
                        double distToThisSegment = Math.abs(dist * Math.sin(Math.toRadians(Math.abs(angle - thisSegmentAngle))));
                        double distAlongThisSegment = Math.abs(dist * Math.cos(Math.toRadians(Math.abs(angle - thisSegmentAngle))));
                        if (!(distAlongThisSegment <= segmentLength) || !(distToThisSegment < minDistToSegment)) continue;
                        minDistToSegment = distToThisSegment;
                        minAngle = angle;
                        minDistance = dist;
                        segmentAngle = this.angles[segment];
                        len = this.lenToPoint[segment];
                    }
                }
                double distToSegment = minDistance * Math.sin(Math.toRadians(Math.abs(minAngle - segmentAngle)));
                if (Math.abs(distToSegment) < maxDataDistance) {
                    double distAlongSegment = minDistance * Math.cos(Math.toRadians(Math.abs(minAngle - segmentAngle)));
                    x[i] = (float)(-1.0 + 2.0 * ((len + distAlongSegment) / this.totalLength));
                    y[i] = alt[i];
                    z[i] = 0.0f;
                    continue;
                }
                x[i] = Float.NaN;
                y[i] = Float.NaN;
                z[i] = Float.NaN;
            }
            if (numpoints > 100) {
                while (TransectDisplay.this.cacheInfos.size() > 10) {
                    TransectDisplay.this.cacheInfos.remove(0);
                }
                TransectDisplay.this.cacheInfos.add(new CacheInfo(latlonalt, xyz, linePoints));
            }
            this.call2("toReference(f)", numpoints);
            return xyz;
        }

        @Override
        public double[][] toReference(double[][] latlonalt) throws VisADException {
            if (latlonalt == null || latlonalt[0].length < 1) {
                return latlonalt;
            }
            int numpoints = latlonalt[0].length;
            this.checkForNewLine();
            float[][] linePoints = this.transect.getSamples(false);
            double[][] xyz = new double[3][numpoints];
            this.call1("toReference(d)", numpoints);
            double[] x = xyz[0];
            double[] y = xyz[1];
            double[] z = xyz[2];
            double[] lat = latlonalt[0];
            double[] lon = latlonalt[1];
            double[] alt = latlonalt[2];
            double minDistance = Double.MAX_VALUE;
            double minAngle = 0.0;
            double lastDistance = 0.0;
            double lastAngle = 0.0;
            double segmentAngle = this.angles[0];
            double len = this.lenToPoint[0];
            double maxDataDistance = Double.MAX_VALUE;
            try {
                maxDataDistance = TransectDisplay.this.getMaxDataDistance().getValue(CommonUnits.KILOMETER);
                if (Double.isNaN(maxDataDistance)) {
                    maxDataDistance = Double.MAX_VALUE;
                }
            }
            catch (Exception e) {
                maxDataDistance = Double.MAX_VALUE;
            }
            for (int i = 0; i < numpoints; ++i) {
                if (this.numLinePoints == 2) {
                    Bearing workBearing = Bearing.calculateBearing(linePoints[0][0], linePoints[1][0], lat[i], lon[i]);
                    minDistance = workBearing.getDistance();
                    minAngle = workBearing.getAngle();
                } else {
                    boolean closestSegment = false;
                    minDistance = Double.MAX_VALUE;
                    double minDistToSegment = Double.MAX_VALUE;
                    for (int j = 0; j < this.numLinePoints - 1; ++j) {
                        Bearing workBearing = Bearing.calculateBearing(linePoints[0][j], linePoints[1][j], lat[i], lon[i]);
                        double dist = workBearing.getDistance();
                        double angle = workBearing.getAngle();
                        int segment = j < this.numLinePoints - 1 ? j : j - 1;
                        double thisSegmentAngle = this.angles[segment];
                        double segmentLength = this.distances[segment];
                        double distToThisSegment = Math.abs(dist * Math.sin(Math.toRadians(Math.abs(angle - thisSegmentAngle))));
                        double distAlongThisSegment = Math.abs(dist * Math.cos(Math.toRadians(Math.abs(angle - thisSegmentAngle))));
                        if (!(distAlongThisSegment <= segmentLength) || !(distToThisSegment < minDistToSegment)) continue;
                        minDistToSegment = distToThisSegment;
                        minAngle = angle;
                        minDistance = dist;
                        segmentAngle = this.angles[segment];
                        len = this.lenToPoint[segment];
                    }
                }
                double distToSegment = minDistance * Math.sin(Math.toRadians(Math.abs(minAngle - segmentAngle)));
                if (Math.abs(distToSegment) < maxDataDistance) {
                    double distAlongSegment = minDistance * Math.cos(Math.toRadians(Math.abs(minAngle - segmentAngle)));
                    x[i] = -1.0 + 2.0 * ((len + distAlongSegment) / this.totalLength);
                    y[i] = alt[i];
                    z[i] = 0.0;
                    continue;
                }
                x[i] = Double.NaN;
                y[i] = Double.NaN;
                z[i] = Double.NaN;
            }
            this.call2("toReference(d)", numpoints);
            return xyz;
        }

        @Override
        public double[][] fromReference(double[][] xyz) throws VisADException {
            this.checkForNewLine();
            int numpoints = xyz[0].length;
            double[][] latlonalt = new double[3][numpoints];
            float[][] linePoints = this.transect.getSamples(false);
            this.call1("fromReference(d)", numpoints);
            for (int i = 0; i < numpoints; ++i) {
                double dist = (xyz[0][i] + 1.0) / 2.0 * this.totalLength;
                int segment = 0;
                if (dist > this.totalLength) {
                    segment = this.numSegments - 1;
                } else if (dist > 0.0) {
                    for (int j = 1; j < this.lenToPoint.length; ++j) {
                        if (!(this.lenToPoint[j] > dist)) continue;
                        segment = j - 1;
                        break;
                    }
                }
                double distOnSegment = (dist - this.lenToPoint[segment]) / this.distances[segment];
                float startLat = linePoints[0][segment];
                float startLon = linePoints[1][segment];
                float deltaLat = linePoints[0][segment + 1] - startLat;
                float deltaLon = linePoints[1][segment + 1] - startLon;
                latlonalt[0][i] = (double)startLat + distOnSegment * (double)deltaLat;
                latlonalt[1][i] = (double)startLon + distOnSegment * (double)deltaLon;
                latlonalt[2][i] = xyz[1][i];
            }
            this.call2("fromReference(d)", numpoints);
            return latlonalt;
        }

        @Override
        public float[][] fromReference(float[][] xyz) throws VisADException {
            this.checkForNewLine();
            int numpoints = xyz[0].length;
            float[][] latlonalt = new float[3][numpoints];
            float[][] linePoints = this.transect.getSamples(false);
            this.call1("fromReference(f)", numpoints);
            for (int i = 0; i < numpoints; ++i) {
                double dist = (double)((xyz[0][i] + 1.0f) / 2.0f) * this.totalLength;
                int segment = 0;
                if (dist > this.totalLength) {
                    segment = this.numSegments - 1;
                } else if (dist > 0.0) {
                    for (int j = 1; j < this.lenToPoint.length; ++j) {
                        if (!(this.lenToPoint[j] > dist)) continue;
                        segment = j - 1;
                        break;
                    }
                }
                float distOnSegment = (float)((dist - this.lenToPoint[segment]) / this.distances[segment]);
                float startLat = linePoints[0][segment];
                float startLon = linePoints[1][segment];
                float deltaLat = linePoints[0][segment + 1] - startLat;
                float deltaLon = linePoints[1][segment + 1] - startLon;
                latlonalt[0][i] = startLat + distOnSegment * deltaLat;
                latlonalt[1][i] = startLon + distOnSegment * deltaLon;
                latlonalt[2][i] = xyz[1][i];
            }
            this.call2("fromReference(f)", numpoints);
            return latlonalt;
        }

        private void checkForNewLine() throws VisADException {
            Gridded2DSet llr = TransectDisplay.this.ensureLatLon(TransectDisplay.this.getTransect());
            if (!llr.equals(this.transect)) {
                this.transect = llr;
                this.precalculate();
            }
        }

        void call1(String msg, int numpoints) {
            if (numpoints > 10000) {
                Trace.call1("TransectCS." + msg, " numpoints = " + numpoints);
            }
        }

        void call2(String msg, int numpoints) {
            if (numpoints > 10000) {
                Trace.call2("TransectCS." + msg);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof TransectCoordinateSystem)) {
                return false;
            }
            TransectCoordinateSystem cs = (TransectCoordinateSystem)o;
            return cs.transect.equals(this.transect);
        }

        private void precalculate() throws VisADException {
            float[][] linePoints = this.transect.getSamples(false);
            this.numLinePoints = linePoints[0].length;
            this.numSegments = this.numLinePoints - 1;
            this.lenToPoint = new double[this.numLinePoints];
            this.distances = new double[this.numSegments];
            this.angles = new double[this.numSegments];
            this.lenToPoint[0] = 0.0;
            LatLonPointImpl startWorkPoint = new LatLonPointImpl();
            LatLonPointImpl endWorkPoint = new LatLonPointImpl();
            for (int i = 1; i < this.numLinePoints; ++i) {
                startWorkPoint.set(linePoints[0][i - 1], linePoints[1][i - 1]);
                endWorkPoint.set(linePoints[0][i], linePoints[1][i]);
                Bearing lineBearing = Bearing.calculateBearing(startWorkPoint, endWorkPoint);
                this.distances[i - 1] = lineBearing.getDistance();
                this.angles[i - 1] = lineBearing.getAngle();
                this.lenToPoint[i] = this.lenToPoint[i - 1] + this.distances[i - 1];
            }
            this.totalLength = this.lenToPoint[this.numLinePoints - 1];
        }
    }

    private static class CacheInfo {
        float[][] lla;
        float[][] xyz;
        float[][] linePoints;

        public CacheInfo(float[][] lla, float[][] linePoints) {
            this.lla = lla;
            this.linePoints = linePoints;
        }

        public CacheInfo(float[][] lla, float[][] xyz, float[][] linePoints) {
            this.lla = Misc.cloneArray(lla);
            this.xyz = Misc.cloneArray(xyz);
            this.linePoints = Misc.cloneArray(linePoints);
        }

        public String toString() {
            return "CacheInfo:" + this.lla[0].length;
        }

        public void debug(CacheInfo that) {
            System.err.println("debug:" + Misc.arraysEquals(this.lla, that.lla) + " " + Misc.arraysEquals(this.linePoints, that.linePoints));
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheInfo)) {
                return false;
            }
            CacheInfo that = (CacheInfo)o;
            return Misc.arraysEquals(this.lla, that.lla) && Misc.arraysEquals(this.linePoints, that.linePoints);
        }
    }

    static class KeyboardBehaviorWrapper3D
    extends KeyboardBehaviorJ3D {
        KeyboardBehavior behavior;

        public KeyboardBehaviorWrapper3D(DisplayRendererJ3D rend, KeyboardBehavior behavior) {
            super(rend);
            this.behavior = behavior;
        }

        @Override
        public void mapKeyToFunction(int function, int keycode, int modifiers) {
            if (this.behavior != null) {
                this.behavior.mapKeyToFunction(function, keycode, modifiers);
            }
        }

        @Override
        public void processKeyEvent(KeyEvent event) {
            this.behavior.processKeyEvent(event);
        }

        @Override
        public void execFunction(int function) {
            this.behavior.execFunction(function);
        }
    }
}

