/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.unidata.util.StringUtil;
import ucar.unidata.view.geoloc.MapProjectionDisplay;
import ucar.unidata.view.sounding.RealReadout;
import visad.Real;

public class RangeAndBearingReadout
extends JPanel {
    private MapProjectionDisplay mapDisplay;
    private RealReadout bearingReadout;
    private RealReadout rangeReadout;
    private PropertyChangeListener rangeChangeListener;
    private PropertyChangeListener bearingChangeListener;
    private JLabel valueDisplay;
    private boolean myOwnLabel = true;
    private boolean active = true;
    private String rangeName = "Range";
    private String bearingName = "Bearing";

    public RangeAndBearingReadout(MapProjectionDisplay mapDisplay) {
        this(mapDisplay, null);
    }

    public RangeAndBearingReadout(MapProjectionDisplay mapDisplay, JLabel label) {
        this(mapDisplay, label, null, null);
    }

    public RangeAndBearingReadout(MapProjectionDisplay mapDisplay, String rangeName, String bearingName) {
        this(mapDisplay, null, rangeName, bearingName);
    }

    public RangeAndBearingReadout(MapProjectionDisplay mapDisplay, JLabel label, String rangeName, String bearingName) {
        this.mapDisplay = mapDisplay;
        this.setLayout(new FlowLayout(0));
        if (rangeName != null) {
            this.rangeName = rangeName;
        }
        if (bearingName != null) {
            this.bearingName = bearingName;
        }
        if (label != null) {
            this.valueDisplay = label;
            this.myOwnLabel = false;
        } else {
            this.valueDisplay = new JLabel(rangeName + ": " + bearingName + ": ", 2);
            this.add(this.valueDisplay);
        }
        this.rangeReadout = new RealReadout();
        this.rangeReadout.setFormat(new DecimalFormat("###.0"));
        this.rangeReadout.setSpecifiedName(rangeName);
        this.rangeReadout.setNameUse(1);
        this.rangeReadout.addPropertyChangeListener("numericString", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                RangeAndBearingReadout.this.setLabelText();
            }
        });
        this.bearingReadout = new RealReadout();
        this.bearingReadout.setFormat(new DecimalFormat("###.0"));
        this.bearingReadout.setSpecifiedName(bearingName);
        this.bearingReadout.setNameUse(1);
        this.bearingReadout.addPropertyChangeListener("numericString", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                RangeAndBearingReadout.this.setLabelText();
            }
        });
        this.rangeChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                RangeAndBearingReadout.this.rangeReadout.setReal((Real)event.getNewValue());
            }
        };
        this.bearingChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                RangeAndBearingReadout.this.bearingReadout.setReal((Real)event.getNewValue());
            }
        };
        this.setMapProjectionDisplay(mapDisplay);
    }

    public void setMapProjectionDisplay(MapProjectionDisplay mapDisplay) {
        MapProjectionDisplay oldNavDisplay = this.mapDisplay;
        if (oldNavDisplay != null) {
            oldNavDisplay.removePropertyChangeListener(this.rangeChangeListener);
            oldNavDisplay.removePropertyChangeListener(this.bearingChangeListener);
        }
        this.mapDisplay = mapDisplay;
        this.mapDisplay.addPropertyChangeListener("cursorRange", this.rangeChangeListener);
        this.mapDisplay.addPropertyChangeListener("cursorBearing", this.bearingChangeListener);
    }

    public void setActive(boolean value) {
        this.active = value;
        if (!this.active && this.valueDisplay != null) {
            this.valueDisplay.setText(" ");
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public String getRangeName() {
        return this.rangeName;
    }

    public void setRangeName(String newName) {
        if (newName != null) {
            this.rangeName = newName;
        }
    }

    public String getBearingName() {
        return this.bearingName;
    }

    public void setBearingName(String newName) {
        if (newName != null) {
            this.bearingName = newName;
        }
    }

    private void setLabelText() {
        if (!this.active) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(" ");
        buf.append(this.getRangeName());
        buf.append(": ");
        buf.append(StringUtil.padLeft(this.rangeReadout.getNumericString(), 6));
        buf.append(" ");
        buf.append(this.getBearingName());
        buf.append(": ");
        buf.append(StringUtil.padLeft(this.bearingReadout.getNumericString(), 6));
        String text = buf.toString();
        this.valueDisplay.setText(text);
        if (this.myOwnLabel) {
            FontMetrics fm = this.valueDisplay.getFontMetrics(this.valueDisplay.getFont());
            this.valueDisplay.setPreferredSize(new Dimension(fm.stringWidth(text), fm.getHeight()));
        }
    }
}

