/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.gis.maps.MapData;
import ucar.unidata.ui.Help;
import ucar.unidata.ui.IndependentDialog;
import ucar.unidata.ui.PersistentObject;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.Format;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.ListenerManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.view.NPController;
import ucar.unidata.view.Renderer;
import ucar.unidata.view.geoloc.JTableProjection;
import ucar.unidata.view.geoloc.NavigatedPanel;
import ucar.unidata.view.geoloc.NewProjectionEvent;
import ucar.unidata.view.geoloc.NewProjectionListener;
import ucar.unidata.xml.XmlEncoder;

public class ProjectionManager
implements ActionListener {
    public static final String PROPERTY_CHANGE = "ProjectionImpl";
    private static List defaultProjections = new ArrayList();
    private List maps;
    private List defaultMaps;
    private ProjectionImpl current;
    private ListenerManager lm;
    private RootPaneContainer parent;
    private boolean eventsOK = false;
    private JTableProjection projTable;
    private NPController npViewControl;
    private NavigatedPanel mapViewPanel;
    private JDialog viewDialog;
    private JLabel mapLabel;
    private JComponent contents;
    private NewProjectionDialog newDialog = null;
    private static final String DEFAULT_NAME = "Projection";
    private String helpId = "Projection";
    private static final Class[] VOIDCLASSARG = new Class[0];
    private static final Object[] VOIDOBJECTARG = new Object[0];
    private static boolean debug = false;
    private static boolean debugBeans = false;

    public static void addDefaultProjection(String projectionClass) {
        ProjectionManager.getDefaultProjections().add(projectionClass);
    }

    public static List getDefaultProjections() {
        if (defaultProjections.size() == 0) {
            defaultProjections.add("ucar.unidata.geoloc.projection.LatLonProjection");
            defaultProjections.add("ucar.unidata.geoloc.projection.LambertConformal");
            defaultProjections.add("ucar.unidata.geoloc.projection.TransverseMercator");
            defaultProjections.add("ucar.unidata.geoloc.projection.Stereographic");
            defaultProjections.add("ucar.unidata.geoloc.projection.Mercator");
            defaultProjections.add("ucar.unidata.geoloc.projection.AlbersEqualArea");
            defaultProjections.add("ucar.unidata.geoloc.projection.LambertAzimuthalEqualArea");
            defaultProjections.add("ucar.unidata.geoloc.projection.Orthographic");
            defaultProjections.add("ucar.unidata.geoloc.projection.VerticalPerspectiveView");
        }
        return defaultProjections;
    }

    public ProjectionManager() {
        this(null, null, true);
    }

    public ProjectionManager(RootPaneContainer parent, Object dummy) {
        this(parent, null);
    }

    public void storePersistentData() {
    }

    public ProjectionManager(RootPaneContainer parent) {
        this(parent, null);
    }

    public ProjectionManager(RootPaneContainer parent, boolean makeDialog) {
        this(parent, null, makeDialog);
    }

    public ProjectionManager(RootPaneContainer parent, List projections) {
        this(parent, projections, true);
    }

    public ProjectionManager(RootPaneContainer parent, List projections, boolean makeDialog) {
        this(parent, projections, makeDialog, DEFAULT_NAME);
    }

    public ProjectionManager(RootPaneContainer parent, List projections, boolean makeDialog, String helpId) {
        this(parent, projections, makeDialog, helpId, null);
    }

    public ProjectionManager(RootPaneContainer parent, List projections, boolean makeDialog, String helpId, List maps) {
        this.helpId = helpId;
        this.maps = maps;
        this.parent = parent;
        this.lm = new ListenerManager("java.beans.PropertyChangeListener", "java.beans.PropertyChangeEvent", "propertyChange");
        this.npViewControl = new NPController();
        if (maps == null) {
            maps = this.getDefaultMaps();
        }
        for (int mapIdx = 0; mapIdx < maps.size(); ++mapIdx) {
            MapData mapData = (MapData)maps.get(mapIdx);
            if (!mapData.getVisible()) continue;
            this.npViewControl.addMap(mapData.getSource(), mapData.getColor());
        }
        this.mapViewPanel = this.npViewControl.getNavigatedPanel();
        this.mapViewPanel.setPreferredSize(new Dimension(250, 250));
        this.mapViewPanel.setToolTipText("Shows the default zoom of the current projection");
        this.mapViewPanel.setChangeable(false);
        if (projections == null || projections.size() == 0) {
            projections = ProjectionManager.makeDefaultProjections();
        }
        this.projTable = new JTableProjection(this, projections);
        JScrollPane listContents = new JScrollPane(this.projTable);
        JPanel buttons = GuiUtils.hbox((Component)GuiUtils.makeButton("Edit", this, "doEdit"), (Component)GuiUtils.makeButton("New", this, "doNew"), (Component)GuiUtils.makeButton("Export", this, "doExport"), GuiUtils.makeButton("Delete", this, "doDelete"));
        this.mapLabel = new JLabel(" ");
        JPanel leftPanel = GuiUtils.inset((Component)GuiUtils.topCenter(this.mapLabel, this.mapViewPanel), 5);
        JPanel rightPanel = GuiUtils.topCenter(buttons, listContents);
        rightPanel = GuiUtils.inset((Component)rightPanel, 5);
        this.contents = GuiUtils.inset((Component)GuiUtils.hbox((Component)leftPanel, rightPanel), 5);
        this.current = this.projTable.getSelected();
        if (null != this.current) {
            this.setWorkingProjection(this.current);
            this.projTable.setCurrentProjection(this.current);
            this.mapLabel.setText(this.current.toString());
        }
        this.projTable.addNewProjectionListener(new NewProjectionListener(){

            @Override
            public void actionPerformed(NewProjectionEvent e) {
                if (e.getProjection() != null) {
                    ProjectionManager.this.setWorkingProjection(e.getProjection());
                }
            }
        });
        this.eventsOK = true;
        if (makeDialog) {
            JPanel buttPanel = GuiUtils.makeApplyOkHelpCancelButtons(this);
            this.contents = GuiUtils.centerBottom(this.contents, buttPanel);
            this.viewDialog = GuiUtils.createDialog(GuiUtils.getApplicationTitle() + "Projection Manager", false);
            this.viewDialog.getContentPane().add(this.contents);
            this.viewDialog.pack();
            Msg.translateTree(this.viewDialog);
            this.viewDialog.setLocation(100, 100);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
            this.accept();
        }
        if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.close();
        }
        if (cmd.equals(GuiUtils.CMD_HELP)) {
            Help.getDefaultHelp().gotoTarget(this.helpId);
        }
    }

    public void close() {
        if (this.viewDialog != null) {
            this.viewDialog.setVisible(false);
        }
    }

    public void doExport() {
        List projections = this.getProjections();
        Vector<ProjectionImpl> v = new Vector<ProjectionImpl>();
        for (int i = 0; i < projections.size(); ++i) {
            ProjectionImpl projection = (ProjectionImpl)projections.get(i);
            v.add(projection);
        }
        JList jlist = new JList(v);
        JPanel contents = GuiUtils.topCenter(GuiUtils.cLabel("Please select the projections you want to export"), GuiUtils.makeScrollPane(jlist, 200, 400));
        if (!GuiUtils.showOkCancelDialog(null, "Export Projections", contents, null)) {
            return;
        }
        Object[] items = jlist.getSelectedValues();
        if (items == null || items.length == 0) {
            return;
        }
        ArrayList<Object> selected = new ArrayList<Object>();
        for (int i = 0; i < items.length; ++i) {
            selected.add(items[i]);
        }
        String xml = new XmlEncoder().toXml(selected);
        String filename = FileManager.getWriteFile(FileManager.FILTER_XML, ".xml");
        if (filename == null) {
            return;
        }
        try {
            IOUtil.writeFile(filename, xml);
        }
        catch (Exception exc) {
            LogUtil.logException("Writing projection file: " + filename, exc);
        }
    }

    public static List makeDefaultProjections() {
        ArrayList<ProjectionImpl> defaults = new ArrayList<ProjectionImpl>();
        List classNames = ProjectionManager.getDefaultProjections();
        for (int i = 0; i < classNames.size(); ++i) {
            String className = (String)classNames.get(i);
            try {
                Class projClass = Misc.findClass(className);
                ProjectionImpl pi = (ProjectionImpl)projClass.newInstance();
                pi.setName("Default " + pi.getProjectionTypeLabel());
                defaults.add(pi);
                continue;
            }
            catch (Exception ee) {
                System.err.println("Error creating default projection: " + className);
                ee.printStackTrace();
            }
        }
        return defaults;
    }

    public void setMaps(List maps) {
        this.maps = maps;
    }

    public void setProjections(List list) {
        this.projTable.setProjections(list);
    }

    public List getProjections() {
        return this.projTable.getProjections();
    }

    public String getManagerName() {
        return GuiUtils.getApplicationTitle() + "Projection Manager";
    }

    public Class getPersistentObjectClass() {
        return ProjectionImpl.class;
    }

    public Component getContents() {
        return this.contents;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.lm.addListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.lm.removeListener(l);
    }

    public JDialog getDialog() {
        return this.viewDialog;
    }

    public void show() {
        if (this.viewDialog != null) {
            this.viewDialog.setVisible(true);
        }
    }

    public void destroy() {
        if (this.viewDialog != null) {
            this.viewDialog.dispose();
            this.viewDialog = null;
        }
    }

    public PersistentObject getSelection() {
        return (PersistentObject)((Object)this.current);
    }

    public void setSelection(PersistentObject select) {
        this.setWorkingProjection((ProjectionImpl)((Object)select));
    }

    public void accept() {
        ProjectionRect bb = this.mapViewPanel.getMapArea();
        if (bb == null || this.current == null) {
            return;
        }
        this.current.setDefaultMapArea(new ProjectionRect(bb));
        this.lm.sendEvent(new PropertyChangeEvent(this, PROPERTY_CHANGE, null, this.current));
    }

    public boolean contains(String id) {
        return this.projTable.contains(id);
    }

    public void doDelete() {
        this.projTable.deleteSelected();
    }

    public void doEdit() {
        this.edit(false);
    }

    public void doNew() {
        this.edit(true);
    }

    public void edit(boolean isNew) {
        String name = isNew || this.current == null ? "" : this.current.getName().trim();
        this.getEditor().setDoingNewProjection(isNew, name);
        if (isNew) {
            this.getEditor().setDefaultProjection();
        } else {
            this.getEditor().setProjection(this.current);
        }
        this.getEditor().setVisible(true);
    }

    public void saveProjection(ProjectionImpl proj) {
        ProjectionImpl newProj = proj.constructCopy();
        newProj.setName("");
        this.setWorkingProjection(newProj);
        this.getEditor().setProjection(this.current);
        this.getEditor().setVisible(true);
    }

    private void setMap(Renderer map) {
        if (map != null) {
            this.npViewControl.setRenderer(map);
            this.getEditor().setMap(map);
        }
    }

    private NewProjectionDialog getEditor() {
        if (null == this.newDialog) {
            this.newDialog = this.parent == null ? new NewProjectionDialog(this.viewDialog) : new NewProjectionDialog(this.parent);
        }
        return this.newDialog;
    }

    private void setWorkingProjection(ProjectionImpl proj) {
        if (proj == null) {
            return;
        }
        if (debug) {
            System.out.println("ProjManager.setWorkingProjection " + proj);
        }
        this.current = proj.constructCopy();
        if (debug) {
            System.out.println("ProjManager.setWorkingProjection map area = " + this.current.getDefaultMapArea());
        }
        if (this.current != null) {
            this.mapLabel.setText(this.current.toString());
        }
        this.npViewControl.setProjectionImpl(this.current);
    }

    public static void main(String[] args) {
        ProjectionManager pm = new ProjectionManager();
        pm.show();
    }

    private List getDefaultMaps() {
        if (this.defaultMaps == null) {
            this.defaultMaps = new ArrayList();
            this.defaultMaps.add(new MapData("/auxdata/maps/OUTLSUPU", "U.S. State Outlines", Color.blue, 1.0f, 0));
            this.defaultMaps.add(new MapData("/auxdata/maps/Countries.zip", "World Country Outlines", Color.blue, 1.0f, 0));
        }
        return this.defaultMaps;
    }

    private class ProjectionParam {
        Method reader;
        Method writer;
        String name;
        Class paramType;
        JTextField tf;

        ProjectionParam(String name, Method reader, Method writer, Class paramType) {
            this.name = name;
            this.reader = reader;
            this.writer = writer;
            this.paramType = paramType;
        }

        public String toString() {
            return this.paramType.getName() + " " + this.name + " " + (this.reader == null ? "-" : "R") + (this.writer == null ? "-" : "W");
        }

        void setTextField(JTextField tf) {
            this.tf = tf;
        }

        JTextField getTextField() {
            return this.tf;
        }
    }

    private class ProjectionClass {
        Class projClass;
        String name;
        List paramList = new ArrayList();

        ProjectionClass(String className) throws ClassNotFoundException, IntrospectionException {
            this(Misc.findClass(className));
        }

        ProjectionClass(Class pc) throws ClassNotFoundException, IntrospectionException {
            Class stopClass;
            this.projClass = pc;
            try {
                stopClass = Misc.findClass("ucar.unidata.geoloc.ProjectionImpl");
            }
            catch (Exception ee) {
                System.err.println("constructParamInput failed ");
                stopClass = null;
            }
            BeanInfo info = Introspector.getBeanInfo(this.projClass, stopClass);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            if (debugBeans) {
                System.out.print("Bean Properties for class " + this.projClass);
                if (props == null || props.length == 0) {
                    System.out.println("none");
                    return;
                }
                System.out.println("");
            }
            for (int i = 0; i < props.length; ++i) {
                PropertyDescriptor pd = props[i];
                Method reader = pd.getReadMethod();
                Method writer = pd.getWriteMethod();
                if (reader == null || writer == null || pd.getName().equals("name") || pd.getName().equals("defaultMapArea")) continue;
                ProjectionParam p = new ProjectionParam(pd.getName(), reader, writer, pd.getPropertyType());
                this.paramList.add(p);
                if (!debugBeans) continue;
                System.out.println("  -->" + p);
            }
            ProjectionImpl project = this.makeDefaultProjection();
            if (null == project) {
                this.name = "none";
                return;
            }
            try {
                Method m = this.projClass.getMethod("getProjectionTypeLabel", VOIDCLASSARG);
                this.name = (String)m.invoke((Object)project, VOIDOBJECTARG);
            }
            catch (NoSuchMethodException ee) {
                System.err.println("ProjectionManager: class " + this.projClass + " does not have method getProjectionTypeLabel()");
                throw new ClassNotFoundException();
            }
            catch (SecurityException ee) {
                System.err.println("ProjectionManager: class " + this.projClass + " got SecurityException on getProjectionTypeLabel()" + ee);
                throw new ClassNotFoundException();
            }
            catch (Exception ee) {
                System.err.println("ProjectionManager: class " + this.projClass + " Exception when invoking getProjectionTypeLabel()" + ee);
                throw new ClassNotFoundException();
            }
        }

        private ProjectionImpl makeDefaultProjection() {
            try {
                Constructor c = this.projClass.getConstructor(VOIDCLASSARG);
                return (ProjectionImpl)c.newInstance(VOIDOBJECTARG);
            }
            catch (Exception ee) {
                System.err.println("ProjectionManager makeDefaultProjection failed to construct class " + this.projClass);
                System.err.println("   " + ee);
                return null;
            }
        }

        public String toString() {
            return this.name;
        }
    }

    private class NewProjectionDialog
    extends IndependentDialog {
        private ProjectionImpl editProjection;
        private ListenerManager lm;
        private String startingName;
        private boolean doingNew;
        private JLabel typeLabel;
        private JComboBox projClassCB;
        private JPanel paramPanel;
        private JTextField nameTF;
        private NPController npEditControl;
        private NavigatedPanel mapEditPanel;
        private Border standardBorder;

        NewProjectionDialog(RootPaneContainer parent) {
            super(parent, true, "Define/Edit Projection");
            this.startingName = null;
            this.doingNew = true;
            this.standardBorder = new EtchedBorder();
            this.makeUI();
            this.setLocation(100, 100);
        }

        NewProjectionDialog(JDialog parent) {
            super(parent, true, "Define/Edit Projection");
            this.startingName = null;
            this.doingNew = true;
            this.standardBorder = new EtchedBorder();
            this.makeUI();
            this.setLocation(100, 100);
        }

        NewProjectionDialog(JFrame parent) {
            super(parent, true, "Define/Edit Projection");
            this.startingName = null;
            this.doingNew = true;
            this.standardBorder = new EtchedBorder();
            this.makeUI();
            this.setLocation(100, 100);
        }

        private void toggleMap(MapData mapData, boolean onOff) {
            if (onOff) {
                this.npEditControl.addMap(mapData.getSource(), mapData.getColor());
            } else {
                this.npEditControl.removeMap(mapData.getSource());
            }
        }

        void makeUI() {
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.setBorder(new LineBorder(Color.blue));
            this.getContentPane().add((Component)mainPanel, "Center");
            this.npEditControl = new NPController();
            this.mapEditPanel = this.npEditControl.getNavigatedPanel();
            this.mapEditPanel.setPreferredSize(new Dimension(250, 250));
            this.mapEditPanel.setSelectRegionMode(true);
            JToolBar navToolbar = this.mapEditPanel.getNavToolBar();
            navToolbar.setFloatable(false);
            JToolBar moveToolbar = this.mapEditPanel.getMoveToolBar();
            moveToolbar.setFloatable(false);
            JPanel toolbar = new JPanel();
            List localMaps = ProjectionManager.this.maps;
            if (localMaps == null) {
                localMaps = ProjectionManager.this.getDefaultMaps();
            }
            JMenu mapMenu = new JMenu("Maps");
            JMenuBar menuHolder = new JMenuBar();
            menuHolder.setBorder(null);
            menuHolder.add(mapMenu);
            toolbar.add(menuHolder);
            for (int mapIdx = 0; mapIdx < localMaps.size(); ++mapIdx) {
                final MapData mapData = (MapData)localMaps.get(mapIdx);
                final JCheckBoxMenuItem cbx = new JCheckBoxMenuItem(mapData.getDescription(), mapData.getVisible());
                if (mapData.getVisible()) {
                    this.toggleMap(mapData, true);
                }
                mapMenu.add(cbx);
                cbx.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent event) {
                        NewProjectionDialog.this.toggleMap(mapData, cbx.isSelected());
                    }
                });
            }
            GuiUtils.limitMenuSize(mapMenu, "Maps ", 20);
            toolbar.add(navToolbar);
            toolbar.add(moveToolbar);
            JPanel mapSide = new JPanel();
            mapSide.setLayout(new BorderLayout());
            TitledBorder mapBorder = new TitledBorder(this.standardBorder, "Edit Projection", 1, 2);
            mapSide.setBorder(mapBorder);
            mapSide.add((Component)toolbar, "North");
            mapSide.add((Component)this.mapEditPanel, "Center");
            mainPanel.add((Component)mapSide, "West");
            JLabel nameLabel = GuiUtils.rLabel("Name: ");
            this.nameTF = new JTextField(20);
            this.typeLabel = GuiUtils.rLabel("Type: ");
            this.projClassCB = new JComboBox();
            List classNames = ProjectionManager.getDefaultProjections();
            for (int i = 0; i < classNames.size(); ++i) {
                String className = (String)classNames.get(i);
                try {
                    this.projClassCB.addItem(new ProjectionClass(className));
                    continue;
                }
                catch (ClassNotFoundException ee) {
                    System.err.println("ProjectionManager failed on " + className + " " + ee);
                    continue;
                }
                catch (IntrospectionException ee) {
                    System.err.println("ProjectionManager failed on " + className + " " + ee);
                }
            }
            GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
            JPanel topPanel = GuiUtils.doLayout(new Component[]{nameLabel, this.nameTF, this.typeLabel, this.projClassCB}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
            this.paramPanel = new JPanel();
            this.paramPanel.setLayout(new BorderLayout());
            this.paramPanel.setBorder(new TitledBorder(this.standardBorder, "Projection Parameters", 1, 2));
            JPanel buttPanel = new JPanel();
            JButton acceptButton = new JButton("Save");
            JButton previewButton = new JButton("Preview");
            JButton cancelButton = new JButton("Cancel");
            buttPanel.add((Component)acceptButton, null);
            buttPanel.add((Component)previewButton, null);
            buttPanel.add((Component)cancelButton, null);
            JPanel mainBox = GuiUtils.topCenterBottom(topPanel, this.paramPanel, buttPanel);
            mainPanel.add((Component)mainBox, "Center");
            this.pack();
            this.projClassCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectionClass selectClass = (ProjectionClass)NewProjectionDialog.this.projClassCB.getSelectedItem();
                    NewProjectionDialog.this.setProjection(selectClass.makeDefaultProjection());
                }
            });
            acceptButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewProjectionDialog.this.accept();
                }
            });
            previewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProjectionClass projClass = NewProjectionDialog.this.findProjectionClass(NewProjectionDialog.this.editProjection);
                    if (null != projClass) {
                        NewProjectionDialog.this.setProjFromDialog(projClass, NewProjectionDialog.this.editProjection);
                        NewProjectionDialog.this.setProjection(NewProjectionDialog.this.editProjection);
                    }
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewProjectionDialog.this.setVisible(false);
                }
            });
        }

        public void setProjection(ProjectionImpl proj) {
            ProjectionClass pc = this.findProjectionClass(proj);
            if (pc == null) {
                System.out.println("Projection Manager: cant find Class for " + proj);
                return;
            }
            if (debug) {
                System.out.println(" NPDialog set projection " + proj);
            }
            this.setProjectionClass(pc, proj);
            this.npEditControl.setProjectionImpl(proj);
            this.startingName = new String(proj.getName());
        }

        void setDoingNewProjection(boolean v, String name) {
            this.doingNew = v;
            this.nameTF.setText(name);
            if (this.typeLabel != null) {
                // empty if block
            }
        }

        void setDefaultProjection() {
            ProjectionClass selectedClass = (ProjectionClass)this.projClassCB.getItemAt(0);
            if (selectedClass == null) {
                System.out.println("Projection Manager: no Default Projection available");
                return;
            }
            ProjectionImpl proj = selectedClass.makeDefaultProjection();
            this.setProjection(proj);
            this.startingName = "";
        }

        public void setMap(Renderer map) {
            if (map != null) {
                this.npEditControl.setRenderer(map);
            }
        }

        private void accept() {
            ProjectionClass projClass = this.findProjectionClass(this.editProjection);
            if (null == projClass) {
                System.out.println("Projection Manager accept: findProjectionClass failed" + this.editProjection);
                return;
            }
            this.setProjFromDialog(projClass, this.editProjection);
            ProjectionRect mapArea = this.mapEditPanel.getSelectedRegion();
            if (mapArea == null) {
                mapArea = this.mapEditPanel.getMapArea();
            }
            this.editProjection.setDefaultMapArea(mapArea);
            if (debug) {
                System.out.println("Projection Manager accept bb =" + this.editProjection.getDefaultMapArea());
            }
            ProjectionImpl newProj = this.editProjection.constructCopy();
            if (ProjectionManager.this.viewDialog != null) {
                // empty if block
            }
            if (ProjectionManager.this.contains(newProj.getName())) {
                ProjectionManager.this.projTable.replaceProjection(newProj);
            } else {
                ProjectionManager.this.projTable.addProjection(newProj);
            }
            ProjectionManager.this.setWorkingProjection(newProj);
            this.setVisible(false);
        }

        private ProjectionClass findProjectionClass(Projection proj) {
            Class<?> want = proj.getClass();
            ComboBoxModel projClassList = this.projClassCB.getModel();
            for (int i = 0; i < projClassList.getSize(); ++i) {
                ProjectionClass pc = (ProjectionClass)projClassList.getElementAt(i);
                if (!want.equals(pc.projClass)) continue;
                return pc;
            }
            return null;
        }

        private void setProjectionClass(ProjectionClass pc, ProjectionImpl proj) {
            if (null == proj || null == pc) {
                return;
            }
            if (debug) {
                System.out.println("Projection setProjectionClass= " + proj);
            }
            this.setFieldsWithClassParams(pc);
            this.editProjection = proj.constructCopy();
            this.putProjInDialog(pc, this.editProjection);
            if (debug) {
                System.out.println("Projection setProjectionClass ok ");
            }
            this.invalidate();
            this.validate();
        }

        private void setFieldsWithClassParams(ProjectionClass projClass) {
            String want = projClass.toString();
            for (int i = 0; i < this.projClassCB.getItemCount(); ++i) {
                ProjectionClass pc = (ProjectionClass)this.projClassCB.getItemAt(i);
                if (!pc.toString().equals(want)) continue;
                this.projClassCB.setSelectedItem(pc);
                break;
            }
            this.paramPanel.removeAll();
            this.paramPanel.setVisible(0 < projClass.paramList.size());
            ArrayList<JComponent> widgets = new ArrayList<JComponent>();
            for (int i = 0; i < projClass.paramList.size(); ++i) {
                ProjectionParam pp = (ProjectionParam)projClass.paramList.get(i);
                String name = pp.name;
                String text = "";
                for (int cIdx = 0; cIdx < name.length(); ++cIdx) {
                    char c = name.charAt(cIdx);
                    if (cIdx == 0) {
                        c = Character.toUpperCase(c);
                    } else if (Character.isUpperCase(c)) {
                        text = text + " ";
                        c = Character.toLowerCase(c);
                    }
                    text = text + c;
                }
                widgets.add(GuiUtils.rLabel(text + ": "));
                JTextField tf = new JTextField();
                pp.setTextField(tf);
                tf.setColumns(12);
                widgets.add(tf);
            }
            GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
            JPanel widgetPanel = GuiUtils.doLayout(widgets, 2, GuiUtils.WT_N, GuiUtils.WT_N);
            this.paramPanel.add("North", widgetPanel);
            this.paramPanel.add("Center", GuiUtils.filler());
        }

        private void putProjInDialog(ProjectionClass projClass, Projection proj) {
            for (int i = 0; i < projClass.paramList.size(); ++i) {
                Double value;
                ProjectionParam pp;
                block4: {
                    pp = (ProjectionParam)projClass.paramList.get(i);
                    try {
                        if (debugBeans) {
                            System.out.println("Projection putProjInDialog invoke reader on " + pp);
                        }
                        value = (Double)pp.reader.invoke((Object)proj, VOIDOBJECTARG);
                        if (!debugBeans) break block4;
                        System.out.println("Projection putProjInDialog value " + value);
                    }
                    catch (Exception ee) {
                        System.err.println("ProjectionManager: putProjInDialog failed  invoking read " + pp.name + " class " + projClass);
                        continue;
                    }
                }
                String valstr = Format.d(value, 5);
                pp.getTextField().setText(valstr);
            }
        }

        private void setProjFromDialog(ProjectionClass projClass, ProjectionImpl proj) {
            proj.setName(this.nameTF.getText().trim());
            for (int i = 0; i < projClass.paramList.size(); ++i) {
                ProjectionParam pp = (ProjectionParam)projClass.paramList.get(i);
                try {
                    String valstr = pp.getTextField().getText();
                    Double valdub = new Double(valstr);
                    Object[] args = new Object[]{valdub};
                    if (debugBeans) {
                        System.out.println("Projection setProjFromDialog invoke writer on " + pp);
                    }
                    pp.writer.invoke((Object)proj, args);
                    continue;
                }
                catch (Exception ee) {
                    System.err.println("ProjectionManager: setProjParams failed  invoking write " + pp.name + " class " + projClass);
                }
            }
        }
    }
}

