/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.ui.BAMutil;
import ucar.unidata.ui.Rubberband;
import ucar.unidata.ui.RubberbandRectangle;
import ucar.unidata.ui.drawing.Glyph;
import ucar.unidata.util.Debug;
import ucar.unidata.util.Format;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.ListenerManager;
import ucar.unidata.view.geoloc.CursorMoveEvent;
import ucar.unidata.view.geoloc.CursorMoveEventListener;
import ucar.unidata.view.geoloc.Navigation;
import ucar.unidata.view.geoloc.NewMapAreaListener;
import ucar.unidata.view.geoloc.PickEvent;
import ucar.unidata.view.geoloc.PickEventListener;

public class NavigatedPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static Color disabledColor = new Color(230, 230, 230);
    public AbstractAction setReferenceAction;
    private Navigation navigate = null;
    private ProjectionImpl project = null;
    private ListenerManager lmPick;
    private ListenerManager lmMove;
    private boolean selectRegionMode = false;
    private String regionDragPoint = null;
    private Rectangle2D screenRegion;
    private ProjectionRect selectedRegion;
    private ProjectionRect selectedRegionBounds;
    private BufferedImage bImage = null;
    private Color backColor = Color.white;
    private JLabel statusLabel = null;
    private myImageObserver imageObs = new myImageObserver();
    private NToolBar toolbar = null;
    private JMenu menu;
    private Timer redrawTimer = null;
    private boolean changedSinceDraw = true;
    private boolean changeable = true;
    protected int startX;
    protected int startY;
    protected int deltax;
    protected int deltay;
    private boolean draggingMode = false;
    private boolean zoomingMode = false;
    private Rubberband zoomRB;
    private boolean setReferenceMode = false;
    private boolean hasReference = false;
    private ProjectionPointImpl refWorld = new ProjectionPointImpl();
    private LatLonPointImpl refLatLon = new LatLonPointImpl();
    private Point2D refScreen = new Point2D.Double();
    private int referenceSize = 12;
    private Cursor referenceCursor = null;
    private static final int REFERENCE_CURSOR = -100;
    private StringBuffer sbuff = new StringBuffer(100);
    private ProjectionPointImpl workW = new ProjectionPointImpl();
    private LatLonPointImpl workL = new LatLonPointImpl();
    private Rectangle myBounds = new Rectangle();
    private ProjectionRect boundingBox = new ProjectionRect();
    private DropTarget dropTarget;
    private int repaintCount = 0;
    private final boolean debugDraw = false;
    private final boolean debugEvent = false;
    private final boolean debugThread = false;
    private final boolean debugStatus = false;
    private final boolean debugTime = false;
    private final boolean debugPrinting = false;
    private final boolean debugBB = false;
    private final boolean debugZoom = false;
    private final boolean debugBounds = false;
    private AbstractAction zoomIn;
    private AbstractAction zoomOut;
    private AbstractAction zoomDefault;
    private AbstractAction zoomBack;
    private AbstractAction moveUp;
    private AbstractAction moveDown;
    private AbstractAction moveLeft;
    private AbstractAction moveRight;

    public NavigatedPanel() {
        this.setDoubleBuffered(false);
        this.navigate = new Navigation();
        this.project = new LatLonProjection("Cyl.Eq");
        this.navigate.setMapArea(this.normalizeRectangle(this.project.getDefaultMapArea()));
        this.makeActions();
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                int notches = event.getWheelRotation();
                if (notches < 0) {
                    NavigatedPanel.this.doZoomIn();
                } else {
                    NavigatedPanel.this.doZoomOut();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NavigatedPanel.this.setNewBounds(NavigatedPanel.this.getBounds(), false);
            }
        });
        this.zoomRB = new RubberbandRectangle(this);
        this.lmMove = new ListenerManager("ucar.unidata.view.geoloc.CursorMoveEventListener", "ucar.unidata.view.geoloc.CursorMoveEvent", "actionPerformed");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setNewBounds(this.getBounds(), true);
        this.repaint();
    }

    public static Rectangle2D ProjRectToRectangle2D(ProjectionRect projRect) {
        double llx = projRect.getMinX();
        double lly = projRect.getMinY();
        double width = projRect.getWidth();
        double height = projRect.getHeight();
        return new Rectangle2D.Double(llx, lly, width, height);
    }

    public static Point2D ProjPointToPoint2D(ProjectionPointImpl ppi) {
        double x = ppi.getX();
        double y = ppi.getY();
        return new Point2D.Double(x, y);
    }

    private ListenerManager getLMPick() {
        if (this.lmPick == null) {
            this.lmPick = new ListenerManager("ucar.unidata.view.geoloc.PickEventListener", "ucar.unidata.view.geoloc.PickEvent", "actionPerformed");
        }
        return this.lmPick;
    }

    public void addCursorMoveEventListener(CursorMoveEventListener l) {
        this.lmMove.addListener(l);
    }

    public void removeCursorMoveEventListener(CursorMoveEventListener l) {
        this.lmMove.removeListener(l);
    }

    public void addPickEventListener(PickEventListener l) {
        this.getLMPick().addListener(l);
    }

    public void removePickEventListener(PickEventListener l) {
        this.getLMPick().removeListener(l);
    }

    public void addNewMapAreaListener(NewMapAreaListener l) {
        this.navigate.addNewMapAreaListener(l);
    }

    public void removeNewMapAreaListener(NewMapAreaListener l) {
        this.navigate.removeNewMapAreaListener(l);
    }

    public Color getBackgroundColor() {
        return this.isEnabled() ? this.backColor : disabledColor;
    }

    public Navigation getNavigation() {
        return this.navigate;
    }

    public ProjectionRect getMapArea() {
        return this.navigate.getMapArea(this.boundingBox);
    }

    public void setMapArea(ProjectionRect ma) {
        this.navigate.setMapArea(this.normalizeRectangle(ma));
    }

    public void setWorldCenterX(double wx_center) {
        this.navigate.setWorldCenterX(wx_center);
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public ProjectionImpl getProjectionImpl() {
        return this.project;
    }

    public ProjectionRect normalizeRectangle(ProjectionRect bb) {
        if (bb == null || this.project == null || !this.project.isLatLon()) {
            return bb;
        }
        ProjectionRect newRect = new ProjectionRect(bb);
        double maxLon = newRect.getX() + newRect.getWidth();
        double normalizedMaxLon = LatLonPointImpl.lonNormal(maxLon);
        newRect.setX(newRect.getX() + (normalizedMaxLon - maxLon));
        double minLon = newRect.getX();
        double normalizedMinLon = LatLonPointImpl.lonNormal(minLon);
        newRect.setX(newRect.getX() + (normalizedMinLon - minLon));
        while (newRect.getX() + newRect.getWidth() > 360.0) {
            newRect.setX(newRect.getX() - 360.0);
        }
        return newRect;
    }

    public void setProjectionImpl(ProjectionImpl p) {
        this.project = p;
        this.navigate.setMapArea(this.normalizeRectangle(this.project.getDefaultMapArea()));
        if (this.hasReference) {
            this.refWorld.setLocation(this.project.latLonToProj(this.refLatLon));
        }
    }

    public void setPositionLabel(JLabel l) {
        this.statusLabel = l;
    }

    public JToolBar getNavToolBar() {
        return new NToolBar();
    }

    public JToolBar getMoveToolBar() {
        return new MoveToolBar();
    }

    public void addActionsToMenu(JMenu menu) {
        BAMutil.addActionToMenu(menu, this.zoomIn);
        BAMutil.addActionToMenu(menu, this.zoomOut);
        BAMutil.addActionToMenu(menu, this.zoomBack);
        BAMutil.addActionToMenu(menu, this.zoomDefault);
        menu.addSeparator();
        BAMutil.addActionToMenu(menu, this.moveUp);
        BAMutil.addActionToMenu(menu, this.moveDown);
        BAMutil.addActionToMenu(menu, this.moveRight);
        BAMutil.addActionToMenu(menu, this.moveLeft);
        menu.addSeparator();
        BAMutil.addActionToMenu(menu, this.setReferenceAction);
    }

    private void redrawLater(int delay) {
        boolean already;
        boolean bl = already = this.redrawTimer != null && this.redrawTimer.isRunning();
        if (already) {
            return;
        }
        if (this.redrawTimer == null) {
            this.redrawTimer = new Timer(0, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NavigatedPanel.this.drawG();
                    NavigatedPanel.this.redrawTimer.stop();
                }
            });
        }
        this.redrawTimer.setDelay(delay);
        this.redrawTimer.start();
    }

    public void setChangeable(boolean mode) {
        if (mode == this.changeable) {
            return;
        }
        this.changeable = mode;
        if (this.toolbar != null) {
            this.toolbar.setEnabled(mode);
        }
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        ++this.repaintCount;
        super.repaint(tm, x, y, width, height);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.draw((Graphics2D)g);
    }

    public BufferedImage getBufferedImage() {
        return this.bImage;
    }

    public Graphics2D getBufferedImageGraphics() {
        if (this.bImage == null) {
            return null;
        }
        Graphics2D g2 = this.bImage.createGraphics();
        this.navigate.getMapArea(this.boundingBox);
        g2.setTransform(this.navigate.getTransform());
        g2.setStroke(new BasicStroke(0.0f));
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.setClip(NavigatedPanel.ProjRectToRectangle2D(this.boundingBox));
        Color foo = Color.red;
        g2.setBackground(foo);
        return g2;
    }

    public boolean wantRotate(double pwidth, double pheight) {
        return this.navigate.wantRotate(pwidth, pheight);
    }

    public AffineTransform calcTransform(boolean rotate, double displayX, double displayY, double displayWidth, double displayHeight) {
        return this.navigate.calcTransform(rotate, displayX, displayY, displayWidth, displayHeight);
    }

    private void setNewBounds(Rectangle b, boolean force) {
        boolean sameSize;
        boolean bl = sameSize = b.width == this.myBounds.width && b.height == this.myBounds.height;
        if (!force && sameSize && b.x == this.myBounds.x && b.y == this.myBounds.y) {
            return;
        }
        this.myBounds.setBounds(b);
        if (!force && sameSize) {
            return;
        }
        this.bImage = b.width > 0 && b.height > 0 ? new BufferedImage(b.width, b.height, 1) : null;
        this.navigate.setScreenSize(b.width, b.height);
    }

    public void drawG() {
        Graphics g = this.getGraphics();
        if (null != g) {
            this.draw((Graphics2D)g);
            g.dispose();
        }
    }

    private void draw(Graphics2D g) {
        if (this.bImage == null) {
            return;
        }
        boolean redrawReference = true;
        Rectangle bounds = this.getBounds();
        Color color = this.getBackgroundColor();
        if (this.draggingMode) {
            g.setBackground(color);
            g.clearRect(0, 0, bounds.width, bounds.height);
            g.drawImage(this.bImage, this.deltax, this.deltay, color, this.imageObs);
            redrawReference = false;
        } else {
            g.drawImage(this.bImage, 0, 0, color, this.imageObs);
        }
        if (this.hasReference && redrawReference) {
            this.refWorld.setLocation(this.project.latLonToProj(this.refLatLon));
            this.navigate.worldToScreen(this.refWorld, this.refScreen);
            int px = (int)this.refScreen.getX();
            int py = (int)this.refScreen.getY();
            g.setColor(Color.red);
            g.setStroke(new BasicStroke(2.0f));
            g.drawLine(px, py - this.referenceSize, px, py + this.referenceSize);
            g.drawLine(px - this.referenceSize, py, px + this.referenceSize, py);
        }
        if (this.selectedRegion != null) {
            Rectangle2D screenRect = this.navigate.worldToScreen(this.selectedRegion);
            g.setColor(Color.cyan);
            Stroke stroke = g.getStroke();
            g.setStroke(new BasicStroke(2.0f));
            g.draw(screenRect);
            g.setStroke(stroke);
            if (this.selectRegionMode) {
                g.setColor(Color.black);
                Glyph.paintSelectionPoints(g, screenRect, 6);
            }
        }
        this.changedSinceDraw = false;
    }

    private LatLonRect screenToEarth(RectangularShape r) {
        LatLonPoint ul = this.screenToEarth(new Point2D.Double(r.getX(), r.getY()));
        LatLonPoint lr = this.screenToEarth(new Point2D.Double(r.getX() + r.getWidth(), r.getY() + r.getHeight()));
        LatLonPoint ur = this.screenToEarth(new Point2D.Double(r.getX() + r.getWidth(), r.getY()));
        LatLonPoint ll = this.screenToEarth(new Point2D.Double(r.getX(), r.getY() + r.getHeight()));
        return new LatLonRect(ll, ur);
    }

    private Rectangle2D earthToScreen(LatLonRect llr) {
        if (llr == null) {
            return null;
        }
        Point2D ul = this.earthToScreen(llr.getUpperLeftPoint());
        Point2D lr = this.earthToScreen(llr.getLowerRightPoint());
        Point2D ll = this.earthToScreen(llr.getLowerLeftPoint());
        Point2D ur = this.earthToScreen(llr.getUpperRightPoint());
        int x1 = (int)Math.min(ll.getX(), ur.getX());
        int x2 = (int)Math.max(ll.getX(), ur.getX());
        int y1 = (int)Math.min(ll.getY(), ur.getY());
        int y2 = (int)Math.max(ll.getY(), ur.getY());
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public LatLonPoint screenToEarth(Point2D p) {
        ProjectionPointImpl ppi = this.navigate.screenToWorld(p, new ProjectionPointImpl());
        return this.project.projToLatLon(ppi, new LatLonPointImpl());
    }

    public Point2D earthToScreen(LatLonPoint llp) {
        ProjectionPointImpl ppi = (ProjectionPointImpl)this.project.latLonToProj(llp, new ProjectionPointImpl());
        return this.navigate.worldToScreen(ppi);
    }

    private void setCursor(int what) {
        if (what == -100) {
            if (null == this.referenceCursor) {
                this.referenceCursor = BAMutil.makeCursor("ReferencePoint");
                if (null == this.referenceCursor) {
                    return;
                }
            }
            super.setCursor(this.referenceCursor);
        } else {
            super.setCursor(Cursor.getPredefinedCursor(what));
        }
    }

    private void showStatus(int mousex, int mousey) {
        if (this.statusLabel == null && !this.lmMove.hasListeners()) {
            return;
        }
        this.navigate.screenToWorld(new Point2D.Double(mousex, mousey), this.workW);
        this.workL.set(this.project.projToLatLon(this.workW));
        if (this.lmMove.hasListeners()) {
            this.lmMove.sendEvent(new CursorMoveEvent(this, NavigatedPanel.ProjPointToPoint2D(this.workW)));
        }
        if (this.statusLabel == null) {
            return;
        }
        this.sbuff.setLength(0);
        this.sbuff.append(this.workL.toString());
        if (Debug.isSet("projection.showPosition")) {
            this.sbuff.append(" " + this.workW);
        }
        if (this.hasReference) {
            Bearing workB = Bearing.calculateBearing(this.refLatLon, this.workL);
            this.sbuff.append("  (");
            this.sbuff.append(Format.dfrac(workB.getAngle(), 0));
            this.sbuff.append(" deg ");
            this.sbuff.append(Format.d(workB.getDistance(), 4, 5));
            this.sbuff.append(" km)");
        }
        this.statusLabel.setText(this.sbuff.toString());
    }

    private void setReferenceMode() {
        if (this.setReferenceMode) {
            this.setReferenceMode = false;
            this.setCursor(0);
            this.statusLabel.setToolTipText("position at cursor");
            this.drawG();
        } else {
            this.hasReference = false;
            this.setReferenceMode = true;
            this.setCursor(1);
            this.statusLabel.setToolTipText("position (bearing)");
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            LatLonPoint llp = this.screenToEarth(new Point2D.Double(e.getX(), e.getY()));
            return;
        }
        if (!this.setReferenceMode) {
            this.navigate.screenToWorld(new Point2D.Double(e.getX(), e.getY()), this.workW);
            if (this.lmPick != null) {
                this.lmPick.sendEvent(new PickEvent((Object)this, NavigatedPanel.ProjPointToPoint2D(this.workW), e));
            }
        }
    }

    public boolean shouldSelectRegion(MouseEvent e) {
        return this.selectRegionMode && !SwingUtilities.isRightMouseButton(e) && !e.isControlDown() && !e.isShiftDown();
    }

    public ProjectionRect earthToWorld(LatLonRect llr) {
        Rectangle2D screenRegion = this.earthToScreen(llr);
        return new ProjectionRect(this.navigate.screenToWorld(screenRegion));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.requestFocus();
        this.startX = e.getX();
        this.startY = e.getY();
        this.regionDragPoint = null;
        if (this.shouldSelectRegion(e)) {
            if (this.selectedRegion == null) {
                this.screenRegion = new Rectangle2D.Double(this.startX - 2, this.startY - 2, 4.0, 4.0);
                this.selectedRegion = new ProjectionRect(this.navigate.screenToWorld(this.screenRegion));
                this.regionDragPoint = "LR";
            } else {
                this.screenRegion = this.navigate.worldToScreen(this.selectedRegion);
                double minDistance = GuiUtils.distance(this.startX, this.startY, this.screenRegion);
                if (minDistance < 25.0) {
                    this.regionDragPoint = Glyph.getStretchPoint(this.screenRegion, this.startX, this.startY);
                }
            }
            if (this.regionDragPoint != null) {
                this.setCursor(Glyph.getCursor(this.regionDragPoint));
            }
            this.selectedRegionChanged();
            return;
        }
        if (!this.changeable) {
            return;
        }
        if (this.setReferenceMode && !SwingUtilities.isRightMouseButton(e)) {
            this.hasReference = true;
            this.refScreen.setLocation(this.startX, this.startY);
            this.navigate.screenToWorld(this.refScreen, this.refWorld);
            this.refLatLon.set(this.project.projToLatLon(this.refWorld));
            this.setCursor(-100);
            this.drawG();
        } else if (!SwingUtilities.isRightMouseButton(e)) {
            this.zoomRB.setActive(true);
            this.zoomRB.anchor(e.getPoint());
            this.zoomingMode = true;
        } else {
            this.draggingMode = true;
            this.setCursor(13);
        }
    }

    protected void selectedRegionChanged() {
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.shouldSelectRegion(e) && this.screenRegion != null) {
            this.selectedRegion = new ProjectionRect(this.navigate.screenToWorld(this.screenRegion));
            this.selectedRegionChanged();
        }
        if (!this.changeable) {
            return;
        }
        this.setCursor(0);
        this.deltax = e.getX() - this.startX;
        this.deltay = e.getY() - this.startY;
        if (this.selectRegionMode) {
            // empty if block
        }
        if (this.draggingMode) {
            this.navigate.pan(-this.deltax, -this.deltay);
            this.draggingMode = false;
            this.setCursor(0);
        }
        if (this.zoomingMode) {
            this.zoomRB.setActive(false);
            this.zoomRB.end(e.getPoint());
            this.zoomingMode = false;
            if (!this.myBounds.contains(e.getPoint())) {
                return;
            }
            this.startX = Math.min(this.startX, e.getX());
            this.startY = Math.min(this.startY, e.getY());
            if (this.lmPick != null && (e.isControlDown() || e.isShiftDown())) {
                int w = Math.abs(this.deltax);
                int h = Math.abs(this.deltay);
                Rectangle2D.Double screenRect = new Rectangle2D.Double(this.startX, this.startY, w, h);
                this.lmPick.sendEvent(new PickEvent((Object)this, screenRect, e));
            } else {
                this.navigate.zoom(this.startX, this.startY, Math.abs(this.deltax), Math.abs(this.deltay));
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.regionDragPoint != null) {
            int newX = e.getX();
            int newY = e.getY();
            Rectangle r = Glyph.toRect(this.screenRegion);
            this.regionDragPoint = this.regionDragPoint.equals("MM") ? Glyph.stretchTo(r, newX - this.startX, newY - this.startY, this.regionDragPoint) : Glyph.stretchTo(r, newX, newY, this.regionDragPoint);
            this.screenRegion = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
            this.clipScreenRegion();
            this.selectedRegion = new ProjectionRect(this.navigate.screenToWorld(this.screenRegion));
            this.selectedRegionChanged();
            this.startX = newX;
            this.startY = newY;
            this.repaint();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (!this.changeable) {
            return;
        }
        if (this.zoomingMode) {
            return;
        }
        this.deltax = e.getX() - this.startX;
        this.deltay = e.getY() - this.startY;
        this.repaint();
    }

    private void clipScreenRegion() {
        if (this.selectedRegionBounds != null) {
            Rectangle2D bounds = this.navigate.worldToScreen(this.selectedRegionBounds);
            Rectangle2D clipped = bounds.createIntersection(this.screenRegion);
            this.screenRegion = new Rectangle2D.Double(clipped.getX(), clipped.getY(), clipped.getWidth(), clipped.getHeight());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.draggingMode) {
            this.showStatus(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.selectRegionMode) {
            if (GuiUtils.isDeleteEvent(e)) {
                this.selectedRegion = null;
                this.selectedRegionChanged();
                this.repaint();
            } else if (e.getKeyCode() == 82 && e.isControlDown()) {
                this.selectedRegion = this.getMapArea();
                this.screenRegion = this.navigate.worldToScreen(this.selectedRegion);
                this.clipScreenRegion();
                this.selectedRegion = new ProjectionRect(this.navigate.screenToWorld(this.screenRegion));
                this.selectedRegionChanged();
                this.repaint();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void doZoomIn() {
        this.navigate.zoomIn();
        this.drawG();
    }

    public void doZoomOut() {
        this.navigate.zoomOut();
        this.drawG();
    }

    public void zoom(double zoomFactor) {
        this.navigate.zoom(zoomFactor);
        this.drawG();
    }

    public void doMoveUp(double factor) {
        this.navigate.moveUp(factor);
        this.drawG();
    }

    public void doMoveDown(double factor) {
        this.navigate.moveDown(factor);
        this.drawG();
    }

    public void doMoveRight(double factor) {
        this.navigate.moveRight(factor);
        this.drawG();
    }

    public void doMoveLeft(double factor) {
        this.navigate.moveLeft(factor);
        this.drawG();
    }

    private void makeActions() {
        this.zoomIn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.doZoomIn();
            }
        };
        BAMutil.setActionProperties(this.zoomIn, "ZoomIn16", "Zoom In", false, 73, 107);
        this.zoomOut = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.doZoomOut();
            }
        };
        BAMutil.setActionProperties(this.zoomOut, "ZoomOut16", "Zoom Out", false, 79, 109);
        this.zoomBack = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.flipLon();
            }
        };
        BAMutil.setActionProperties(this.zoomBack, "Undo16", "Flip map longitude", false, 80, 8);
        this.zoomDefault = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.resetZoom();
            }
        };
        BAMutil.setActionProperties(this.zoomDefault, "Home16", "Home map area", false, 72, 36);
        this.moveUp = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.doMoveUp(2.0);
            }
        };
        BAMutil.setActionProperties(this.moveUp, "Up16", "Move view up", false, 85, 38);
        this.moveDown = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.doMoveDown(2.0);
            }
        };
        BAMutil.setActionProperties(this.moveDown, "Down16", "Move view down", false, 68, 40);
        this.moveLeft = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.doMoveLeft(2.0);
            }
        };
        BAMutil.setActionProperties(this.moveLeft, "Left16", "Move view left", false, 76, 37);
        this.moveRight = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.doMoveRight(2.0);
            }
        };
        BAMutil.setActionProperties(this.moveRight, "Right16", "Move view right", false, 82, 39);
        this.setReferenceAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.setReferenceMode();
                NavigatedPanel.this.drawG();
            }
        };
        BAMutil.setActionProperties(this.setReferenceAction, "ReferencePoint", "Set reference Point", true, 80, 0);
    }

    public void resetZoom() {
        this.navigate.setMapArea(this.normalizeRectangle(this.project.getDefaultMapArea()));
        this.drawG();
    }

    public void flipLon() {
        this.navigate.flipMapArea(this.normalizeRectangle(this.project.getDefaultMapArea()));
        this.drawG();
    }

    public void setSelectRegionMode(boolean value) {
        this.selectRegionMode = value;
        if (value) {
            this.setToolTipText("<html>Change to Select a Region option in the menu and Drag to select region<br>Press 'Delete' (or Control-D) to clear selected region<br>Press Control-R to reset selected region</html>");
        }
    }

    public void setSelectedRegionBounds(ProjectionRect bounds) {
        this.selectedRegionBounds = this.normalizeRectangle(bounds);
    }

    public boolean getSelectRegionMode() {
        return this.selectRegionMode;
    }

    public void setSelectedRegion(ProjectionRect value) {
        this.selectedRegion = value;
    }

    public void setSelectedRegion(LatLonRect llr) {
        if (llr == null) {
            this.setSelectedRegion((ProjectionRect)null);
        } else {
            this.setSelectedRegion(this.earthToWorld(llr));
        }
    }

    public ProjectionRect getSelectedRegion() {
        return this.selectedRegion;
    }

    public LatLonRect getSelectedEarthRegion() {
        if (this.selectedRegion == null) {
            return null;
        }
        return this.screenToEarth(this.navigate.worldToScreen(this.selectedRegion));
    }

    class MoveToolBar
    extends JToolBar {
        MoveToolBar() {
            this.setFloatable(false);
            AbstractButton b = BAMutil.addActionToContainer(this, NavigatedPanel.this.moveUp);
            b.setName("moveUp");
            b = BAMutil.addActionToContainer(this, NavigatedPanel.this.moveDown);
            b.setName("moveDown");
            b = BAMutil.addActionToContainer(this, NavigatedPanel.this.moveLeft);
            b.setName("moveLeft");
            b = BAMutil.addActionToContainer(this, NavigatedPanel.this.moveRight);
            b.setName("moveRight");
        }
    }

    class NToolBar
    extends JToolBar {
        NToolBar() {
            this.setFloatable(false);
            AbstractButton b = BAMutil.addActionToContainer(this, NavigatedPanel.this.zoomIn);
            b.setName("zoomIn");
            b = BAMutil.addActionToContainer(this, NavigatedPanel.this.zoomOut);
            b.setName("zoomOut");
            b = BAMutil.addActionToContainer(this, NavigatedPanel.this.zoomBack);
            b.setName("zoomBack");
            b = BAMutil.addActionToContainer(this, NavigatedPanel.this.zoomDefault);
            b.setName("zoomHome");
        }
    }

    private class myDropTargetListener
    implements DropTargetListener {
        private myDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            System.out.println(" NP dragEnter active = " + NavigatedPanel.this.dropTarget.isActive());
            e.acceptDrag(1);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            try {
                if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    Transferable tr = e.getTransferable();
                    e.acceptDrop(3);
                    String s = (String)tr.getTransferData(DataFlavor.stringFlavor);
                    System.out.println(" NP myDropTargetListener got " + s);
                    e.dropComplete(true);
                } else {
                    e.rejectDrop();
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                e.rejectDrop();
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
                e.rejectDrop();
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    private class myImageObserver
    implements ImageObserver {
        private myImageObserver() {
        }

        @Override
        public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
            return true;
        }
    }
}

