/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import edu.wisc.ssec.mcidas.AreaFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.gis.mcidasmap.McidasMap;
import ucar.unidata.view.Renderer;
import ucar.unidata.view.geoloc.NavigatedPanel;
import ucar.unidata.view.geoloc.NewMapAreaEvent;
import ucar.unidata.view.geoloc.NewMapAreaListener;
import ucar.unidata.view.geoloc.PickEvent;
import ucar.unidata.view.geoloc.PickEventListener;
import ucar.visad.MapProjectionProjection;
import visad.data.mcidas.AREACoordinateSystem;
import visad.georef.MapProjection;

public class NavigatedMapPanel
extends JPanel {
    public static final String DEFAULT_MAP = "/auxdata/maps/OUTLSUPW";
    public static List DEFAULT_MAPS;
    protected NavigatedPanel navigatedPanel;
    private List mapRenderers = new ArrayList();
    private AffineTransform atI = new AffineTransform();
    LatLonPoint ul;
    LatLonPoint lr;
    private MapProjection project;
    BufferedImage preview_image;
    private int data_width;
    private int data_height;
    GeneralPath gp;

    public NavigatedMapPanel() {
        this((List)null, true);
    }

    public NavigatedMapPanel(boolean makeToolBar) {
        this(makeToolBar, makeToolBar);
    }

    public NavigatedMapPanel(boolean makeNavToolBar, boolean makeMoveToolBar) {
        this(null, makeNavToolBar, makeMoveToolBar);
    }

    public NavigatedMapPanel(String defaultMap) {
        this(NavigatedMapPanel.makeMapList(defaultMap), true);
    }

    public NavigatedMapPanel(List maps) {
        this(maps, true);
    }

    public NavigatedMapPanel(List defaultMaps, boolean makeToolBar) {
        this(defaultMaps, makeToolBar, makeToolBar);
    }

    public NavigatedMapPanel(List defaultMaps, boolean makeNavToolBar, boolean makeMoveToolBar) {
        this.init(defaultMaps, makeNavToolBar, makeMoveToolBar);
    }

    public NavigatedMapPanel(List defaultMaps, boolean makeNavToolBar, boolean makeMoveToolBar, BufferedImage preview_image, AreaFile af) {
        this.init(defaultMaps, makeNavToolBar, makeMoveToolBar);
        this.preview_image = preview_image;
        try {
            AREACoordinateSystem acs = null;
            acs = new AREACoordinateSystem(af);
            this.project = acs;
        }
        catch (Exception acs) {
            // empty catch block
        }
        NavigatedPanel np = this.getNavigatedPanel();
        if (this.project != null) {
            Object sets = null;
            this.setProjectionImpl(new MapProjectionProjection(this.project));
            this.data_width = preview_image.getWidth();
            this.data_height = preview_image.getHeight();
            float[][] samples = null;
            Rectangle2D rect2D = this.project.getDefaultMapArea();
            ProjectionRect rect = new ProjectionRect(rect2D.getMinX(), rect2D.getMinY(), rect2D.getMaxX(), rect2D.getMaxY());
            np.setMapArea(rect);
            float ymag = (float)((AREACoordinateSystem)this.project).getDirBlock()[8] * 1.0f / (float)this.data_height;
            float xmag = (float)((AREACoordinateSystem)this.project).getDirBlock()[9] * 1.0f / (float)this.data_width;
            if (null != this.preview_image) {
                AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
                tx.scale(xmag, ymag);
                tx.translate(0.0, -this.preview_image.getHeight(null));
                AffineTransformOp op = new AffineTransformOp(tx, 1);
                this.preview_image = op.filter(this.preview_image, null);
            }
        }
        np.setSelectRegionMode(true);
        this.gp = new GeneralPath();
    }

    protected NavigatedPanel doMakeMapPanel() {
        return new NavigatedPanel(){

            @Override
            public void resetZoom() {
                NavigatedPanel np = NavigatedMapPanel.this.getNavigatedPanel();
                Rectangle2D rect2D = NavigatedMapPanel.this.project.getDefaultMapArea();
                ProjectionRect rect = new ProjectionRect(rect2D.getMinX(), rect2D.getMinY(), rect2D.getMaxX(), rect2D.getMaxY());
                np.setMapArea(rect);
                this.drawG();
            }
        };
    }

    private void init(List maps, boolean makeNavToolBar, boolean makeMoveToolBar) {
        if (!(maps != null && maps.size() != 0 || (maps = DEFAULT_MAPS) != null && maps.size() != 0)) {
            maps = new ArrayList();
            maps.add(DEFAULT_MAP);
        }
        maps = new ArrayList<String>(maps);
        this.navigatedPanel = this.doMakeMapPanel();
        Dimension d = new Dimension(this.data_width, this.data_height);
        this.navigatedPanel.setPreferredSize(d);
        this.navigatedPanel.setSize(d);
        for (int i = 0; i < maps.size(); ++i) {
            McidasMap mapRender = new McidasMap(maps.get(i).toString());
            this.addMapRenderer(mapRender);
        }
        final DecimalFormat df2 = new DecimalFormat("#.##");
        this.navigatedPanel.addNewMapAreaListener(new NewMapAreaListener(){

            @Override
            public void actionPerformed(NewMapAreaEvent e) {
                ProjectionImpl project = NavigatedMapPanel.this.getProjection();
                if (project.isLatLon()) {
                    if (e.getIsFlip() && project.getDefaultMapArea().getWidth() == 360.0) {
                        ProjectionRect boundingBox = NavigatedMapPanel.this.navigatedPanel.getMapArea();
                        double wx0 = boundingBox.getX() + boundingBox.getWidth() / 2.0;
                        LatLonProjection llproj = (LatLonProjection)project;
                        String centerLonStr = df2.format(llproj.getCenterLon());
                        double centerLon = Double.valueOf(centerLonStr);
                        String startXStr = df2.format(llproj.getDefaultMapArea().getX());
                        double startX = Double.valueOf(startXStr);
                        if (centerLon == 180.0 && startX == 0.0) {
                            llproj.setCenterLon(0.0);
                            ProjectionRect rect = ((LatLonProjection)project).getDefaultMapArea();
                            rect.setX(-180.0);
                            project.setDefaultMapArea(rect);
                            NavigatedMapPanel.this.applyProjectionToRenderers(project);
                            NavigatedMapPanel.this.navigatedPanel.setWorldCenterX(0.0);
                            boundingBox.setX(-180.0);
                            NavigatedMapPanel.this.resetBounds(rect);
                            NavigatedMapPanel.this.navigatedPanel.setSelectedRegionBounds(rect);
                            System.out.println("yyyy " + wx0);
                        } else if (centerLon == 0.0 && startX == -180.0) {
                            llproj.setCenterLon(180.0);
                            ProjectionRect rect = ((LatLonProjection)project).getDefaultMapArea();
                            rect.setX(0.0);
                            project.setDefaultMapArea(rect);
                            NavigatedMapPanel.this.applyProjectionToRenderers(project);
                            NavigatedMapPanel.this.navigatedPanel.setWorldCenterX(180.0);
                            boundingBox.setX(-180.0);
                            NavigatedMapPanel.this.resetBounds(rect);
                            NavigatedMapPanel.this.navigatedPanel.setSelectedRegionBounds(rect);
                        }
                    } else {
                        ProjectionRect boundingBox = NavigatedMapPanel.this.navigatedPanel.getMapArea();
                        double wx0 = boundingBox.getX() + boundingBox.getWidth() / 2.0;
                        LatLonProjection llproj = (LatLonProjection)project;
                        if (llproj.getCenterLon() != wx0) {
                            llproj.setCenterLon(wx0);
                            wx0 = llproj.getCenterLon();
                            NavigatedMapPanel.this.applyProjectionToRenderers(project);
                            NavigatedMapPanel.this.navigatedPanel.setWorldCenterX(wx0);
                        }
                    }
                }
                NavigatedMapPanel.this.redraw();
            }
        });
        this.navigatedPanel.addPickEventListener(new PickEventListener(){

            @Override
            public void actionPerformed(PickEvent e) {
                if (e.isPointSelect()) {
                    NavigatedMapPanel.this.doPickPoint(e);
                } else {
                    NavigatedMapPanel.this.doPickRegion(e);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.navigatedPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(new EtchedBorder());
        JLabel positionLabel = new JLabel("position");
        statusPanel.add((Component)positionLabel, "Center");
        this.navigatedPanel.setPositionLabel(positionLabel);
        if (makeNavToolBar || makeMoveToolBar) {
            JPanel toolPanel = new JPanel(new FlowLayout(0));
            if (makeNavToolBar) {
                toolPanel.add(this.navigatedPanel.getNavToolBar());
            }
            if (makeMoveToolBar) {
                toolPanel.add(this.navigatedPanel.getMoveToolBar());
            }
            this.add((Component)toolPanel, "South");
        }
        this.add((Component)this.navigatedPanel, "Center");
        this.redraw();
    }

    public void resetBounds(ProjectionRect rect) {
    }

    private static List makeMapList(String map) {
        if (map == null) {
            map = DEFAULT_MAP;
        }
        ArrayList<String> maps = new ArrayList<String>();
        maps.add(map);
        return maps;
    }

    public void setDrawBounds(double ulx, double uly, double lrx, double lry) {
        this.ul = new LatLonPointImpl(uly, ulx);
        this.lr = new LatLonPointImpl(lry, lrx);
        this.redraw();
    }

    public void setDrawBounds(LatLonPoint ul, LatLonPoint lr) {
        this.ul = ul == null ? null : new LatLonPointImpl(ul);
        this.lr = lr == null ? null : new LatLonPointImpl(lr);
        this.redraw();
    }

    private void doPickRegion(PickEvent pickEvent) {
        this.redraw();
    }

    protected void doPickPoint(PickEvent e) {
        this.redraw();
    }

    public NavigatedPanel getNavigatedPanel() {
        return this.navigatedPanel;
    }

    public void setMapRenderer(Renderer r) {
        this.mapRenderers = new ArrayList();
        this.addMapRenderer(r);
        this.redraw();
    }

    public void addMapRenderer(Renderer r) {
        ProjectionImpl project = this.getProjection();
        if (project != null) {
            r.setProjection(project);
        }
        this.mapRenderers.add(r);
    }

    private void applyProjectionToRenderers(ProjectionImpl project) {
        for (int i = 0; i < this.mapRenderers.size(); ++i) {
            ((Renderer)this.mapRenderers.get(i)).setProjection(project);
        }
    }

    public void setProjectionImpl(ProjectionImpl p) {
        this.navigatedPanel.setProjectionImpl(p);
        this.applyProjectionToRenderers(p);
        this.redraw();
    }

    public ProjectionImpl getProjectionImpl() {
        return this.navigatedPanel.getProjectionImpl();
    }

    public void redraw() {
        Graphics2D gNP = this.navigatedPanel.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.navigatedPanel.getBackgroundColor());
        Rectangle r = gNP.getClipBounds();
        gNP.clearRect(r.x, r.y, r.width, r.height);
        Graphics2D g2d = gNP;
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (null != this.preview_image) {
            float[] scales = new float[]{1.0f, 1.0f, 1.0f, 0.5f};
            float[] offsets = new float[4];
            RescaleOp rop = new RescaleOp(scales, offsets, null);
            g2d.drawImage((Image)this.preview_image, 0, 0, this);
        }
        if (this.gp != null) {
            g2d.setColor(Color.BLUE);
            g2d.draw(this.gp);
            g2d.setColor(Color.CYAN);
        }
        for (int i = 0; i < this.mapRenderers.size(); ++i) {
            ((Renderer)this.mapRenderers.get(i)).draw(gNP, this.atI);
        }
        this.annotateMap(gNP);
        gNP.dispose();
        this.navigatedPanel.repaint();
    }

    protected void annotateMap(Graphics2D gNP) {
        if (this.ul != null && this.lr != null) {
            ProjectionImpl project = this.getProjection();
            ProjectionPointImpl ulpp = (ProjectionPointImpl)project.latLonToProj(this.ul, new ProjectionPointImpl());
            ProjectionPointImpl lrpp = (ProjectionPointImpl)project.latLonToProj(this.lr, new ProjectionPointImpl());
            GeneralPath path = new GeneralPath(0, 4);
            path.moveTo((float)ulpp.getX(), (float)ulpp.getY());
            path.lineTo((float)lrpp.getX(), (float)ulpp.getY());
            path.lineTo((float)lrpp.getX(), (float)lrpp.getY());
            path.lineTo((float)ulpp.getX(), (float)lrpp.getY());
            path.lineTo((float)ulpp.getX(), (float)ulpp.getY());
            gNP.setColor(Color.red);
            gNP.draw(path);
        }
    }

    protected ProjectionImpl getProjection() {
        return this.navigatedPanel.getProjectionImpl();
    }
}

