/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JToolBar;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import visad.VisADException;

public class NavigatedDisplayToolBar
extends JToolBar {
    private NavigatedDisplay navDisplay;
    public static final double TRANSLATE_FACTOR = 0.1;
    public static final double ZOOM_FACTOR = 1.2;

    public NavigatedDisplayToolBar(NavigatedDisplay navDisplay) {
        this(navDisplay, 0);
    }

    public NavigatedDisplayToolBar(NavigatedDisplay navDisplay, int orientation) {
        this(navDisplay, orientation, false);
    }

    public NavigatedDisplayToolBar(NavigatedDisplay navDisplay, int orientation, boolean floatable) {
        super("Navigated Display Toolbar", orientation);
        this.navDisplay = navDisplay;
        this.setFloatable(floatable);
        this.makeToolBar();
    }

    public void destroy() {
        this.navDisplay = null;
    }

    public void setNavigatedDisplay(NavigatedDisplay navDisplay) {
        this.navDisplay = navDisplay;
    }

    private JButton makeButton(String path, String toolTip) {
        JButton button = GuiUtils.getScaledImageButton(path, this.getClass(), 0, 0);
        button.setToolTipText(toolTip);
        this.add(button);
        return button;
    }

    private void makeToolBar() {
        JButton button = this.makeButton("/auxdata/ui/icons/magnifier_zoom_in.png", "Zoom in");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedDisplayToolBar.this.navDisplay.zoom(1.2);
            }
        });
        button = this.makeButton("/auxdata/ui/icons/magnifier_zoom_out.png", "Zoom out");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedDisplayToolBar.this.navDisplay.zoom(0.8333333333333334);
            }
        });
        button = this.makeButton("/auxdata/ui/icons/house.png", "Reset Display Projection");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NavigatedDisplayToolBar.this.navDisplay.resetScaleTranslate();
                }
                catch (VisADException ve) {
                    ve.printStackTrace();
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
            }
        });
        button = this.makeButton("/auxdata/ui/icons/arrow_left.png", "Translate left");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedDisplayToolBar.this.navDisplay.translate(0.1, 0.0);
            }
        });
        button = this.makeButton("/auxdata/ui/icons/arrow_right.png", "Translate right");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedDisplayToolBar.this.navDisplay.translate(-0.1, 0.0);
            }
        });
        button = this.makeButton("/auxdata/ui/icons/arrow_up.png", "Translate up");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedDisplayToolBar.this.navDisplay.translate(0.0, -0.1);
            }
        });
        button = this.makeButton("/auxdata/ui/icons/arrow_down.png", "Translate down");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedDisplayToolBar.this.navDisplay.translate(0.0, 0.1);
            }
        });
    }
}

